/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities.arbalist;

import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.skills.abilities.Ability;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsPro;
import org.skills.utils.MathUtils;

public class ArbalistDualArrows
extends Ability {
    public static final String COUNT = "ARBALIST_DUAL_COUNT";
    public static final String SOURCE = "ARBALIST_DUAL_SOURCE";

    public ArbalistDualArrows() {
        super("Arbalist", "dual_arrows");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (this.isInvalidTarget(entityDamageByEntityEvent.getEntity())) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (!(entity instanceof Arrow)) {
            return;
        }
        if (entity.hasMetadata("ARBALIST")) {
            return;
        }
        if (!(((Arrow)entity).getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)((Arrow)entityDamageByEntityEvent.getDamager()).getShooter();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        double d = this.getScaling(skilledPlayer, "damage", entityDamageByEntityEvent);
        entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + d);
    }

    public static Vector rotateAroundY(Vector vector, double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = d2 * vector.getX() + d3 * vector.getZ();
        double d5 = -d3 * vector.getX() + d2 * vector.getZ();
        return vector.setX(d4).setZ(d5);
    }

    public static Vector arrow(Vector vector, double d, double d2) {
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        double d3 = 0.0075f;
        return vector.normalize().add(new Vector(threadLocalRandom.nextGaussian() * d3 * d2, threadLocalRandom.nextGaussian() * d3 * d2, threadLocalRandom.nextGaussian() * d3 * d2)).multiply(d);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onArrowLaunch(ProjectileLaunchEvent projectileLaunchEvent) {
        Projectile projectile = projectileLaunchEvent.getEntity();
        if (!(projectile instanceof Arrow)) {
            return;
        }
        if (!(projectile.getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)projectile.getShooter();
        SkilledPlayer skilledPlayer = this.checkup(player);
        if (skilledPlayer == null) {
            return;
        }
        if (!projectile.getMetadata("ARBALIST_CROSS").isEmpty()) {
            return;
        }
        if (!MathUtils.hasChance((int)this.getScaling(skilledPlayer, "chance", new Object[0]))) {
            return;
        }
        double d = this.getScaling(skilledPlayer, "spread", new Object[0]);
        Vector vector = projectile.getVelocity().clone();
        float f = (float)projectile.getVelocity().length();
        do {
            Arrow arrow = player.getWorld().spawnArrow(player.getEyeLocation(), vector, f, (float)d);
            arrow.setFireTicks((int)this.getScaling(skilledPlayer, "fire", new Object[0]));
            arrow.setMetadata("ARBALIST", (MetadataValue)new FixedMetadataValue((Plugin)SkillsPro.get(), null));
        } while (MathUtils.hasChance((int)this.getScaling(skilledPlayer, "chance", new Object[0])));
    }
}

