/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities;

import java.util.HashMap;
import java.util.Map;
import org.skills.abilities.KeyBindingException;
import org.skills.utils.StringUtils;

public enum KeyBinding {
    RIGHT_CLICK('R'),
    LEFT_CLICK('L'),
    SNEAK('S'),
    DROP('Q'),
    SWITCH('F');

    public static final Map<Character, KeyBinding> SHORT_NAME_BINDINGS;
    public final char shortName;

    private KeyBinding(char c) {
        this.shortName = c;
    }

    public static KeyBinding getKeyBindingFromName(char c) {
        return SHORT_NAME_BINDINGS.get(Character.valueOf(c));
    }

    public static String toString(KeyBinding[] keyBindingArray) {
        char[] cArray = new char[keyBindingArray.length];
        for (int i = 0; i < keyBindingArray.length; ++i) {
            cArray[i] = keyBindingArray[i].shortName;
        }
        return new String(cArray);
    }

    public static KeyBinding[] parseBinding(String string) {
        string = StringUtils.deleteWhitespace(string);
        KeyBinding[] keyBindingArray = new KeyBinding[string.length()];
        for (int i = 0; i < keyBindingArray.length; ++i) {
            KeyBinding keyBinding = KeyBinding.getKeyBindingFromName(Character.toUpperCase(string.charAt(i)));
            if (keyBinding == null) {
                throw new KeyBindingException(string, i, KeyBindingException.Reason.UNKNOWN_KEY);
            }
            keyBindingArray[i] = keyBinding;
        }
        return keyBindingArray;
    }

    public static boolean isIllegalBinding(KeyBinding[] keyBindingArray, KeyBinding[] keyBindingArray2) {
        int n = Math.min(keyBindingArray.length, keyBindingArray2.length);
        for (int i = 0; i < n; ++i) {
            if (keyBindingArray[i] == keyBindingArray2[i]) continue;
            return false;
        }
        return true;
    }

    static {
        SHORT_NAME_BINDINGS = new HashMap<Character, KeyBinding>();
        for (KeyBinding keyBinding : KeyBinding.values()) {
            SHORT_NAME_BINDINGS.put(Character.valueOf(keyBinding.shortName), keyBinding);
        }
    }
}

