/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities;

import com.google.common.base.Strings;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.skills.abilities.Ability;
import org.skills.abilities.AbilityManager;
import org.skills.abilities.KeyBinding;
import org.skills.api.events.SkillActiveStateChangeEvent;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.locale.MessageHandler;
import org.skills.services.manager.ServiceHandler;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XTag;

public abstract class ActiveAbility
extends Ability {
    private boolean isPvPBased;

    public ActiveAbility(String string, String string2) {
        super(string, string2);
    }

    public String getAbilityReady(SkilledPlayer skilledPlayer) {
        return this.getOptions(skilledPlayer).getString("activation.messages.ready");
    }

    public String getAbilityIdle(SkilledPlayer skilledPlayer) {
        return this.getOptions(skilledPlayer).getString("activation.messages.idle");
    }

    public String getAbilityActivated(SkilledPlayer skilledPlayer) {
        return this.getOptions(skilledPlayer).getString("activation.messages.activated");
    }

    public String getAbilityFinished(SkilledPlayer skilledPlayer) {
        return this.getOptions(skilledPlayer).getString("activation.messages.finished");
    }

    public int getIdle(SkilledPlayer skilledPlayer) {
        return this.getOptions(skilledPlayer).getInt("activation.idle");
    }

    public void setPvPBased(boolean bl) {
        this.isPvPBased = bl;
    }

    public boolean isPvPBased() {
        return this.isPvPBased;
    }

    public boolean isAbilityReady(Player player) {
        return SkilledPlayer.getSkilledPlayer((OfflinePlayer)player).isActiveReady();
    }

    public KeyBinding[] getActivationKey(SkilledPlayer skilledPlayer) {
        return KeyBinding.parseBinding(this.getOptions(skilledPlayer).getString("activation.key"));
    }

    public double getEnergy(SkilledPlayer skilledPlayer) {
        String string = this.getOptions(skilledPlayer).getString("activation.energy");
        return super.getAbsoluteScaling(skilledPlayer, string, new Object[0]);
    }

    public boolean isWeaponAllowed(SkilledPlayer skilledPlayer, ItemStack itemStack) {
        List list = this.getOptions(skilledPlayer).getStringList("activation.items");
        if (list.isEmpty()) {
            return true;
        }
        return XTag.anyMatch(XMaterial.matchXMaterial(itemStack), XTag.stringMatcher(list, null));
    }

    public double getCooldown(SkilledPlayer skilledPlayer) {
        String string = this.getOptions(skilledPlayer).getString("activation.cooldown");
        return super.getAbsoluteScaling(skilledPlayer, string, new Object[0]);
    }

    public void sendMessage(Player player, String string, Object ... objectArray) {
        if (Strings.isNullOrEmpty((String)string)) {
            return;
        }
        String string2 = MessageHandler.replaceVariables(ServiceHandler.translatePlaceholders((OfflinePlayer)player, string), objectArray);
        MessageHandler.sendMessage((CommandSender)player, string2, SkillsConfig.PREFIX.getBoolean());
    }

    public SkilledPlayer basicCheckup(Player player) {
        return super.checkup(player, true);
    }

    @Override
    public SkilledPlayer checkup(Player player) {
        SkilledPlayer skilledPlayer = super.checkup(player);
        if (skilledPlayer == null) {
            return null;
        }
        SkillActiveStateChangeEvent skillActiveStateChangeEvent = new SkillActiveStateChangeEvent(player, this, false);
        Bukkit.getPluginManager().callEvent((Event)skillActiveStateChangeEvent);
        if (skillActiveStateChangeEvent.isCancelled()) {
            return null;
        }
        skilledPlayer.deactivateReady();
        skilledPlayer.setEnergy(skilledPlayer.getEnergy() - this.getEnergy(skilledPlayer));
        if (!AbilityManager.getCooldownExcempts().contains(player.getUniqueId())) {
            skilledPlayer.setCooldown((long)this.getCooldown(skilledPlayer) * 1000L);
        }
        this.sendMessage(player, this.getAbilityActivated(skilledPlayer), new Object[0]);
        return skilledPlayer;
    }
}

