/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.skills.abilities.Ability;
import org.skills.abilities.arbalist.ArbalistCrossExamination;
import org.skills.abilities.arbalist.ArbalistDualArrows;
import org.skills.abilities.arbalist.ArbalistExecute;
import org.skills.abilities.arbalist.ArbalistFireCrossbow;
import org.skills.abilities.arbalist.ArbalistMinions;
import org.skills.abilities.arbalist.ArbalistPassive;
import org.skills.abilities.devourer.DevourerBlink;
import org.skills.abilities.devourer.DevourerCloak;
import org.skills.abilities.devourer.DevourerConsume;
import org.skills.abilities.devourer.DevourerDisarm;
import org.skills.abilities.devourer.DevourerGliders;
import org.skills.abilities.devourer.DevourerHook;
import org.skills.abilities.devourer.DevourerLocate;
import org.skills.abilities.devourer.DevourerPassive;
import org.skills.abilities.eidolon.EidolonBlackhole;
import org.skills.abilities.eidolon.EidolonDefile;
import org.skills.abilities.eidolon.EidolonFangs;
import org.skills.abilities.eidolon.EidolonPassive;
import org.skills.abilities.eidolon.EidolonPurify;
import org.skills.abilities.eidolon.EidolonShapeShifter;
import org.skills.abilities.eidolon.EidolonSpectre;
import org.skills.abilities.eidolon.EidolonSpiritFire;
import org.skills.abilities.firemage.FireMageAbsorbEnergy;
import org.skills.abilities.firemage.FireMageBlackFire;
import org.skills.abilities.firemage.FireMageInferno;
import org.skills.abilities.firemage.FireMageMeteorite;
import org.skills.abilities.firemage.FireMagePassive;
import org.skills.abilities.firemage.FireMagePhoenixEssence;
import org.skills.abilities.juggernaut.JuggernautAegisProtection;
import org.skills.abilities.juggernaut.JuggernautChainSmash;
import org.skills.abilities.juggernaut.JuggernautHeavyStrikes;
import org.skills.abilities.juggernaut.JuggernautPassive;
import org.skills.abilities.juggernaut.JuggernautStoneSkin;
import org.skills.abilities.juggernaut.JuggernautThrow;
import org.skills.abilities.mage.MageChronoprohiberis;
import org.skills.abilities.mage.MageEnergyFlux;
import org.skills.abilities.mage.MageExplosionSpell;
import org.skills.abilities.mage.MageHealSpell;
import org.skills.abilities.mage.MageNeptune;
import org.skills.abilities.mage.MagePassive;
import org.skills.abilities.mage.MageReflect;
import org.skills.abilities.priest.PriestAsclepius;
import org.skills.abilities.priest.PriestBarrier;
import org.skills.abilities.priest.PriestKindlingOfLife;
import org.skills.abilities.priest.PriestMindPossession;
import org.skills.abilities.priest.PriestNaturesCall;
import org.skills.abilities.priest.PriestNaturesForce;
import org.skills.abilities.priest.PriestPassive;
import org.skills.abilities.priest.PriestPurification;
import org.skills.abilities.priest.PriestSealOfLife;
import org.skills.abilities.swordsman.SwordsmanAnnihilation;
import org.skills.abilities.swordsman.SwordsmanDash;
import org.skills.abilities.swordsman.SwordsmanDodge;
import org.skills.abilities.swordsman.SwordsmanParry;
import org.skills.abilities.swordsman.SwordsmanPassive;
import org.skills.abilities.swordsman.SwordsmanPierce;
import org.skills.abilities.swordsman.SwordsmanThousandCuts;
import org.skills.abilities.vampire.VampireBleed;
import org.skills.abilities.vampire.VampireBloodCircuit;
import org.skills.abilities.vampire.VampireBloodLust;
import org.skills.abilities.vampire.VampireBloodWell;
import org.skills.abilities.vampire.VampireEternalDarkness;
import org.skills.abilities.vampire.VampirePassive;
import org.skills.abilities.vergil.VergilDoppelganger;
import org.skills.abilities.vergil.VergilJudgementCut;
import org.skills.abilities.vergil.VergilJudgementCutEnd;
import org.skills.abilities.vergil.VergilMirageEdgeSlash;
import org.skills.abilities.vergil.VergilPassive;
import org.skills.abilities.vergil.VergilPhantomBlade;
import org.skills.abilities.vergil.VergilRapidSlash;
import org.skills.abilities.vergil.VergilTrickAction;
import org.skills.abilities.vergil.VergilVerticalSlash;
import org.skills.main.SkillsPro;

public final class AbilityManager {
    private static final Map<String, Ability> ABILITIES = new HashMap<String, Ability>();
    public static final Set<String> UNSUPPORTED_ABILITIES = new HashSet<String>();
    private static final Set<UUID> COOLDOWN_EXCEMPT = new HashSet<UUID>();

    public static Set<UUID> getCooldownExcempts() {
        return COOLDOWN_EXCEMPT;
    }

    public static void registerAll() {
        Ability[] abilityArray = new Ability[]{new SwordsmanPassive(), new SwordsmanParry(), new SwordsmanPierce(), new SwordsmanDodge(), new SwordsmanThousandCuts(), new SwordsmanDash(), new SwordsmanAnnihilation(), new ArbalistPassive(), new ArbalistExecute(), new ArbalistDualArrows(), new ArbalistMinions(), new ArbalistFireCrossbow(), new ArbalistCrossExamination(), new DevourerPassive(), new DevourerGliders(), new DevourerCloak(), new DevourerBlink(), new DevourerHook(), new DevourerDisarm(), new DevourerConsume(), new DevourerLocate(), new MagePassive(), new MageReflect(), new MageExplosionSpell(), new MageHealSpell(), new MageEnergyFlux(), new MageNeptune(), new MageChronoprohiberis(), new FireMagePassive(), new FireMageAbsorbEnergy(), new FireMagePhoenixEssence(), new FireMageBlackFire(), new FireMageInferno(), new FireMageMeteorite(), new JuggernautPassive(), new JuggernautHeavyStrikes(), new JuggernautStoneSkin(), new JuggernautAegisProtection(), new JuggernautThrow(), new JuggernautChainSmash(), new VampirePassive(), new VampireBloodLust(), new VampireBloodWell(), new VampireBleed(), new VampireEternalDarkness(), new VampireBloodCircuit(), new EidolonPassive(), new EidolonPurify(), new EidolonSpiritFire(), new EidolonSpectre(), new EidolonDefile(), new EidolonShapeShifter(), new EidolonFangs(), new EidolonBlackhole(), new PriestPassive(), new PriestAsclepius(), new PriestKindlingOfLife(), new PriestMindPossession(), new PriestSealOfLife(), new PriestNaturesForce(), new PriestNaturesCall(), new PriestBarrier(), new PriestPurification(), new VergilPassive(), new VergilJudgementCut(), new VergilJudgementCutEnd(), new VergilRapidSlash(), new VergilVerticalSlash(), new VergilTrickAction(), new VergilMirageEdgeSlash(), new VergilDoppelganger(), new VergilPhantomBlade()};
        Arrays.stream(abilityArray).filter(ability -> !ability.isSupported()).forEach(ability -> UNSUPPORTED_ABILITIES.add(ability.getName()));
        Arrays.stream(abilityArray).filter(Ability::isSupported).forEach(AbilityManager::register);
    }

    public static Map<String, Ability> getAbilities() {
        return ABILITIES;
    }

    public static void register(Ability ability) {
        ABILITIES.put(ability.getName(), ability);
        Bukkit.getPluginManager().registerEvents((Listener)ability, (Plugin)SkillsPro.get());
    }

    public static Ability getAbility(String string) {
        return ABILITIES.get(string);
    }
}

