/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.skills.abilities.Ability;
import org.skills.abilities.AbilityContext;
import org.skills.abilities.ActiveAbility;
import org.skills.abilities.InstantActiveAbility;
import org.skills.abilities.KeyBinding;
import org.skills.api.events.CustomHudChangeEvent;
import org.skills.data.managers.PlayerAbilityData;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SLogger;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsPro;
import org.skills.main.locale.MessageHandler;
import org.skills.managers.resurrect.LastBreath;
import org.skills.services.manager.ServiceHandler;
import org.skills.types.SkillScaling;
import org.skills.utils.LocationUtils;
import org.skills.utils.nbt.ItemNBT;
import org.skills.utils.nbt.NBTType;
import org.skills.utils.nbt.NBTWrappers;
import org.skills.utils.xseries.XMaterial;
import org.skills.utils.xseries.XSound;
import org.skills.utils.xseries.XTag;
import org.skills.utils.xseries.particles.ParticleDisplay;
import org.skills.utils.xseries.particles.XParticle;

public class AbilityListener
implements Listener {
    protected static final Cache<UUID, List<KeyBinding>> ACTIVATIONS = CacheBuilder.newBuilder().expireAfterAccess((long)SkillsConfig.SKILL_ACTIVATION_TIME.getInt(), TimeUnit.MILLISECONDS).build();

    private static boolean keyBindingMatches(KeyBinding[] keyBindingArray, List<KeyBinding> list) {
        if (keyBindingArray.length < list.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (keyBindingArray[i] == list.get(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean activate(Player player, KeyBinding keyBinding) {
        Object object;
        Object object2;
        Object object3;
        if (player.getGameMode() == GameMode.CREATIVE && !player.hasPermission("skills.use-creative")) {
            return false;
        }
        if (SkillsConfig.isInDisabledWorld(player.getLocation())) {
            return false;
        }
        if (SkillsConfig.LAST_BREATH_ENABLED.getBoolean() && LastBreath.isLastBreaths(player)) {
            return false;
        }
        SLogger sLogger = new SLogger();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (!skilledPlayer.hasSkill()) {
            sLogger.add("Player has no skill").show();
            return false;
        }
        if (skilledPlayer.isActiveReady()) {
            sLogger.add("Player has no active ready abilities.").show();
            return false;
        }
        Object object4 = null;
        ArrayList<KeyBinding> arrayList = (ArrayList<KeyBinding>)ACTIVATIONS.getIfPresent((Object)player.getUniqueId());
        if (arrayList == null) {
            if (keyBinding == KeyBinding.SNEAK) {
                return false;
            }
            arrayList = new ArrayList<KeyBinding>(4);
            ACTIVATIONS.put((Object)player.getUniqueId(), arrayList);
        }
        arrayList.add(keyBinding);
        sLogger.add("Current key combinations: " + arrayList);
        ItemStack itemStack = player.getItemInHand();
        for (Ability ability : skilledPlayer.getSkill().getAbilities()) {
            if (ability.isPassive() || ((PlayerAbilityData)(object3 = skilledPlayer.getAbilityData((Ability)(object2 = (ActiveAbility)ability)))).isDisabled() || ((PlayerAbilityData)object3).getLevel() <= 0 || !((ActiveAbility)object2).isWeaponAllowed(skilledPlayer, itemStack) || !AbilityListener.keyBindingMatches(object = ((PlayerAbilityData)object3).getKeyBinding() != null ? ((PlayerAbilityData)object3).getKeyBinding() : ((ActiveAbility)object2).getActivationKey(skilledPlayer), arrayList)) continue;
            if (arrayList.size() == ((KeyBinding[])object).length) {
                object4 = object2;
                break;
            }
            sLogger.add("No skill was found with the given key binding combinations.").show();
            return true;
        }
        ACTIVATIONS.invalidate((Object)player.getUniqueId());
        if (object4 == null) {
            sLogger.add("No skill was found with the given key binding combinations.").show();
            return false;
        }
        sLogger.add("Ability: " + ((ActiveAbility)object4).name);
        if (((ActiveAbility)object4).isPvPBased() && SkillsConfig.DISABLE_ABILITIES_IN_REGIONS.getBoolean() && ServiceHandler.isPvPOff(player)) {
            sLogger.add("Ability cannot be used in disabled worldguard regions.").show();
            return false;
        }
        if (skilledPlayer.isInCooldown()) {
            sLogger.add("Ability is in cooldown.").show();
            XSound.BLOCK_NOTE_BLOCK_BASS.record().soundPlayer().forPlayers(player).play();
            return true;
        }
        double d = ((ActiveAbility)object4).getEnergy(skilledPlayer);
        if (skilledPlayer.getEnergy() < d) {
            sLogger.add("Not enough energy for ability: " + skilledPlayer.getEnergy() + " < " + d).show();
            XSound.play(skilledPlayer.getSkill().getEnergy().getSoundNotEnough(), soundPlayer -> soundPlayer.forPlayers(player));
            return true;
        }
        object2 = ((ActiveAbility)object4).getAbilityReady(skilledPlayer);
        if (skilledPlayer.showReadyMessage() && object2 != null) {
            ((ActiveAbility)object4).sendMessage(player, (String)object2, new Object[0]);
        }
        if (!skilledPlayer.setActiveReady((ActiveAbility)object4, true)) {
            sLogger.add("Ability is not actively ready.").show();
            return true;
        }
        CustomHudChangeEvent.call(player);
        skilledPlayer.setLastAbilityUsed((ActiveAbility)object4);
        if (object4 instanceof InstantActiveAbility) {
            if (((ActiveAbility)object4).checkup(player) != null) {
                object3 = (InstantActiveAbility)object4;
                object = new AbilityContext(player, skilledPlayer, (InstantActiveAbility)object3);
                ((InstantActiveAbility)object3).useSkill((AbilityContext)object);
            }
            sLogger.add("Ability has been instantly activated.").show();
            return true;
        }
        object3 = ParticleDisplay.of(XParticle.of(SkillsConfig.READY_PARTICLE_PARTICLE.getString()).orElse(XParticle.DUST)).withLocation(player.getLocation());
        ((ParticleDisplay)object3).count = (int)SkillsConfig.READY_PARTICLE_COUNT.eval(skilledPlayer, (Ability)object4);
        double d2 = SkillsConfig.READY_PARTICLE_OFFSET.eval(skilledPlayer, (Ability)object4);
        ((ParticleDisplay)object3).offset(d2, d2, d2);
        BukkitTask bukkitTask = new BukkitRunnable((ParticleDisplay)object3, player, skilledPlayer){
            final /* synthetic */ ParticleDisplay val$display;
            final /* synthetic */ Player val$player;
            final /* synthetic */ SkilledPlayer val$info;
            {
                this.val$display = particleDisplay;
                this.val$player = player;
                this.val$info = skilledPlayer;
            }

            public void run() {
                this.val$display.spawn(LocationUtils.getHandLocation((LivingEntity)this.val$player, true));
                if (!this.val$info.isActiveReady()) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)SkillsPro.get(), 0L, 1L);
        XSound.ITEM_ARMOR_EQUIP_DIAMOND.play((Entity)player);
        Object object5 = object4;
        Bukkit.getScheduler().runTaskLater((Plugin)SkillsPro.get(), () -> AbilityListener.lambda$activate$1(bukkitTask, player, skilledPlayer, (ActiveAbility)object5), (long)((ActiveAbility)object4).getIdle(skilledPlayer) * 20L);
        sLogger.add("Ability requires activation by hitting a target.").show();
        return true;
    }

    @EventHandler
    public void onSneakActivate(PlayerToggleSneakEvent playerToggleSneakEvent) {
        Player player = playerToggleSneakEvent.getPlayer();
        if (player.isSneaking()) {
            AbilityListener.activate(player, KeyBinding.SNEAK);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSwordMove(InventoryPickupItemEvent inventoryPickupItemEvent) {
        if (Ability.isSkillEntity((Entity)inventoryPickupItemEvent.getItem())) {
            inventoryPickupItemEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onQ(PlayerDropItemEvent playerDropItemEvent) {
        if (AbilityListener.activate(playerDropItemEvent.getPlayer(), KeyBinding.DROP)) {
            playerDropItemEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onF(PlayerSwapHandItemsEvent playerSwapHandItemsEvent) {
        if (AbilityListener.activate(playerSwapHandItemsEvent.getPlayer(), KeyBinding.SWITCH)) {
            playerSwapHandItemsEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDisposablePlayerHandler(PlayerQuitEvent playerQuitEvent) {
        int n = playerQuitEvent.getPlayer().getEntityId();
        AbilityListener.disposeTasks(playerQuitEvent.getPlayer());
        for (Set<Integer> object : Ability.DISPOSABLE_ENTITIES_SET) {
            object.remove(n);
        }
        for (Map map : Ability.DISPOSABLE_ENTITIES_MAP) {
            map.remove(n);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent playerDeathEvent) {
        AbilityListener.disposeTasks(playerDeathEvent.getEntity());
    }

    static void disposeTasks(Player player) {
        List<BukkitTask> list = Ability.DISPOSABLE_TASKS.remove(player.getEntityId());
        if (list != null) {
            list.forEach(BukkitTask::cancel);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onSkillDamageCap(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageByEntityEvent.getDamager();
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        double d = skilledPlayer.getScaling(SkillScaling.DAMAGE_CAP);
        if (d == 0.0) {
            return;
        }
        if (entityDamageByEntityEvent.getFinalDamage() > d) {
            entityDamageByEntityEvent.setDamage(d);
        }
    }

    @EventHandler
    public void onSkillActivate(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Action action = playerInteractEvent.getAction();
        if (action == Action.PHYSICAL) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        ItemStack itemStack = playerInteractEvent.getItem();
        if (itemStack != null) {
            Object object;
            NBTWrappers.NBTTagCompound nBTTagCompound;
            try {
                nBTTagCompound = ItemNBT.getTag(itemStack);
                nBTTagCompound.get("Skill_Item", NBTType.STRING);
            }
            catch (Exception exception) {
                MessageHandler.sendConsolePluginMessage("&cA NBT error has occurred! Please report this to the developer.");
                throw new RuntimeException(exception);
            }
            nBTTagCompound = itemStack.getType();
            if ((action == Action.RIGHT_CLICK_BLOCK || action == Action.RIGHT_CLICK_AIR) && nBTTagCompound.isEdible()) {
                return;
            }
            XMaterial xMaterial = XMaterial.matchXMaterial(itemStack);
            if (XTag.anyMatchString(xMaterial, SkillsConfig.PREVENT_ACTIVATION_ITEMS.getStringList())) {
                return;
            }
            if (action == Action.RIGHT_CLICK_BLOCK) {
                object = playerInteractEvent.getClickedBlock();
                if (itemStack.getType().isBlock()) {
                    return;
                }
                if (XTag.anyMatchString(XMaterial.matchXMaterial(object.getType()), SkillsConfig.PREVENT_ACTIVATION_BLOCKS.getStringList())) {
                    return;
                }
            }
            object = action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK ? KeyBinding.LEFT_CLICK : KeyBinding.RIGHT_CLICK;
            AbilityListener.activate(player, (KeyBinding)((Object)object));
        }
    }

    private static /* synthetic */ void lambda$activate$1(BukkitTask bukkitTask, Player player, SkilledPlayer skilledPlayer, ActiveAbility activeAbility) {
        bukkitTask.cancel();
        if (!player.isOnline()) {
            return;
        }
        if (skilledPlayer.setActiveReady(activeAbility, false)) {
            String string = activeAbility.getAbilityIdle(skilledPlayer);
            if (skilledPlayer.showReadyMessage() && string != null) {
                player.sendMessage(string);
            }
            XSound.ITEM_ARMOR_EQUIP_CHAIN.play((Entity)player);
        }
    }
}

