/*
 * Decompiled with CFR 0.152.
 */
package org.skills.abilities;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.skills.abilities.AbilityManager;
import org.skills.abilities.ActiveAbility;
import org.skills.data.managers.PlayerAbilityData;
import org.skills.data.managers.SkilledPlayer;
import org.skills.main.SkillsConfig;
import org.skills.main.SkillsSkillConfig;
import org.skills.main.locale.MessageHandler;
import org.skills.main.locale.SkillsLang;
import org.skills.services.manager.ServiceHandler;
import org.skills.types.SkillManager;
import org.skills.types.Stat;
import org.skills.utils.MathUtils;
import org.skills.utils.StringUtils;
import org.skills.utils.xseries.XPotion;
import org.skills.utils.xseries.XSound;

public abstract class Ability
implements Listener {
    protected static final List<Set<Integer>> DISPOSABLE_ENTITIES_SET = new ArrayList<Set<Integer>>();
    protected static final List<Map<Integer, ?>> DISPOSABLE_ENTITIES_MAP = new ArrayList();
    protected static final Map<Integer, List<BukkitTask>> DISPOSABLE_TASKS = new HashMap<Integer, List<BukkitTask>>();
    private static final Map<Integer, Entity> ENTITIES = new ConcurrentHashMap<Integer, Entity>();
    private static final List<Integer> TASKS = new ArrayList<Integer>();
    protected final String name;
    private final String skill;

    public boolean isSupported() {
        return true;
    }

    public Ability(String string, String string2) {
        this.skill = string;
        this.name = string2.equalsIgnoreCase("passive") ? string.toLowerCase(Locale.ENGLISH) + "_passive" : string2;
    }

    public static void addEntity(Entity entity) {
        ENTITIES.put(entity.getEntityId(), entity);
    }

    @SafeVarargs
    public static void addDisposableHandler(Set<Integer> ... setArray) {
        DISPOSABLE_ENTITIES_SET.addAll(Arrays.asList(setArray));
    }

    @SafeVarargs
    public static void addDisposableHandler(Map<Integer, ?> ... mapArray) {
        DISPOSABLE_ENTITIES_MAP.addAll(Arrays.asList(mapArray));
    }

    public static void disposableTask(Player player, BukkitTask bukkitTask) {
        DISPOSABLE_TASKS.compute(player.getEntityId(), (n, arrayList) -> {
            if (arrayList == null) {
                arrayList = new ArrayList<BukkitTask>(3);
            }
            arrayList.add(bukkitTask);
            return arrayList;
        });
    }

    public static boolean isSkillEntity(Entity entity) {
        return ENTITIES.containsKey(entity.getEntityId());
    }

    public static void addAllEntities(Collection<? extends Entity> collection) {
        for (Entity entity : collection) {
            Ability.addEntity(entity);
        }
    }

    public static void removeEntity(Entity entity) {
        ENTITIES.remove(entity.getEntityId());
    }

    public static String getScalingColor(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        for (Stat stat : Stat.STATS.values()) {
            if (!string.contains(stat.getNode())) continue;
            return stat.getColor();
        }
        return "&e";
    }

    public static boolean addTask(BukkitTask bukkitTask) {
        return TASKS.add(bukkitTask.getTaskId());
    }

    public static void reload() {
        BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
        Iterator<Object> iterator = TASKS.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            bukkitScheduler.cancelTask(n);
        }
        TASKS.clear();
        for (Ability ability : AbilityManager.getAbilities().values()) {
            HandlerList.unregisterAll((Listener)ability);
        }
    }

    public static void onDisable() {
        ENTITIES.values().forEach(Entity::remove);
    }

    public boolean commonDamageCheckup(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return true;
        }
        if (entityDamageByEntityEvent.getEntity() == entityDamageByEntityEvent.getDamager()) {
            return true;
        }
        if (!(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return true;
        }
        return !(entityDamageByEntityEvent.getDamager() instanceof Player);
    }

    public boolean commonDamageCheckupReverse(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return true;
        }
        return !(entityDamageByEntityEvent.getEntity() instanceof Player);
    }

    protected boolean isInvalidTarget(Entity entity) {
        return !(entity instanceof LivingEntity) || entity.getType() == EntityType.ARMOR_STAND;
    }

    public Set<EntityType> getEntityList(SkilledPlayer skilledPlayer, String string) {
        List<String> list = this.getOptions(skilledPlayer, string).getStringList();
        EnumSet<EntityType> enumSet = EnumSet.noneOf(EntityType.class);
        for (String string2 : list) {
            EntityType entityType = (EntityType)Enums.getIfPresent(EntityType.class, (String)string2.toUpperCase(Locale.ENGLISH)).orNull();
            if (entityType == null) continue;
            enumSet.add(entityType);
        }
        return enumSet;
    }

    public String getTitle(SkilledPlayer skilledPlayer) {
        try {
            return SkillsLang.valueOf("ABILITY_" + this.name.toUpperCase(Locale.ENGLISH) + "_TITLE").parse(skilledPlayer.getOfflinePlayer());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.name;
        }
    }

    public String getDescription(SkilledPlayer skilledPlayer) {
        try {
            return SkillsLang.valueOf("ABILITY_" + this.name.toUpperCase(Locale.ENGLISH) + "_DESCRIPTION").parse(skilledPlayer.getOfflinePlayer());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "No Description";
        }
    }

    public String getScalingDescription(SkilledPlayer skilledPlayer, String string) {
        return Ability.getScalingColor(string) + StringUtils.toFancyNumber(this.getAbsoluteScaling(skilledPlayer, string, new Object[0]));
    }

    public void start() {
    }

    public String translate(SkilledPlayer skilledPlayer, String string) {
        return this.getScalingDescription(skilledPlayer, this.getOptions(skilledPlayer, string).getString());
    }

    public void playSound(Player player, SkilledPlayer skilledPlayer, String string) {
        XSound.play(this.getOptions(skilledPlayer, "sounds." + string).getString(), soundPlayer -> soundPlayer.forPlayers(player));
    }

    public XSound.Record getSound(SkilledPlayer skilledPlayer, String string) {
        return XSound.parse(this.getOptions(skilledPlayer, "sounds." + string).getString());
    }

    public PotionEffect parseEquationPotion(SkilledPlayer skilledPlayer, @Nullable String string) {
        if (Strings.isNullOrEmpty((String)string) || string.equalsIgnoreCase("none")) {
            return null;
        }
        String[] stringArray = org.apache.commons.lang.StringUtils.split((String)org.apache.commons.lang.StringUtils.deleteWhitespace((String)string), (char)',');
        Optional<XPotion> optional = XPotion.matchXPotion(stringArray[0]);
        if (!optional.isPresent()) {
            return null;
        }
        PotionEffectType potionEffectType = optional.get().getPotionEffectType();
        if (potionEffectType == null) {
            return null;
        }
        int n = 2400;
        int n2 = 0;
        try {
            if (stringArray.length > 3 && !MathUtils.hasChance((int)this.getAbsoluteScaling(skilledPlayer, stringArray[3], new Object[0]))) {
                return null;
            }
            if (stringArray.length > 1) {
                n = (int)(this.getAbsoluteScaling(skilledPlayer, stringArray[1], new Object[0]) * 20.0);
                if (stringArray.length > 2) {
                    n2 = (int)(this.getAbsoluteScaling(skilledPlayer, stringArray[2], new Object[0]) - 1.0);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new PotionEffect(potionEffectType, n, n2);
    }

    public List<PotionEffect> getEffects(SkilledPlayer skilledPlayer, String string) {
        List list = this.getOptions(skilledPlayer).getStringList(string);
        ArrayList<PotionEffect> arrayList = new ArrayList<PotionEffect>(list.size());
        for (String string2 : list) {
            PotionEffect potionEffect = this.parseEquationPotion(skilledPlayer, string2);
            if (potionEffect == null) continue;
            arrayList.add(potionEffect);
        }
        return arrayList;
    }

    public List<PotionEffect> applyEffects(SkilledPlayer skilledPlayer, String string, LivingEntity livingEntity) {
        List<PotionEffect> list = this.getEffects(skilledPlayer, string);
        livingEntity.addPotionEffects(list);
        return list;
    }

    public List<PotionEffect> applyEffects(SkilledPlayer skilledPlayer, LivingEntity livingEntity) {
        return this.applyEffects(skilledPlayer, "effects", livingEntity);
    }

    public String getTranslatedScaling(SkilledPlayer skilledPlayer, String string, Object ... objectArray) {
        Objects.requireNonNull(string, () -> "One of the scalings for " + skilledPlayer.getSkillName() + " -> " + this.name + " is missing");
        String string2 = ServiceHandler.translatePlaceholders(skilledPlayer.getOfflinePlayer(), string);
        string2 = MessageHandler.replace(string2, "lvl", () -> String.valueOf(skilledPlayer.getAbilityLevel(this)));
        string2 = MessageHandler.replaceVariables(string2, objectArray);
        for (Stat stat : Stat.STATS.values()) {
            String string3 = String.valueOf(skilledPlayer.getStat(stat));
            string2 = MessageHandler.replace(string2, stat.getNode(), string3);
            string2 = MessageHandler.replace(string2, stat.getNode().toUpperCase(Locale.ENGLISH), string3);
        }
        return string2;
    }

    public double getAbsoluteScaling(SkilledPlayer skilledPlayer, String string, Object ... objectArray) {
        return MathUtils.evaluateEquation(this.getTranslatedScaling(skilledPlayer, string, objectArray));
    }

    public ConfigurationSection getOptions(SkilledPlayer skilledPlayer) {
        return Objects.requireNonNull(skilledPlayer.getSkill().getAdapter().getConfig().getConfigurationSection("abilities." + this.name.replace('_', '-')), () -> "Could not find configuration options for " + this.name + " ability in " + skilledPlayer.getSkillName() + " class.");
    }

    public SkillsSkillConfig getOptions(String string, String string2) {
        return new SkillsSkillConfig(SkillManager.getSkill(string).getAdapter().getConfig(), "abilities." + this.name.replace('_', '-') + '.' + string2);
    }

    public SkillsSkillConfig getOptions(SkilledPlayer skilledPlayer, String string) {
        return new SkillsSkillConfig(skilledPlayer.getSkill().getAdapter().getConfig(), "abilities." + this.name.replace('_', '-') + '.' + string);
    }

    public double getScaling(SkilledPlayer skilledPlayer, String string, EntityDamageByEntityEvent entityDamageByEntityEvent) {
        LivingEntity livingEntity = entityDamageByEntityEvent.getEntity() instanceof LivingEntity ? (LivingEntity)entityDamageByEntityEvent.getEntity() : null;
        return this.getScaling(skilledPlayer, string, "damage", entityDamageByEntityEvent.getDamage(), "hp", livingEntity == null ? 0.0 : livingEntity.getHealth(), "maxHp", livingEntity == null ? 0.0 : livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
    }

    public double getScaling(SkilledPlayer skilledPlayer, String string, Object ... objectArray) {
        Objects.requireNonNull(skilledPlayer, "Player info cannot be null");
        Object object = this.getOptions(skilledPlayer).get(string);
        if (object == null) {
            MessageHandler.sendConsolePluginMessage("&cMissing scaling for &e" + skilledPlayer.getSkillName() + " &cconfig&8: &eabilities &7-> &e" + this.name + " &7-> &e" + string.replace(".", " &7-> &e"));
            return 0.0;
        }
        if (object instanceof ConfigurationSection) {
            ConfigurationSection configurationSection = (ConfigurationSection)object;
            int n = SkillsConfig.getClosestLevelSection(configurationSection, skilledPlayer.getAbilityLevel(this));
            return this.getAbsoluteScaling(skilledPlayer, configurationSection.getString(String.valueOf(n)), objectArray);
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return this.getAbsoluteScaling(skilledPlayer, object.toString(), objectArray);
    }

    public int getCost(SkilledPlayer skilledPlayer) {
        String string = this.getOptions(skilledPlayer).getString("cost");
        if (string == null) {
            return 0;
        }
        return (int)this.getAbsoluteScaling(skilledPlayer, string, new Object[0]);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Ability)) {
            return false;
        }
        Ability ability = (Ability)object;
        return this.name.equals(ability.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public SkilledPlayer checkup(Player player) {
        return this.checkup(player, false);
    }

    public SkilledPlayer checkup(Player player, boolean bl) {
        GameMode gameMode = player.getGameMode();
        if (gameMode == GameMode.SPECTATOR) {
            return null;
        }
        if (gameMode == GameMode.CREATIVE && !player.hasPermission("skills.use-creative")) {
            return null;
        }
        SkilledPlayer skilledPlayer = SkilledPlayer.getSkilledPlayer((OfflinePlayer)player);
        if (skilledPlayer.getActiveAbilities().contains(this)) {
            return null;
        }
        if (!(bl || this.isPassive() || skilledPlayer.isActiveReady((ActiveAbility)this))) {
            return null;
        }
        PlayerAbilityData playerAbilityData = skilledPlayer.getAbilityData(this);
        if (playerAbilityData == null) {
            return null;
        }
        if (playerAbilityData.isDisabled()) {
            return null;
        }
        if (playerAbilityData.getLevel() < 1 && !this.name.endsWith("passive")) {
            return null;
        }
        if (SkillsConfig.isInDisabledWorld(player.getWorld())) {
            return null;
        }
        if (ServiceHandler.isInRegion(player, this.getDisabledRegions(skilledPlayer))) {
            return null;
        }
        return skilledPlayer;
    }

    public List<String> getDisabledRegions(SkilledPlayer skilledPlayer) {
        return this.getOptions(skilledPlayer).getStringList("disabled-regions");
    }

    public List<Object> getEdits(List<Object> list, ConfigurationSection configurationSection, String string, SkilledPlayer skilledPlayer) {
        for (String string2 : configurationSection.getKeys(false)) {
            ConfigurationSection configurationSection2;
            Object object;
            boolean bl;
            if (string2.equals("required-level") || string2.equals("activation") || string2.equals("cost") || !(bl = (object = configurationSection.get(string2)) instanceof ConfigurationSection) && !(object instanceof String) && !(object instanceof Number)) continue;
            if (bl && !(configurationSection2 = (ConfigurationSection)object).isSet("1")) {
                string2 = StringUtils.toLatinLowerCase(string2, '*', '*');
                this.getEdits(list, configurationSection2, (string.isEmpty() ? "" : string + '_') + string2 + '_', skilledPlayer);
                continue;
            }
            configurationSection2 = () -> {
                if (bl) {
                    ConfigurationSection configurationSection = (ConfigurationSection)object;
                    int n = SkillsConfig.getClosestLevelSection(configurationSection, skilledPlayer.getAbilityLevel(this));
                    return this.getScalingDescription(skilledPlayer, configurationSection.getString(String.valueOf(n)));
                }
                if (object instanceof Number) {
                    return object.toString();
                }
                return this.getScalingDescription(skilledPlayer, object.toString());
            };
            list.add('%' + string + StringUtils.toLatinLowerCase(string2, '*', '*') + '%');
            list.add(configurationSection2);
        }
        return list;
    }

    public List<Object> getEdits(SkilledPlayer skilledPlayer) {
        ArrayList<Object> arrayList = new ArrayList<Object>(26);
        return this.getEdits(arrayList, this.getOptions(skilledPlayer), "", skilledPlayer);
    }

    public int getRequiredLevel(SkilledPlayer skilledPlayer) {
        String string = this.getOptions(skilledPlayer).getString("required-level");
        if (Strings.isNullOrEmpty((String)string)) {
            return 0;
        }
        return (int)this.getAbsoluteScaling(skilledPlayer, string, new Object[0]);
    }

    public boolean canUse(SkilledPlayer skilledPlayer) {
        return this.getRequiredLevel(skilledPlayer) <= skilledPlayer.getLevel();
    }

    public boolean isPassive() {
        return !(this instanceof ActiveAbility);
    }

    public String getName() {
        return this.name;
    }

    public String getSkill() {
        return this.skill;
    }
}

