/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;
import de.dustplanet.util.api.model.Release;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@SuppressFBWarnings(value={"CD_CIRCULAR_DEPENDENCY"}, justification="False positive")
public class Updater {
    private static final String ZIP_ENDING = ".zip";
    private static final int CONNECTION_TIMEOUT = 15000;
    private static final String QUERY = "/servermods/files?projectIds=";
    private static final String HOST = "https://servermods.forgesvc.net";
    private static final String USER_AGENT = "Updater (by Gravity/timbru31)";
    private static final String DELIMETER = "^v|[\\s_-]v";
    private static final String[] NO_UPDATE_TAG = new String[]{"-DEV", "-PRE", "-SNAPSHOT"};
    private static final int BYTE_SIZE = 1024;
    private static final String API_KEY_CONFIG_KEY = "api-key";
    private static final String DISABLE_CONFIG_KEY = "disable";
    private static final String API_KEY_DEFAULT = "PUT_API_KEY_HERE";
    private static final Boolean DISABLE_DEFAULT = Boolean.FALSE;
    private static final long THREAD_TIMEOUT = 10000L;
    private final Plugin plugin;
    private final UpdateType type;
    private final boolean announce;
    private final File file;
    private final File updateFolder;
    private final UpdateCallback callback;
    private int id = -1;
    private String apiKey;
    private final ReleaseType releaseType;
    private String versionName;
    private String versionLink;
    private String versionType;
    private String versionGameVersion;
    private String versionMD5;
    private URL url;
    private Thread thread;
    private UpdateResult result;

    public Updater(Plugin plugin, int id, File file, UpdateType type, boolean announce) {
        this(plugin, id, file, type, null, announce);
    }

    public Updater(Plugin plugin, int id, File file, UpdateType type, UpdateCallback callback) {
        this(plugin, id, file, type, callback, false);
    }

    public Updater(Plugin plugin, int id, File file, UpdateType type, UpdateCallback callback, boolean announce) {
        this(plugin, id, file, type, callback, announce, ReleaseType.RELEASE);
    }

    @SuppressFBWarnings(value={"PCOA_PARTIALLY_CONSTRUCTED_OBJECT_ACCESS"})
    public Updater(Plugin plugin, int id, File file, UpdateType type, UpdateCallback callback, boolean announce, ReleaseType releaseType) {
        this.plugin = plugin;
        this.type = type;
        this.announce = announce;
        this.file = file;
        this.id = id;
        this.updateFolder = this.plugin.getServer().getUpdateFolderFile();
        this.callback = callback;
        this.releaseType = releaseType;
        File pluginFile = this.plugin.getDataFolder().getParentFile();
        File updaterFile = new File(pluginFile, "Updater");
        File updaterConfigFile = new File(updaterFile, "config.yml");
        YamlConfiguration config = new YamlConfiguration();
        config.options().header("This configuration file affects all plugins using the Updater system (version 2+ - http://forums.bukkit.org/threads/96681/ )\nIf you wish to use your API key, read http://wiki.bukkit.org/ServerMods_API and place it below.\nSome updating systems will not adhere to the disabled value, but these may be turned off in their plugin's configuration.");
        config.addDefault(DISABLE_CONFIG_KEY, (Object)DISABLE_DEFAULT);
        if (!updaterFile.exists()) {
            this.fileIOOrError(updaterFile, updaterFile.mkdir(), true);
        }
        boolean createFile = !updaterConfigFile.exists();
        try {
            if (createFile) {
                this.fileIOOrError(updaterConfigFile, updaterConfigFile.createNewFile(), true);
                config.options().copyDefaults(true);
                config.save(updaterConfigFile);
            } else {
                config.load(updaterConfigFile);
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            String message = createFile ? "The updater could not create configuration at " + updaterFile.getAbsolutePath() : "The updater could not load configuration at " + updaterFile.getAbsolutePath();
            this.plugin.getLogger().log(Level.SEVERE, message.replaceAll("[\r\n]", ""), e);
        }
        if (config.getBoolean(DISABLE_CONFIG_KEY)) {
            this.result = UpdateResult.DISABLED;
            return;
        }
        String key = config.getString(API_KEY_CONFIG_KEY);
        if (API_KEY_DEFAULT.equalsIgnoreCase(key) || "".equals(key)) {
            key = null;
        }
        this.apiKey = key;
        try {
            this.url = new URL("https://servermods.forgesvc.net/servermods/files?projectIds=" + this.id);
        }
        catch (MalformedURLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "The project ID provided for updating, " + this.id + " is invalid.", e);
            this.result = UpdateResult.FAIL_BADID;
            return;
        }
        this.thread = new Thread(() -> this.runUpdater());
        this.thread.start();
    }

    @Nullable
    public UpdateResult getResult() {
        this.waitForThread();
        return this.result;
    }

    @Nullable
    public ReleaseType getLatestType() {
        this.waitForThread();
        if (this.versionType != null) {
            return this.getReleaseType(this.versionType);
        }
        return null;
    }

    @Nullable
    public String getLatestGameVersion() {
        this.waitForThread();
        return this.versionGameVersion;
    }

    @Nullable
    public String getLatestName() {
        this.waitForThread();
        return this.versionName;
    }

    @Nullable
    public String getLatestFileLink() {
        this.waitForThread();
        return this.versionLink;
    }

    private void waitForThread() {
        if (this.thread != null && this.thread.isAlive()) {
            try {
                this.thread.join(10000L);
            }
            catch (InterruptedException e) {
                this.plugin.getLogger().log(Level.SEVERE, null, e);
            }
        }
    }

    private void saveFile(String fileToSave) {
        File folder = this.updateFolder;
        if (!folder.exists()) {
            this.fileIOOrError(folder, folder.mkdir(), true);
        } else {
            this.deleteOldFiles();
        }
        boolean downloadSuccess = this.downloadFile();
        if (downloadSuccess) {
            this.result = UpdateResult.SUCCESS;
            File dFile = new File(folder.getAbsolutePath(), fileToSave);
            if (dFile.getName().endsWith(ZIP_ENDING)) {
                this.unzip(dFile.getAbsolutePath());
            }
            if (this.announce) {
                this.plugin.getLogger().info("Finished updating.");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5", "UAC_UNNECESSARY_API_CONVERSION_FILE_TO_PATH"}, justification="CurseForge does not offer a more secure hashing algorithm to compare to and false positive")
    private boolean downloadFile() {
        URL fileUrl = null;
        int fileLength = 0;
        try {
            fileUrl = this.followRedirects(this.versionLink);
            if (fileUrl == null) {
                return false;
            }
            fileLength = fileUrl.openConnection().getContentLength();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, null, e);
            this.result = UpdateResult.FAIL_DOWNLOAD;
            return false;
        }
        File updateFile = new File(this.updateFolder, this.file.getName());
        try (BufferedInputStream in = new BufferedInputStream(fileUrl.openStream());
             OutputStream fout = Files.newOutputStream(updateFile.toPath(), new OpenOption[0]);){
            int count;
            byte[] data = new byte[1024];
            if (this.announce) {
                this.plugin.getLogger().info("About to download a new update: " + this.versionName.replaceAll("[\r\n]", ""));
            }
            long downloaded = 0L;
            MessageDigest md = MessageDigest.getInstance("MD5");
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
                md.update(data, 0, count);
                int percent = (int)((downloaded += (long)count) * 100L / (long)fileLength);
                if (!this.announce || percent % 10 != 0) continue;
                this.plugin.getLogger().info("Downloading update: " + percent + "% of " + fileLength + " bytes.");
            }
            byte[] md5bytes = md.digest();
            StringBuilder stringBuilder = new StringBuilder();
            for (byte md5byte : md5bytes) {
                stringBuilder.append(Integer.toString((md5byte & 0xFF) + 256, 16).substring(1));
            }
            String md5 = stringBuilder.toString();
            if (md5.equals(this.versionMD5)) return true;
            this.plugin.getLogger().warning("Downloaded file did not match the remote file!");
            this.result = UpdateResult.FAIL_DOWNLOAD;
            this.fileIOOrError(updateFile, updateFile.delete(), false);
            int n = 0;
            return n != 0;
        }
        catch (Exception ex) {
            this.plugin.getLogger().log(Level.WARNING, "The auto-updater tried to download a new update, but was unsuccessful.", ex);
            this.result = UpdateResult.FAIL_DOWNLOAD;
            return false;
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
    private URL followRedirects(String location) throws IOException {
        int iterations;
        int MAX_ITERATIONS = 5;
        String redirectedLocation = location;
        URL fileURL = null;
        block3: for (iterations = 0; iterations < 5; ++iterations) {
            URL resourceUrl = new URL(redirectedLocation);
            HttpURLConnection conn = (HttpURLConnection)resourceUrl.openConnection();
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(15000);
            conn.setInstanceFollowRedirects(false);
            conn.setRequestProperty("User-Agent", USER_AGENT);
            fileURL = conn.getURL();
            switch (conn.getResponseCode()) {
                case 301: 
                case 302: {
                    String redLoc = conn.getHeaderField("Location");
                    URL base = new URL(redirectedLocation);
                    URL next = new URL(base, redLoc);
                    redirectedLocation = next.toExternalForm();
                    continue block3;
                }
            }
        }
        if (iterations == 5) {
            this.plugin.getLogger().log(Level.SEVERE, "The auto-updater tried to download a new update, but was unsuccessful because there were too many redirects");
            this.result = UpdateResult.FAIL_DOWNLOAD;
            return null;
        }
        return fileURL;
    }

    private void deleteOldFiles() {
        File[] list;
        for (File xFile : list = this.listFilesOrError(this.updateFolder)) {
            if (!xFile.getName().endsWith(ZIP_ENDING)) continue;
            this.fileIOOrError(xFile, xFile.mkdir(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"UAC_UNNECESSARY_API_CONVERSION_FILE_TO_PATH", "PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"}, justification="False positive")
    private void unzip(String location) {
        File fSourceZip = new File(location);
        String zipPath = location.substring(0, location.length() - 4);
        try (ZipFile zipFile = new ZipFile(fSourceZip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File destinationFilePath = new File(zipPath, entry.getName());
                this.fileIOOrError(destinationFilePath.getParentFile(), destinationFilePath.getParentFile().mkdirs(), true);
                if (entry.isDirectory()) continue;
                try (BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));){
                    OutputStream fos = Files.newOutputStream(destinationFilePath.toPath(), new OpenOption[0]);
                    try (BufferedOutputStream bos = new BufferedOutputStream(fos, 1024);){
                        int b;
                        byte[] buffer = new byte[1024];
                        while ((b = bis.read(buffer, 0, 1024)) != -1) {
                            bos.write(buffer, 0, b);
                        }
                        bos.flush();
                        String name = destinationFilePath.getName();
                        if (!name.endsWith(".jar") || !this.pluginExists(name)) continue;
                        File output = new File(this.updateFolder, name);
                        this.fileIOOrError(output, destinationFilePath.renameTo(output), true);
                    }
                    finally {
                        if (fos == null) continue;
                        fos.close();
                    }
                }
            }
            this.moveNewZipFiles(zipPath);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "The auto-updater tried to unzip a new update file, but was unsuccessful.", e);
            this.result = UpdateResult.FAIL_DOWNLOAD;
        }
        finally {
            this.fileIOOrError(fSourceZip, fSourceZip.delete(), false);
        }
    }

    private void moveNewZipFiles(String zipPath) {
        File[] list;
        for (File dFile : list = this.listFilesOrError(new File(zipPath))) {
            if (dFile.isDirectory() && this.pluginExists(dFile.getName())) {
                File oFile = new File(this.plugin.getDataFolder().getParent(), dFile.getName());
                File[] dList = this.listFilesOrError(dFile);
                File[] oList = this.listFilesOrError(oFile);
                for (File cFile : dList) {
                    boolean found = false;
                    for (File xFile : oList) {
                        if (!xFile.getName().equals(cFile.getName())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        File output = new File(oFile, cFile.getName());
                        this.fileIOOrError(output, cFile.renameTo(output), true);
                        continue;
                    }
                    this.fileIOOrError(cFile, cFile.delete(), false);
                }
            }
            this.fileIOOrError(dFile, dFile.delete(), false);
        }
        File zip = new File(zipPath);
        this.fileIOOrError(zip, zip.delete(), false);
    }

    private boolean pluginExists(String name) {
        File[] plugins;
        for (File pluginFile : plugins = this.listFilesOrError(new File("plugins"))) {
            if (!pluginFile.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @SuppressFBWarnings(value={"STT_STRING_PARSING_A_FIELD"})
    private boolean versionCheck() {
        String title = this.versionName;
        if (this.type != UpdateType.NO_VERSION_CHECK) {
            String localVersion = this.plugin.getDescription().getVersion();
            if (title != null && title.split(DELIMETER).length >= 2) {
                String remoteVersion = title.split(DELIMETER)[title.split(DELIMETER).length - 1].split(" ")[0];
                if (this.hasTag(localVersion) || !this.shouldUpdate(localVersion, remoteVersion)) {
                    this.result = UpdateResult.NO_UPDATE;
                    return false;
                }
            } else {
                String authorInfo = this.plugin.getDescription().getAuthors().isEmpty() ? "" : " (" + (String)this.plugin.getDescription().getAuthors().get(0) + ")";
                this.plugin.getLogger().warning("The author of this plugin" + authorInfo.replaceAll("[\r\n]", "") + " has misconfigured their Auto Update system");
                this.plugin.getLogger().warning("File versions should follow the format 'PluginName vVERSION'");
                this.plugin.getLogger().warning("Please notify the author of this error.");
                this.result = UpdateResult.FAIL_NOVERSION;
                return false;
            }
        }
        return true;
    }

    public boolean shouldUpdate(String localVersion, String remoteVersion) {
        try {
            Semver local = new Semver(localVersion, Semver.SemverType.LOOSE);
            Semver remote = new Semver(remoteVersion, Semver.SemverType.LOOSE);
            return remote.isGreaterThan(local);
        }
        catch (SemverException e) {
            return !localVersion.equalsIgnoreCase(remoteVersion);
        }
    }

    private boolean hasTag(String version) {
        for (String string : NO_UPDATE_TAG) {
            if (!version.contains(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"UTWR_USE_TRY_WITH_RESOURCES"}, justification="False positive")
    private boolean read() {
        BufferedReader reader = null;
        try {
            URLConnection conn = this.url.openConnection();
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(15000);
            if (this.apiKey != null) {
                conn.addRequestProperty("X-API-Key", this.apiKey);
            }
            conn.addRequestProperty("User-Agent", USER_AGENT);
            conn.setDoOutput(true);
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            String response = reader.readLine();
            Gson gson = new GsonBuilder().create();
            Release[] releases = (Release[])gson.fromJson(response, Release[].class);
            ArrayList<Release> filteredReleases = new ArrayList<Release>();
            for (Release release : releases) {
                String _releaseType = release.getReleaseType();
                if (this.getReleaseType(_releaseType) != this.releaseType) continue;
                filteredReleases.add(release);
            }
            if (filteredReleases.isEmpty()) {
                this.plugin.getLogger().warning("The updater could not find any files for the project id " + this.id);
                this.result = UpdateResult.FAIL_BADID;
                boolean bl = false;
                return bl;
            }
            Release latestRelease = (Release)filteredReleases.get(filteredReleases.size() - 1);
            this.versionName = latestRelease.getName();
            this.versionLink = latestRelease.getDownloadUrl();
            this.versionType = latestRelease.getReleaseType();
            this.versionGameVersion = latestRelease.getGameVersion();
            this.versionMD5 = latestRelease.getMd5();
            int n = 1;
            return n != 0;
        }
        catch (IOException e) {
            if (e.getMessage().contains("HTTP response code: 403")) {
                this.plugin.getLogger().severe("dev.bukkit.org rejected the API key provided in plugins/Updater/config.yml");
                this.plugin.getLogger().severe("Please double-check your configuration to ensure it is correct.");
                this.result = UpdateResult.FAIL_APIKEY;
            } else {
                this.plugin.getLogger().severe("The updater could not contact dev.bukkit.org for updating.");
                this.plugin.getLogger().severe("If you have not recently modified your configuration and this is the first time you are seeing this message, the site may be experiencing temporary downtime.");
                this.result = UpdateResult.FAIL_DBO;
            }
            this.plugin.getLogger().log(Level.SEVERE, null, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.plugin.getLogger().log(Level.SEVERE, null, e);
                }
            }
        }
    }

    @Nullable
    private ReleaseType getReleaseType(String release) {
        for (ReleaseType releaseTypeValue : ReleaseType.values()) {
            if (!releaseTypeValue.name().equalsIgnoreCase(release)) continue;
            return releaseTypeValue;
        }
        return null;
    }

    private void fileIOOrError(File fileOperatedOn, boolean operationResult, boolean create) {
        if (!operationResult) {
            this.plugin.getLogger().severe("The updater could not " + (create ? "create" : "delete") + " file at: " + fileOperatedOn.getAbsolutePath().replaceAll("[\r\n]", ""));
        }
    }

    @SuppressFBWarnings(value={"BL_BURYING_LOGIC"})
    private File[] listFilesOrError(File folder) {
        File[] contents = folder.listFiles();
        if (contents == null) {
            this.plugin.getLogger().severe("The updater could not access files at: " + this.updateFolder.getAbsolutePath().replaceAll("[\r\n]", ""));
            return new File[0];
        }
        return contents;
    }

    void runCallback() {
        this.callback.onFinish(this);
    }

    @SuppressFBWarnings(value={"STT_STRING_PARSING_A_FIELD"})
    final void runUpdater() {
        if (this.url != null && this.read() && this.versionCheck()) {
            if (this.versionLink != null && this.type != UpdateType.NO_DOWNLOAD) {
                String name = this.file.getName();
                if (this.versionLink.endsWith(ZIP_ENDING)) {
                    name = this.versionLink.substring(this.versionLink.lastIndexOf(47) + 1);
                }
                this.saveFile(name);
            } else {
                this.result = UpdateResult.UPDATE_AVAILABLE;
            }
        }
        if (this.callback != null) {
            new BukkitRunnable(){

                public void run() {
                    Updater.this.runCallback();
                }
            }.runTask(this.plugin);
        }
    }

    public static interface UpdateCallback {
        public void onFinish(Updater var1);
    }

    public static enum ReleaseType {
        ALPHA,
        BETA,
        RELEASE;

    }

    public static enum UpdateType {
        DEFAULT,
        NO_VERSION_CHECK,
        NO_DOWNLOAD;

    }

    public static enum UpdateResult {
        SUCCESS,
        NO_UPDATE,
        DISABLED,
        FAIL_DOWNLOAD,
        FAIL_DBO,
        FAIL_NOVERSION,
        FAIL_BADID,
        FAIL_APIKEY,
        UPDATE_AVAILABLE;

    }
}

