/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.util;

import com.google.common.base.CaseFormat;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.vdurmont.semver4j.Semver;
import de.dustplanet.silkspawners.SilkSpawners;
import de.dustplanet.silkspawners.compat.api.NMSProvider;
import de.dustplanet.util.DebugLogHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.annotation.Nullable;
import lombok.Generated;
import me.confuser.barapi.BarAPI;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.UnsafeValues;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import ru.endlesscode.mimic.Mimic;

public class SilkUtil {
    private final Map<String, String> mobIDToDisplayName = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, String> displayNameToMobID = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final List<String> knownEntities = new ArrayList<String>();
    private String defaultEntityID = EntityType.PIG.getName();
    private boolean useReflection = true;
    private WorldGuardPlugin wg;
    private Mimic mimic;
    private boolean barAPI;
    private final SilkSpawners plugin;
    public NMSProvider nmsProvider;

    public SilkUtil(SilkSpawners instance) {
        SilkSpawners correctedInstance = instance;
        if (instance == null) {
            Bukkit.getLogger().severe("SilkSpawners - Nag API user: Don't initialize SilkUtil without a SilkSpawners instance!");
            correctedInstance = (SilkSpawners)Bukkit.getPluginManager().getPlugin("SilkSpawners");
        }
        this.plugin = correctedInstance;
        boolean verboseMode = this.plugin.getConfig().getBoolean("verboseMode", false);
        if (verboseMode) {
            DebugLogHandler.attachDebugLogger((Plugin)this.plugin);
            this.plugin.getLogger().setLevel(Level.FINE);
        }
        this.getWorldGuard();
        this.getMimic();
        boolean nmsProviderFound = this.setupNMSProvider();
        if (nmsProviderFound) {
            this.load();
        }
    }

    public static SilkUtil hookIntoSilkSpanwers() {
        SilkSpawners plugin = (SilkSpawners)Bukkit.getPluginManager().getPlugin("SilkSpawners");
        if (plugin == null || plugin.getConfig() == null) {
            Bukkit.getLogger().severe("SilkSpawners is not yet ready, have you called SilkUtil.hookIntoSilkSpanwers() before your onEnable()?");
            return null;
        }
        return new SilkUtil(plugin);
    }

    private boolean setupNMSProvider() {
        String packageName;
        String nmsVersion;
        String version = this.plugin.getNmsVersion();
        if (version == null && (nmsVersion = (packageName = Bukkit.getServer().getClass().getPackage().getName()).substring(packageName.lastIndexOf(46) + 1)).equals("craftbukkit")) {
            try {
                String minecraftVersion = (String)Server.class.getDeclaredMethod("getMinecraftVersion", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
                Semver semver = new Semver(minecraftVersion);
                if (semver.isGreaterThanOrEqualTo("1.20.5")) {
                    int protocolVersion = (Integer)UnsafeValues.class.getDeclaredMethod("getProtocolVersion", new Class[0]).invoke((Object)Bukkit.getUnsafe(), new Object[0]);
                    version = SilkSpawners.PROTOCOL_VERSION_PACKAGE_MAP.get(protocolVersion);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        FileConfiguration config = this.plugin.getConfig();
        boolean checkForNerfFlags = true;
        if (config != null) {
            checkForNerfFlags = config.getBoolean("checkForNerfFlags", true);
        }
        try {
            Class<?> clazz = Class.forName("de.dustplanet.silkspawners.compat." + version + ".NMSHandler");
            if (NMSProvider.class.isAssignableFrom(clazz)) {
                this.nmsProvider = (NMSProvider)clazz.getConstructor(Boolean.TYPE).newInstance(checkForNerfFlags);
                this.plugin.getLogger().info("Loading support for " + version);
                return true;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            this.plugin.getLogger().severe("Could not find support for this CraftBukkit version.");
            this.plugin.getLogger().info("Check for updates at https://dev.bukkit.org/projects/silkspawners/");
            this.plugin.getLogger().info("Disabling SilkSpawners now!");
            this.clearAll();
            this.plugin.shutdown();
        }
        return false;
    }

    public void load() {
        List<String> entities = this.scanEntityMap();
        this.plugin.getLogger().fine("Scanning the mobs");
        for (String entityID : entities) {
            EntityType bukkitEntity = EntityType.fromName((String)entityID);
            Class bukkitEntityClass = bukkitEntity == null ? null : bukkitEntity.getEntityClass();
            boolean enable = this.plugin.getConfig().getBoolean("enableCreatureDefault", true);
            if (!this.plugin.getMobs().contains("creatures." + entityID)) {
                this.plugin.getLogger().info("Entity " + entityID + " is not in the config. Adding...");
                this.plugin.getMobs().addDefault("creatures." + entityID + ".enable", enable);
                this.plugin.getMobs().save();
            } else {
                enable = this.plugin.getMobs().getBoolean("creatures." + entityID + ".enable", enable);
            }
            if (!enable) {
                this.plugin.getLogger().fine("Entity " + entityID + " = " + bukkitEntity + "[" + bukkitEntityClass + "] (disabled)");
                continue;
            }
            this.knownEntities.add(entityID);
            String displayName = this.plugin.getMobs().getString("creatures." + entityID + ".displayName");
            if (displayName == null) {
                displayName = entityID;
            }
            this.mobIDToDisplayName.put(entityID, displayName);
            List aliases = this.plugin.getMobs().getStringList("creatures." + entityID + ".aliases");
            aliases.add(displayName.toLowerCase(Locale.ENGLISH).replace(" ", ""));
            aliases.add(displayName.toLowerCase(Locale.ENGLISH).replace(" ", "_"));
            aliases.add(entityID.toLowerCase(Locale.ENGLISH).replace(" ", ""));
            aliases.add(entityID.toLowerCase(Locale.ENGLISH).replace(" ", "_"));
            aliases.add(entityID.toLowerCase(Locale.ENGLISH).replace("_", ""));
            aliases.add(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, entityID));
            if (bukkitEntity != null) {
                aliases.add(bukkitEntity.name().toLowerCase(Locale.ENGLISH).replace(" ", ""));
                aliases.add(bukkitEntity.name().toLowerCase(Locale.ENGLISH).replace(" ", "_"));
            }
            HashSet aliasSet = new HashSet(aliases);
            for (String alias : aliasSet) {
                this.displayNameToMobID.put(alias, entityID);
            }
            this.plugin.getLogger().fine("Entity " + entityID + " = " + bukkitEntity + "[" + bukkitEntityClass + "] (display name: " + displayName + ", aliases: " + aliasSet + ")");
        }
        if (this.plugin.getConfig().contains("defaultCreature")) {
            String defaultCreatureString = this.plugin.getConfig().getString("defaultCreature", "pig").toLowerCase(Locale.ENGLISH);
            if (this.displayNameToMobID.containsKey(defaultCreatureString)) {
                this.setDefaultEntityID(this.defaultEntityID);
                this.plugin.getLogger().fine("Default monster spawner set to " + this.defaultEntityID);
            } else {
                this.plugin.getLogger().warning("Invalid creature type: " + defaultCreatureString + ", default monster spawner fallback to PIG");
            }
        }
        if (!this.plugin.getConfig().getBoolean("useReflection", true)) {
            this.setUseReflection(false);
        }
        this.plugin.getLogger().fine("Reflection is " + this.isUsingReflection());
        if (this.plugin.getConfig().getBoolean("spawnersUnstackable", false)) {
            this.nmsProvider.setSpawnersUnstackable();
        }
    }

    public String getDefaultEntityID() {
        return this.defaultEntityID;
    }

    public void setDefaultEntityID(String defaultEntityID) {
        this.defaultEntityID = defaultEntityID;
    }

    public boolean isUsingReflection() {
        return this.useReflection;
    }

    public void setUseReflection(boolean useReflection) {
        this.useReflection = useReflection;
    }

    public boolean isVanillaBossBar() {
        return this.plugin.getConfig().getBoolean("vanillaBossBar.enable", true);
    }

    @Deprecated
    public ItemStack newEggItem(String entityID, int amount) {
        return this.nmsProvider.newEggItem(entityID, amount);
    }

    public ItemStack newEggItem(String entityID, int amount, String displayName) {
        return this.nmsProvider.newEggItem(entityID, amount, displayName);
    }

    public ItemStack newSpawnerItem(String entityID, String customName, int amount, boolean forceLore) {
        String spawnerName;
        String targetEntityID = null;
        try {
            targetEntityID = this.displayNameToMobID.get(entityID);
        }
        catch (NullPointerException e) {
            targetEntityID = entityID;
        }
        if (targetEntityID == null) {
            targetEntityID = entityID;
        }
        if (StringUtils.isBlank((String)(spawnerName = customName))) {
            spawnerName = "Monster Spawner";
        }
        ItemStack item = new ItemStack(this.nmsProvider.getSpawnerMaterial(), amount);
        ItemMeta meta = item.getItemMeta();
        if (!"Monster Spawner".equalsIgnoreCase(spawnerName)) {
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)spawnerName).replace("%creature%", this.getCreatureName(targetEntityID)));
        }
        if ((forceLore || !this.isUsingReflection()) && this.plugin.getConfig().getBoolean("useMetadata", true)) {
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("entityID:" + targetEntityID);
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        return this.nmsProvider.setNBTEntityID(item, targetEntityID);
    }

    @Nullable
    public String getStoredEggEntityID(ItemStack item) {
        String metaEntityID;
        String entityID = null;
        if (this.isUsingReflection()) {
            entityID = this.nmsProvider.getSilkSpawnersNBTEntityID(item);
            this.plugin.getLogger().log(Level.FINE, "EntityID from egg item stack (custom tag) is {0}", entityID);
            if (entityID != null) {
                return entityID;
            }
            entityID = this.nmsProvider.getVanillaEggNBTEntityID(item);
            this.plugin.getLogger().log(Level.FINE, "EntityID from egg item stack (vanilla tag) is {0}", entityID);
            if (entityID != null) {
                return entityID;
            }
        }
        if (item.hasItemMeta() && (metaEntityID = this.searchItemMeta(item.getItemMeta())) != null) {
            return metaEntityID;
        }
        return null;
    }

    @Nullable
    public String getStoredSpawnerItemEntityID(ItemStack item) {
        String metaEntityID;
        if (this.isUsingReflection()) {
            String entityID = this.nmsProvider.getSilkSpawnersNBTEntityID(item);
            this.plugin.getLogger().log(Level.FINE, "EntityID from item stack (custom tag) is {0}", entityID);
            if (StringUtils.isNotBlank((String)entityID)) {
                return entityID;
            }
            entityID = this.nmsProvider.getVanillaNBTEntityID(item);
            this.plugin.getLogger().log(Level.FINE, "EntityID from item stack (vanilla tag) is {0}", entityID);
            if (StringUtils.isNotBlank((String)entityID)) {
                return entityID.replace("minecraft:", "");
            }
        }
        if (item.hasItemMeta() && (metaEntityID = this.searchItemMeta(item.getItemMeta())) != null) {
            return metaEntityID;
        }
        return null;
    }

    @Nullable
    public String searchItemMeta(ItemMeta meta) {
        String entityID = null;
        if (this.plugin.getConfig().getBoolean("useMetadata", true) && meta.hasLore() && !meta.getLore().isEmpty()) {
            for (String entityIDString : meta.getLore()) {
                String[] entityIDArray;
                if (!entityIDString.contains("entityID") || (entityIDArray = entityIDString.split(":")).length != 2) continue;
                return this.displayNameToMobID.get(entityIDArray[1]);
            }
        }
        return entityID;
    }

    public boolean isRecognizedMob(String mobID) {
        return EntityType.fromName((String)mobID) != null;
    }

    @Nullable
    public String getSpawnerEntityID(Block block) {
        BlockState blockState = block.getState();
        if (!(blockState instanceof CreatureSpawner)) {
            this.plugin.getLogger().warning("getSpawnerEntityID called on non-spawner block: " + block);
            return null;
        }
        if (this.isUsingReflection()) {
            this.plugin.getLogger().fine("Using reflection to get mob name of the block");
            return this.nmsProvider.getMobNameOfSpawner(blockState);
        }
        CreatureSpawner spawner = (CreatureSpawner)blockState;
        if (spawner.getSpawnedType() != null) {
            this.plugin.getLogger().fine("Using Bukkit fallback to get the mob name of the block");
            return spawner.getSpawnedType().getName();
        }
        return null;
    }

    public void setSpawnerEntityID(Block block, String entity) {
        EntityType ct;
        BlockState blockState = block.getState();
        if (!(blockState instanceof CreatureSpawner)) {
            this.plugin.getLogger().warning("setSpawnerEntityID called on non-spawner block: " + block);
            return;
        }
        if (this.isUsingReflection()) {
            String mobID = this.displayNameToMobID.get(entity);
            if (mobID == null) {
                mobID = this.displayNameToMobID.get(this.defaultEntityID);
            }
            if (this.nmsProvider.setMobNameOfSpawner(blockState, mobID)) {
                blockState.update(true);
                return;
            }
        }
        if ((ct = EntityType.fromName((String)entity)) == null) {
            throw new IllegalArgumentException("Failed to find creature type for " + entity);
        }
        ((CreatureSpawner)blockState).setSpawnedType(ct);
        blockState.update(true);
    }

    public boolean setSpawnerType(Block block, String entityID, Player player, String messageDenied) {
        if (!this.canBuildHere(player, block.getLocation())) {
            this.sendMessage((CommandSender)player, messageDenied);
            return false;
        }
        this.setSpawnerEntityID(block, entityID);
        return true;
    }

    public ItemStack setSpawnerType(ItemStack item, String entityID, String customName) {
        ArrayList<String> lore;
        String correctedEntityID = this.displayNameToMobID.get(entityID);
        String correctedCustomName = customName;
        if (StringUtils.isBlank((String)customName)) {
            correctedCustomName = "Monster Spawner";
        }
        if (item == null || item.getType() != this.nmsProvider.getSpawnerMaterial() && !this.nmsProvider.getSpawnEggMaterials().contains(item.getType())) {
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        if (item.getType() == this.nmsProvider.getSpawnerMaterial() && !correctedCustomName.equalsIgnoreCase("Monster Spawner")) {
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)correctedCustomName).replace("%creature%", this.getCreatureName(correctedEntityID)));
        }
        if (!this.isUsingReflection() && this.plugin.getConfig().getBoolean("useMetadata", true)) {
            lore = new ArrayList<String>();
            lore.add("entityID:" + correctedEntityID);
            meta.setLore(lore);
        }
        if (this.isUsingReflection() && meta.hasLore()) {
            lore = meta.getLore();
            Iterator it = lore.iterator();
            while (it.hasNext()) {
                if (!((String)it.next()).contains("entityID")) continue;
                it.remove();
            }
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        return this.nmsProvider.setNBTEntityID(item, correctedEntityID);
    }

    public String getCreatureName(String entity) {
        if (entity == null) {
            return "???";
        }
        String displayName = null;
        if (this.mobIDToDisplayName != null) {
            try {
                displayName = this.mobIDToDisplayName.get(entity);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (displayName == null) {
            EntityType entityType = EntityType.fromName((String)entity);
            displayName = entityType != null ? entityType.getName() : entity;
        }
        return displayName;
    }

    public String getCreatureEggName(String entity) {
        return this.getCreatureName(entity) + " Spawn Egg";
    }

    public void showAllCreatures(CommandSender sender) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entityType : this.displayNameToMobID.entrySet()) {
            String displayName = entityType.getKey();
            String entityId = entityType.getValue();
            displayName = displayName.replace(" ", "");
            if (!this.hasPermission((Permissible)sender, "silkspawners.list.", entityId)) continue;
            builder.append(displayName + ", ");
        }
        String message = builder.toString();
        if (StringUtils.isNotBlank((String)message)) {
            message = message.substring(0, message.length() - ", ".length());
        }
        this.sendMessage(sender, message);
    }

    public List<String> scanEntityMap() {
        List<String> entities = this.nmsProvider.rawEntityMap();
        if (entities == null) {
            SortedMap<Integer, String> legacyRawEntityMap = this.nmsProvider.legacyRawEntityMap();
            entities = new ArrayList<String>(legacyRawEntityMap.values());
            for (Map.Entry<Integer, String> entry : legacyRawEntityMap.entrySet()) {
                this.displayNameToMobID.put(entry.getKey().toString(), entry.getValue());
            }
        }
        if (entities.isEmpty()) {
            this.plugin.getLogger().warning("Warning, no mobs were found via reflection! This usually means another plugin messed up Minecraft's entity registry. Please report this! This is NOT a SilkSpawners bug");
        }
        for (EntityType type : EntityType.values()) {
            String name = type.getName();
            if (name == null || entities.stream().anyMatch(name::equalsIgnoreCase)) continue;
            entities.add(name);
        }
        return entities;
    }

    public void notify(Player player, String spawnerName) {
        if (this.isBarAPI()) {
            String shortInfo = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("informationOfSpawnerBar").replace("%creature%", spawnerName));
            BarAPI.setMessage((Player)player, (String)shortInfo, (int)this.plugin.getConfig().getInt("barAPI.displayTime", 3));
        } else if (this.isVanillaBossBar()) {
            String shortInfo = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("informationOfSpawnerBar").replace("%creature%", spawnerName));
            String barColor = this.plugin.getConfig().getString("vanillaBossBar.color", "RED");
            String barStyle = this.plugin.getConfig().getString("vanillaBossBar.style", "SOLID");
            int barTime = this.plugin.getConfig().getInt("vanillaBossBar.displayTime", 3);
            this.nmsProvider.displayBossBar(shortInfo, barColor, barStyle, player, (Plugin)this.plugin, barTime);
        } else {
            this.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("informationOfSpawner1").replace("%creature%", spawnerName)));
            this.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("informationOfSpawner2").replace("%creature%", spawnerName)));
        }
    }

    public void clearAll() {
        this.displayNameToMobID.clear();
        this.mobIDToDisplayName.clear();
        this.knownEntities.clear();
    }

    public boolean isEgg(String creatureString) {
        return creatureString.endsWith("egg");
    }

    public boolean isUnknown(String creatureString) {
        return !this.displayNameToMobID.containsKey(creatureString);
    }

    public boolean isKnown(String creatureString) {
        return this.displayNameToMobID.containsKey(creatureString);
    }

    public boolean isKnownEntityID(String entityID) {
        return this.knownEntities.contains(entityID);
    }

    public short getNumber(String number) {
        try {
            return Short.valueOf(number);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public boolean isValidItemAndHasSilkTouch(ItemStack tool) {
        if (tool == null) {
            return false;
        }
        boolean toolAllowed = false;
        Material toolType = tool.getType();
        List allowedTools = this.plugin.getConfig().getStringList("allowedTools");
        for (String allowedTool : allowedTools) {
            if (toolType == Material.matchMaterial((String)allowedTool)) {
                toolAllowed = true;
                break;
            }
            if (this.mimic == null || !this.mimic.getItemsRegistry().isSameItem((Object)tool, allowedTool)) continue;
            toolAllowed = true;
            break;
        }
        if (!toolAllowed) {
            this.plugin.getLogger().log(Level.FINE, "Tool not allowed: {0}", tool.getType());
            return false;
        }
        int minLevel = this.plugin.getConfig().getInt("minSilkTouchLevel", 1);
        this.plugin.getLogger().log(Level.FINE, "minLevel is {0}", minLevel);
        if (minLevel == 0) {
            return true;
        }
        if (!tool.containsEnchantment(Enchantment.SILK_TOUCH)) {
            this.plugin.getLogger().fine("Tool has no SilkTouch enchantment.");
            return false;
        }
        int enchantmentLevel = tool.getEnchantmentLevel(Enchantment.SILK_TOUCH);
        this.plugin.getLogger().log(Level.FINE, "Stored enchantment level is {0}", enchantmentLevel);
        return enchantmentLevel >= minLevel;
    }

    public String getCustomSpawnerName(String mobName) {
        if (this.plugin.mobs.contains("creatures." + mobName + ".spawnerName")) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.mobs.getString("creatures." + mobName + ".spawnerName", "Monster Spawner"));
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("spawnerName", "Monster Spawner"));
    }

    public void sendMessage(CommandSender receiver, String messages) {
        if (receiver == null || StringUtils.isBlank((String)messages)) {
            return;
        }
        receiver.sendMessage(messages.split("\n"));
    }

    private void getWorldGuard() {
        if (!this.plugin.getConfig().getBoolean("useWorldGuard", true)) {
            this.plugin.getLogger().info("WorldGuard support is disabled due to config setting");
            return;
        }
        Plugin worldGuard = this.plugin.getServer().getPluginManager().getPlugin("WorldGuard");
        if (worldGuard == null || !(worldGuard instanceof WorldGuardPlugin)) {
            this.plugin.getLogger().info("WorldGuard was not found and support is disabled");
            return;
        }
        this.plugin.getLogger().info("WorldGuard was found and support is enabled");
        this.wg = (WorldGuardPlugin)worldGuard;
    }

    private void getMimic() {
        if (!this.plugin.getConfig().getBoolean("useMimic", true)) {
            this.plugin.getLogger().info("Mimic support is disabled due to config setting");
            return;
        }
        Plugin mimicPlugin = this.plugin.getServer().getPluginManager().getPlugin("Mimic");
        if (mimicPlugin == null) {
            this.plugin.getLogger().info("Mimic was not found and support is disabled");
            return;
        }
        this.mimic = Mimic.getInstance();
        this.plugin.getLogger().info("Mimic was found and support is enabled");
    }

    public boolean canBuildHere(Player player, Location location) {
        if (this.wg == null) {
            return true;
        }
        try {
            WorldGuard instance = WorldGuard.getInstance();
            RegionContainer regionContainer = instance.getPlatform().getRegionContainer();
            RegionQuery query = regionContainer.createQuery();
            return query.testBuild(BukkitAdapter.adapt((Location)location), this.wg.wrapPlayer(player), new StateFlag[]{Flags.BUILD});
        }
        catch (Exception | NoClassDefFoundError e) {
            try {
                return (Boolean)this.wg.getClass().getDeclaredMethod("canBuild", Player.class, Location.class).invoke((Object)this.wg, player, location);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                e1.printStackTrace();
                return false;
            }
        }
    }

    public boolean isPluginEnabled(String _plugin) {
        Plugin pluginToCheck = this.plugin.getServer().getPluginManager().getPlugin(_plugin);
        return pluginToCheck != null && pluginToCheck.isEnabled();
    }

    public boolean isLegacySpawnEggs() {
        return this.nmsProvider.getSpawnEggMaterials().size() == 1;
    }

    public boolean hasPermission(Permissible permissible, String basePermission, String entityID) {
        if (StringUtils.isBlank((String)entityID) || permissible == null || StringUtils.isBlank((String)basePermission)) {
            this.plugin.getLogger().fine("permission check is false because the given input is invalid");
            return false;
        }
        this.plugin.getLogger().log(Level.FINE, "Checking if player has permission {0} for entityID {1}", new Object[]{basePermission, entityID});
        String correctedBasePermission = basePermission.endsWith(".") ? basePermission : basePermission + ".";
        for (Map.Entry<String, String> entry : this.displayNameToMobID.entrySet()) {
            String currentEntityID = entry.getValue();
            if (!currentEntityID.equalsIgnoreCase(entityID)) continue;
            this.plugin.getLogger().log(Level.FINE, "Found matching entityID from set: {0}, key is {1}", new Object[]{currentEntityID, entry.getKey()});
            boolean hasPermission = permissible.hasPermission(correctedBasePermission + entry.getKey().toLowerCase(Locale.ENGLISH).replace(" ", ""));
            this.plugin.getLogger().log(Level.FINE, "hasPermission result is {0}", hasPermission);
            if (!hasPermission) continue;
            return true;
        }
        this.plugin.getLogger().fine("Permission not found or not granted, result is false");
        return false;
    }

    @Generated
    public Map<String, String> getMobIDToDisplayName() {
        return this.mobIDToDisplayName;
    }

    @Generated
    public Map<String, String> getDisplayNameToMobID() {
        return this.displayNameToMobID;
    }

    @Generated
    public List<String> getKnownEntities() {
        return this.knownEntities;
    }

    @Generated
    public boolean isBarAPI() {
        return this.barAPI;
    }

    @Generated
    public void setBarAPI(boolean barAPI) {
        this.barAPI = barAPI;
    }
}

