/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.silkspawners.listeners;

import de.dustplanet.silkspawners.SilkSpawners;
import de.dustplanet.silkspawners.events.SilkSpawnersSpawnerBreakEvent;
import de.dustplanet.silkspawners.events.SilkSpawnersSpawnerPlaceEvent;
import de.dustplanet.util.SilkUtil;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class SilkSpawnersBlockListener
implements Listener {
    private final SilkSpawners plugin;
    private final SilkUtil su;
    private final Random rnd;

    public SilkSpawnersBlockListener(SilkSpawners instance, SilkUtil util) {
        this.plugin = instance;
        this.su = util;
        this.rnd = new Random();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        boolean isFakeEvent;
        this.plugin.getLogger().fine("Handling a block break event");
        boolean bl = isFakeEvent = !BlockBreakEvent.class.equals(event.getClass());
        if (isFakeEvent) {
            this.plugin.getLogger().log(Level.FINE, "Skipping block break event because the event is fake: {0}", event.getClass().getName());
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (block.getType() != this.su.nmsProvider.getSpawnerMaterial()) {
            this.plugin.getLogger().log(Level.FINE, "Skipping block break event because the block is not a spawner: {0}", block.getType().name());
            return;
        }
        if (!this.su.canBuildHere(player, block.getLocation())) {
            this.plugin.getLogger().fine("Skipping block break event because the player can't build here");
            return;
        }
        String entityID = this.su.getSpawnerEntityID(block);
        this.plugin.getLogger().log(Level.FINE, "The stored entity of the block is {0}", entityID);
        SilkSpawnersSpawnerBreakEvent breakEvent = new SilkSpawnersSpawnerBreakEvent(player, block, entityID);
        this.plugin.getServer().getPluginManager().callEvent((Event)breakEvent);
        if (breakEvent.isCancelled()) {
            this.plugin.getLogger().fine("Skipping block break event because the the SilkSpawnersBreakEvent was cancelled");
            event.setCancelled(true);
            return;
        }
        entityID = this.su.getDisplayNameToMobID().get(breakEvent.getEntityID());
        this.plugin.getLogger().log(Level.FINE, "The stored entity of the block is {0}", entityID);
        this.plugin.informPlayer(player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("spawnerBroken")).replace("%creature%", this.su.getCreatureName(entityID)));
        ItemStack tool = this.su.nmsProvider.getItemInHand(player);
        boolean validToolAndSilkTouch = this.su.isValidItemAndHasSilkTouch(tool);
        World world = player.getWorld();
        if (this.plugin.config.getBoolean("noDropsCreative", true) && player.getGameMode() == GameMode.CREATIVE) {
            this.plugin.getLogger().fine("Skipping block break event because the game mode is creative and noDropsCreative is true");
            return;
        }
        event.setExpToDrop(0);
        boolean mined = false;
        boolean dropXPOnlyOnDestroy = this.plugin.config.getBoolean("dropXPOnlyOnDestroy", false);
        if (this.plugin.config.getBoolean("preventXPFarming", true) && block.hasMetadata("mined")) {
            mined = ((MetadataValue)block.getMetadata("mined").get(0)).asBoolean();
            this.plugin.getLogger().fine("Checking mined flag of the block");
        }
        if (this.su.hasPermission((Permissible)player, "silkspawners.silkdrop.", entityID) || this.su.hasPermission((Permissible)player, "silkspawners.destroydrop.", entityID)) {
            int addXP = this.plugin.config.getInt("destroyDropXP");
            if (!(mined || addXP == 0 || dropXPOnlyOnDestroy && validToolAndSilkTouch)) {
                event.setExpToDrop(addXP);
                if (this.plugin.config.getBoolean("preventXPFarming", true)) {
                    block.setMetadata("mined", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
                    this.plugin.getLogger().fine("Setting mined flag of the placed block");
                }
            }
        }
        int randomNumber = this.rnd.nextInt(100);
        int dropChance = 0;
        if (validToolAndSilkTouch && this.su.hasPermission((Permissible)player, "silkspawners.silkdrop.", entityID) || this.su.hasPermission((Permissible)player, "silkspawners.nosilk.", entityID)) {
            this.plugin.getLogger().log(Level.FINE, "Player has silkdrop permission {0}", this.su.hasPermission((Permissible)player, "silkspawners.silkdrop.", entityID));
            this.plugin.getLogger().log(Level.FINE, "Player has nosilk permission {0}", this.su.hasPermission((Permissible)player, "silkspawners.nosilk.", entityID));
            dropChance = this.plugin.mobs.contains("creatures." + entityID + ".silkDropChance") ? this.plugin.mobs.getInt("creatures." + entityID + ".silkDropChance", 100) : this.plugin.config.getInt("silkDropChance", 100);
            this.plugin.getLogger().log(Level.FINE, "Drop chance is {0}", dropChance);
            if (randomNumber < dropChance) {
                this.plugin.getLogger().fine("Dice rolled, proceed");
                ItemStack breakEventDrop = breakEvent.getDrop();
                ItemStack spawnerItemStack = null;
                if (breakEventDrop != null) {
                    spawnerItemStack = breakEventDrop;
                } else {
                    int amount = 1;
                    amount = this.plugin.mobs.contains("creatures." + entityID + ".dropAmount") ? this.plugin.mobs.getInt("creatures." + entityID + ".dropAmount", 1) : this.plugin.config.getInt("dropAmount", 1);
                    spawnerItemStack = this.su.newSpawnerItem(entityID, this.su.getCustomSpawnerName(entityID), amount, false);
                }
                if (spawnerItemStack == null) {
                    this.plugin.getLogger().warning("Skipping dropping of spawner, since item is null");
                    return;
                }
                this.plugin.getLogger().log(Level.FINE, "Dropping {0} of {1} ", new Object[]{spawnerItemStack.getAmount(), spawnerItemStack.getType()});
                if (this.plugin.getConfig().getBoolean("dropSpawnerToInventory", false)) {
                    this.plugin.getLogger().fine("Dropping into the inventory");
                    HashMap additionalItems = player.getInventory().addItem(new ItemStack[]{spawnerItemStack});
                    if (!additionalItems.isEmpty()) {
                        this.plugin.getLogger().fine("Inventory is full, dropping the rest naturally on the ground");
                        for (ItemStack itemStack : additionalItems.values()) {
                            world.dropItemNaturally(block.getLocation(), itemStack);
                        }
                    }
                } else {
                    this.plugin.getLogger().fine("Dropping naturally on the ground");
                    world.dropItemNaturally(block.getLocation(), spawnerItemStack);
                }
            }
            return;
        }
        this.plugin.getLogger().log(Level.FINE, "Player has destroydrop permission {0}", this.su.hasPermission((Permissible)player, "silkspawners.destroydrop.", entityID));
        if (this.su.hasPermission((Permissible)player, "silkspawners.destroydrop.", entityID)) {
            int dropBars;
            this.plugin.getLogger().fine("Player has destroydrop, checking spawn eggs and iron bars drops");
            if (this.plugin.config.getBoolean("destroyDropEgg", false)) {
                randomNumber = this.rnd.nextInt(100);
                dropChance = this.plugin.mobs.contains("creatures." + entityID + ".eggDropChance") ? this.plugin.mobs.getInt("creatures." + entityID + ".eggDropChance", 100) : this.plugin.config.getInt("eggDropChance", 100);
                this.plugin.getLogger().log(Level.FINE, "Spawn egg drop chance is", dropChance);
                if (randomNumber < dropChance) {
                    this.plugin.getLogger().fine("Dropping a spawn egg on the ground");
                    world.dropItemNaturally(block.getLocation(), this.su.newEggItem(entityID, 1, this.su.getCreatureEggName(entityID)));
                }
            }
            if ((dropBars = this.plugin.config.getInt("destroyDropBars", 0)) != 0) {
                randomNumber = this.rnd.nextInt(100);
                dropChance = this.plugin.mobs.contains("creatures." + entityID + ".destroyDropChance") ? this.plugin.mobs.getInt("creatures." + entityID + ".destroyDropChance", 100) : this.plugin.config.getInt("destroyDropChance", 100);
                this.plugin.getLogger().log(Level.FINE, "Iron bars drop chance is", dropChance);
                if (randomNumber < dropChance) {
                    this.plugin.getLogger().fine("Dropping a iron bars on the ground");
                    world.dropItem(block.getLocation(), new ItemStack(this.su.nmsProvider.getIronFenceMaterial(), dropBars));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        boolean isFakeEvent;
        this.plugin.getLogger().fine("Handling a block place event");
        if (event.isCancelled()) {
            this.plugin.getLogger().fine("Returning because the event is already cancelled");
            return;
        }
        boolean bl = isFakeEvent = !BlockPlaceEvent.class.equals(event.getClass());
        if (isFakeEvent) {
            this.plugin.getLogger().fine("Skipping block place event because the event is fake");
            return;
        }
        Block blockPlaced = event.getBlockPlaced();
        if (blockPlaced.getType() != this.su.nmsProvider.getSpawnerMaterial()) {
            this.plugin.getLogger().fine("Skipping block place event because the placed block is not a spawner");
            return;
        }
        Player player = event.getPlayer();
        if (!this.su.canBuildHere(player, blockPlaced.getLocation())) {
            this.plugin.getLogger().fine("Skipping block break event because the player can't build here");
            return;
        }
        ItemStack item = event.getItemInHand();
        String entityID = this.su.getStoredSpawnerItemEntityID(item);
        this.plugin.getLogger().log(Level.FINE, "The stored entity of the item is {0}", entityID);
        boolean defaultID = false;
        if (entityID == null) {
            defaultID = true;
            entityID = this.su.getDefaultEntityID();
            this.plugin.getLogger().fine("Stored entity was null, setting default");
        }
        SilkSpawnersSpawnerPlaceEvent placeEvent = new SilkSpawnersSpawnerPlaceEvent(player, blockPlaced, entityID);
        this.plugin.getServer().getPluginManager().callEvent((Event)placeEvent);
        if (placeEvent.isCancelled()) {
            this.plugin.getLogger().fine("Skipping block place event because the SilkSpawnersPlaceEvent was cancelled");
            event.setCancelled(true);
            return;
        }
        entityID = placeEvent.getEntityID();
        this.plugin.getLogger().log(Level.FINE, "The stored entity of the item is {0}", entityID);
        String creatureName = this.su.getCreatureName(entityID);
        if (!this.su.hasPermission((Permissible)player, "silkspawners.place.", entityID)) {
            event.setCancelled(true);
            this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noPermissionPlace").replace("%ID%", entityID)).replace("%creature%", creatureName));
            this.plugin.getLogger().fine("Skipping block place event because the player is missing the permission");
            return;
        }
        if (defaultID) {
            this.plugin.informPlayer(player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("placingDefault")));
        } else {
            this.plugin.informPlayer(player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("spawnerPlaced")).replace("%creature%", this.su.getCreatureName(entityID)));
        }
        this.su.setSpawnerEntityID(blockPlaced, entityID);
        this.plugin.getLogger().log(Level.FINE, "Changing placed down item entity ID to {0}", entityID);
    }
}

