/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.silkspawners.configs;

import de.dustplanet.silkspawners.configs.AbstractConfiguration;
import de.dustplanet.util.CommentedConfiguration;
import java.util.ArrayList;
import org.bukkit.Material;

public class Config
extends AbstractConfiguration {
    public Config(CommentedConfiguration config) {
        super(config);
    }

    @Override
    public void loadConfig() {
        this.loadDefaultConfig();
        super.loadConfig();
    }

    private void loadDefaultConfig() {
        this.config.addDefault("autoUpdater", true);
        this.config.addComment("autoUpdater", "# See documentation at https://dev.bukkit.org/projects/silkspawners/pages/configuration", "", "# Should the plugin automatically update if an update is available?");
        this.config.addDefault("permissionExplode", false);
        this.config.addComment("permissionExplode", "", "# Should a permission be required when a spawner explodes by TNT to achieve a drop");
        this.config.addDefault("useWorldGuard", true);
        this.config.addComment("useWorldGuard", "", "# Should be checked for WorldGuard build ability to change spawners");
        this.config.addDefault("useMimic", true);
        this.config.addComment("useMimic", "", "# Allows you to use Mimic item IDs in allowedTools");
        this.config.addDefault("explosionDropChance", 30);
        this.config.addComment("explosionDropChance", "", "# Percentage of dropping a spawner block when TNT or creepers explode");
        this.config.addDefault("destroyDropChance", 100);
        this.config.addComment("destroyDropChance", "", "# Percentage of dropping a iron bars when a spawner is mined");
        this.config.addDefault("eggDropChance", 100);
        this.config.addComment("eggDropChance", "", "# Percentage of dropping an egg when a spawner is mined");
        this.config.addDefault("silkDropChance", 100);
        this.config.addComment("silkDropChance", "", "# Percentage of dropping the spawner when mined");
        this.config.addDefault("defaultCreature", "pig");
        this.config.addComment("defaultCreature", "", "# When generic spawner items are placed, spawn this creature (e.g. from /give or other plugins)", "# PIG (90) is Minecraft default (put NAMES or IDs (for Minecraft <1.13 here!)");
        this.config.addDefault("spawnerCommandReachDistance", 6);
        this.config.addComment("spawnerCommandReachDistance", "", "# How far is the spawner reachable with your crosshair (disable with -1)");
        this.config.addDefault("minSilkTouchLevel", 1);
        this.config.addComment("minSilkTouchLevel", "", "# Minimum silk touch level [can be changed via other plugins to a higher value]", "# Set it to 0 to mine it without silk touch");
        this.config.addDefault("noDropsCreative", true);
        this.config.addComment("noDropsCreative", "", "# If a player in creative destroys a spawner nothing is dropped");
        this.config.addDefault("destroyDropEgg", false);
        this.config.addComment("destroyDropEgg", "", "# If a spawner is destroyed, should the egg be dropped");
        this.config.addDefault("destroyDropXP", 0);
        this.config.addComment("destroyDropXP", "", "# If a spawner is destroyed, should XP be dropped");
        this.config.addDefault("dropSpawnerToInventory", false);
        this.config.addComment("dropSpawnerToInventory", "", "# If a spawner is mined, should it be directly added to the inventory of the player");
        this.config.addDefault("dropAmount", 1);
        this.config.addComment("dropAmount", "", "# Amount of spawners to be dropped when mined with valid silk touch");
        this.config.addDefault("preventXPFarming", true);
        this.config.addComment("preventXPFarming", "", "# Flag a spawner as already mined to prevent XP duping");
        this.config.addDefault("dropXPOnlyOnDestroy", false);
        this.config.addComment("dropXPOnlyOnDestroy", "", "# Drops XP only when a spawner is destroyed and not mined via silk touch");
        this.config.addDefault("destroyDropBars", 0);
        this.config.addComment("destroyDropBars", "", "# If a spawner is destroyed, should iron bars be dropped");
        this.config.addDefault("craftableSpawners", false);
        this.config.addComment("craftableSpawners", "", "# Should the player be able to craft spawners");
        this.config.addDefault("recipeTop", "AAA");
        this.config.addComment("recipeTop", "", "# Leave a slot empty (null/air)? Just make a space then, example 'A A' -> middle is free", "# X is always the egg");
        this.config.addDefault("recipeMiddle", "AXA");
        this.config.addDefault("recipeBottom", "AAA");
        this.config.addDefault("recipeAmount", 1);
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("A,IRON_FENCE");
        this.config.addDefault("ingredients", temp);
        this.config.addComment("ingredients", "", "# Custom example:", "#recipeTop: 'A A'", "#recipeMiddle: 'BXA'", "#recipeBottom: 'C D'", "#ingredients:", "#  - 'A,IRON_FENCE'", "#  - 'B,DIRT'", "#  - 'C,2'", "#  - 'D,5'", "", "# You can put IDs or the NAME here (please uppercase)", "# Add it for each custom ingredient you add, too!");
        this.config.addDefault("spawnersUnstackable", false);
        this.config.addComment("spawnersUnstackable", "", "# Should spawners be unstackable");
        this.config.addDefault("consumeEgg", true);
        this.config.addComment("consumeEgg", "", "# Should the egg be consumed when the spawner is changed with it");
        this.config.addDefault("enableCreatureDefault", true);
        this.config.addComment("enableCreatureDefault", "", "# Fallback if the creature should be enabled, if not specified for the entity");
        this.config.addDefault("disableChangeTypeWithEgg", false);
        this.config.addComment("disableChangeTypeWithEgg", "", "# Disable left click to change spawners, spawns a mob instead. Still blocks Vanilla right click behavior.");
        this.config.addDefault("spawnEggToSpawner", false);
        this.config.addComment("spawnEggToSpawner", "", "# Should instead of spawning a mob a MonsterSpawner be placed? (Uses consumeEgg value, too)");
        this.config.addDefault("spawnEggOverride", false);
        this.config.addComment("spawnEggOverride", "", "# Should the spawn algorithm be overridden? Allows spawning of non-standard entities");
        this.config.addDefault("spawnEggOverrideSpawnDefault", true);
        this.config.addComment("spawnEggOverrideSpawnDefault", "", "# Fallback if the creature should be spawned, if not specified for the entity");
        temp = new ArrayList();
        temp.add("WOOD_PICKAXE");
        temp.add("WOODEN_PICKAXE");
        temp.add(Material.STONE_PICKAXE.toString());
        temp.add(Material.IRON_PICKAXE.toString());
        temp.add("GOLD_PICKAXE");
        temp.add("GOLDEN_PICKAXE");
        temp.add(Material.DIAMOND_PICKAXE.toString());
        temp.add("NETHERITE_PICKAXE");
        this.config.addDefault("allowedTools", temp);
        this.config.addComment("allowedTools", "", "# Allowed set of tools which can mine a spawner. IDs are supported, too");
        this.config.addDefault("defaultAmountGive", 1);
        this.config.addComment("defaultAmountGive", "", "# Amount of spawners or eggs given to a player when the argument is omitted");
        this.config.addDefault("notifyOnClick", true);
        this.config.addComment("notifyOnClick", "", "# Notify the player about the spawner when he clicks it in the inventory");
        this.config.addDefault("notifyOnHold", true);
        this.config.addComment("notifyOnHold", "", "# Notify the player about the spawner when he holds the spawner in the hand");
        this.config.addDefault("barAPI.enable", false);
        this.config.addDefault("barAPI.displayTime", 3);
        this.config.addComment("barAPI", "", "# Configure displaying with BarAPI, time is in seconds");
        this.config.addDefault("vanillaBossBar.enable", true);
        this.config.addDefault("vanillaBossBar.displayTime", 3);
        this.config.addDefault("vanillaBossBar.color", "RED");
        this.config.addComment("vanillaBossBar.color", "", "# Valid colors are BLUE, GREEN, PINK, PURPLE, RED, WHITE, YELLOW");
        this.config.addDefault("vanillaBossBar.style", "SOLID");
        this.config.addComment("vanillaBossBar.style", "", "# Valid styles are SEGMENTED_10, SEGMENTED_12, SEGMENTED_20, SEGMENTED_6, SOLID");
        this.config.addComment("vanillaBossBar", "", "# Configure displaying with 1.9 BossBarApi, time is in seconds");
        this.config.addDefault("factionsSupport", false);
        this.config.addComment("factionsSupport", "", "# Prevent that a spawner is changed via eggs in other territories. Supported are Factions, Faction3 and FactionsUUID");
        this.config.addDefault("spillSpawnersFromCommands", false);
        this.config.addComment("spillSpawnersFromCommands", "", "# If the inventory of a player is full, drop spawners/eggs from /ss give on the ground");
        this.config.addDefault("checkForNerfFlags", true);
        this.config.addComment("checkForNerfFlags", "", "# Check for spigot.yml and paper.yml flags that conflict with SilkSpawners");
        this.config.addDefault("verboseMode", false);
        this.config.addComment("verboseMode", "", "# Puts more information out on startup and interactions, such as block placement and breaking");
        this.config.addDefault("useReflection", true);
        this.config.addComment("useReflection", "", "# Internal stuff, do NOT change unless advised - the plugin might break otherwise");
        this.config.addDefault("testMCVersion", true);
        this.config.addDefault("useMetadata", true);
    }
}

