/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.silkspawners.compat.v1_21_R1;

import com.google.common.base.CaseFormat;
import com.mojang.authlib.GameProfile;
import de.dustplanet.silkspawners.compat.api.NMSProvider;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.spigotmc.SpigotWorldConfig;

public class NMSHandler
implements NMSProvider {
    private Field tileField;
    private final Collection<Material> spawnEggs = Arrays.stream(Material.values()).filter(material -> material.name().endsWith("_SPAWN_EGG")).collect(Collectors.toList());

    public NMSHandler() {
        this(true);
    }

    public NMSHandler(boolean checkForNerfFlags) {
        try {
            this.tileField = CraftCreatureSpawner.class.getDeclaredField("snapshot");
            this.tileField.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            try {
                this.tileField = CraftBlockEntityState.class.getDeclaredField("snapshot");
                this.tileField.setAccessible(true);
            }
            catch (NoSuchFieldException | SecurityException e1) {
                Bukkit.getLogger().warning("[SilkSpawners] Reflection failed: " + e.getMessage() + " " + e1.getMessage());
                e.printStackTrace();
                e1.printStackTrace();
            }
        }
        if (checkForNerfFlags) {
            WorldServer handle = ((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle();
            try {
                SpigotWorldConfig spigotConfig = handle.spigotConfig;
                if (spigotConfig.nerfSpawnerMobs) {
                    Bukkit.getLogger().warning("[SilkSpawners] Warning! \"nerf-spawner-mobs\" is set to true in the spigot.yml! Spawned mobs WON'T HAVE ANY AI!");
                }
            }
            catch (NoSuchFieldError spigotConfig) {
                // empty catch block
            }
            try {
                Field paperConfigField = World.class.getDeclaredField("paperConfig");
                paperConfigField.setAccessible(true);
                Field ironGolemsCanSpawnInAirField = paperConfigField.getType().getDeclaredField("ironGolemsCanSpawnInAir");
                ironGolemsCanSpawnInAirField.setAccessible(true);
                if (!ironGolemsCanSpawnInAirField.getBoolean(paperConfigField.get(handle))) {
                    Bukkit.getLogger().warning("[SilkSpawners] Warning! \"iron-golems-can-spawn-in-air\" is set to false in the paper.yml! Iron Golem farms might not work!");
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldError | NoSuchFieldException | SecurityException throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void spawnEntity(org.bukkit.World w, String entityID, double x, double y, double z, Player player) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.a("id", entityID);
        WorldServer world = ((CraftWorld)w).getHandle();
        Optional entity = EntityTypes.a((NBTTagCompound)tag, (World)world);
        if (!entity.isPresent()) {
            Bukkit.getLogger().warning("[SilkSpawners] Failed to spawn, falling through. You should report this (entity == null)!");
            return;
        }
        float yaw = world.z.i() * -360.0f + 180.0f;
        ((Entity)entity.get()).b(x, y, z, yaw, 0.0f);
        ((CraftWorld)w).addEntity((Entity)entity.get(), CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        PacketPlayOutEntityHeadRotation rotationPacket = new PacketPlayOutEntityHeadRotation((Entity)entity.get(), (byte)yaw);
        PlayerConnection connection = ((CraftPlayer)player).getHandle().c;
        connection.b((Packet)rotationPacket);
    }

    @Override
    public List<String> rawEntityMap() {
        ArrayList<String> entities = new ArrayList<String>();
        try {
            RegistryBlocks entityTypeRegistry = BuiltInRegistries.f;
            for (EntityTypes next : entityTypeRegistry) {
                entities.add(EntityTypes.a((EntityTypes)next).a());
            }
        }
        catch (IllegalArgumentException | SecurityException e) {
            Bukkit.getLogger().severe("[SilkSpawners] Failed to dump entity map: " + e.getMessage());
            e.printStackTrace();
        }
        return entities;
    }

    @Override
    public String getMobNameOfSpawner(BlockState blockState) {
        CraftCreatureSpawner spawner = (CraftCreatureSpawner)blockState;
        try {
            TileEntityMobSpawner tile = (TileEntityMobSpawner)this.tileField.get(spawner);
            NBTTagCompound resourceLocation = tile.c().f.d();
            return resourceLocation != null ? resourceLocation.l("id").replace("minecraft:", "") : "";
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Bukkit.getLogger().warning("[SilkSpawners] Reflection failed: " + e.getMessage());
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public void setSpawnersUnstackable() {
        MinecraftKey resourceLocation = MinecraftKey.a((String)"minecraft", (String)"spawner");
        RegistryBlocks itemRegistry = BuiltInRegistries.g;
        Item spawner = (Item)itemRegistry.a(resourceLocation);
        DataComponentMap currentComponents = spawner.p();
        DataComponentMap updatedComponents = DataComponentMap.a((DataComponentMap)currentComponents, (DataComponentMap)DataComponentMap.a().a(DataComponents.c, (Object)1).a());
        try {
            Field components = Item.class.getDeclaredField("components");
            components.setAccessible(true);
            components.set(spawner, updatedComponents);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            try {
                Field components = Item.class.getDeclaredField("c");
                components.setAccessible(true);
                components.set(spawner, updatedComponents);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public boolean setMobNameOfSpawner(BlockState blockState, String mobID) {
        String safeMobID = this.caseFormatOf(mobID.replace(" ", "_")).to(CaseFormat.LOWER_UNDERSCORE, mobID.replace(" ", "_")).toLowerCase(Locale.ENGLISH);
        CraftCreatureSpawner spawner = (CraftCreatureSpawner)blockState;
        try {
            TileEntityMobSpawner tile = (TileEntityMobSpawner)this.tileField.get(spawner);
            RegistryBlocks entityTypeRegistry = BuiltInRegistries.f;
            MinecraftKey resourceLocation = MinecraftKey.a((String)"minecraft", (String)safeMobID);
            tile.c().a((EntityTypes)entityTypeRegistry.a(resourceLocation), (World)spawner.getWorldHandle().getMinecraftWorld(), spawner.getWorldHandle().E_(), spawner.getPosition());
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Bukkit.getLogger().warning("[SilkSpawners] Reflection failed: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public ItemStack setNBTEntityID(ItemStack item, String entity) {
        NBTTagCompound spawnDataTag;
        if (item == null || StringUtils.isBlank((String)entity)) {
            Bukkit.getLogger().warning("[SilkSpawners] Skipping invalid spawner to set NBT data on.");
            return null;
        }
        String prefixedEntity = !entity.startsWith("minecraft:") ? "minecraft:" + entity : entity;
        net.minecraft.world.item.ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((ItemStack)craftStack);
        CustomData blockData = (CustomData)itemStack.a(DataComponents.O, (Object)CustomData.a);
        CustomData customData = (CustomData)itemStack.a(DataComponents.b, (Object)CustomData.a);
        NBTTagCompound tag = blockData.c();
        NBTTagCompound customTag = customData.c();
        if (!customTag.e("SilkSpawners")) {
            customTag.a("SilkSpawners", (NBTBase)new NBTTagCompound());
        }
        customTag.p("SilkSpawners").a("entity", entity);
        tag.a("EntityId", entity);
        tag.a("id", TileEntityTypes.a((TileEntityTypes)TileEntityTypes.j).a());
        if (!tag.e("SpawnData")) {
            tag.a("SpawnData", (NBTBase)new NBTTagCompound());
        }
        if (!(spawnDataTag = tag.p("SpawnData")).e("entity")) {
            spawnDataTag.a("entity", (NBTBase)new NBTTagCompound());
        }
        spawnDataTag.p("entity").a("id", prefixedEntity);
        if (!tag.e("SpawnPotentials")) {
            tag.a("SpawnPotentials", (NBTBase)new NBTTagCompound());
        }
        if (!tag.e("EntityTag")) {
            tag.a("EntityTag", (NBTBase)new NBTTagCompound());
        }
        tag.p("EntityTag").a("id", prefixedEntity);
        itemStack.b(DataComponents.O, (Object)CustomData.a((NBTTagCompound)tag));
        itemStack.b(DataComponents.b, (Object)CustomData.a((NBTTagCompound)customTag));
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemStack);
    }

    @Override
    @Nullable
    public String getSilkSpawnersNBTEntityID(ItemStack item) {
        net.minecraft.world.item.ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((ItemStack)craftStack);
        CustomData blockEntityData = (CustomData)itemStack.a(DataComponents.b, (Object)CustomData.a);
        NBTTagCompound tag = blockEntityData.c();
        if (!tag.e("SilkSpawners")) {
            return null;
        }
        return tag.p("SilkSpawners").l("entity");
    }

    @Override
    @Nullable
    public String getVanillaNBTEntityID(ItemStack item) {
        net.minecraft.world.item.ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((ItemStack)craftStack);
        CustomData blockEntityData = (CustomData)itemStack.a(DataComponents.O, (Object)CustomData.a);
        NBTTagCompound tag = blockEntityData.c();
        if (tag.e("EntityId")) {
            return tag.l("EntityId");
        }
        if (tag.e("SpawnData") && tag.p("SpawnData").e("id")) {
            return tag.p("SpawnData").l("id");
        }
        if (tag.e("SpawnData") && tag.p("SpawnData").e("entity") && tag.p("SpawnData").p("entity").e("id")) {
            return tag.p("SpawnData").p("entity").l("id");
        }
        if (tag.e("SpawnPotentials") && !tag.c("SpawnPotentials", 8).isEmpty()) {
            return tag.c("SpawnPotentials", 8).a(0).p("Entity").l("id");
        }
        return null;
    }

    @Override
    public Block getSpawnerFacing(Player player, int distance) {
        Block block = player.getTargetBlock((Set)null, distance);
        if (block == null || block.getType() != Material.SPAWNER) {
            return null;
        }
        return block;
    }

    @Override
    public ItemStack newEggItem(String entityID, int amount, String displayName) {
        Material spawnEgg = Material.matchMaterial((String)(entityID.toUpperCase() + "_SPAWN_EGG"));
        if (spawnEgg == null) {
            spawnEgg = Material.LEGACY_MONSTER_EGG;
        }
        ItemStack item = new ItemStack(spawnEgg, amount);
        if (displayName != null) {
            ItemMeta itemMeta = item.getItemMeta();
            itemMeta.setDisplayName(displayName);
            item.setItemMeta(itemMeta);
        }
        net.minecraft.world.item.ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((ItemStack)craftStack);
        CustomData blockData = (CustomData)itemStack.a(DataComponents.M, (Object)CustomData.a);
        CustomData customData = (CustomData)itemStack.a(DataComponents.b, (Object)CustomData.a);
        NBTTagCompound tag = blockData.c();
        NBTTagCompound customTag = customData.c();
        if (!customTag.e("SilkSpawners")) {
            customTag.a("SilkSpawners", (NBTBase)new NBTTagCompound());
        }
        customTag.p("SilkSpawners").a("entity", entityID);
        String prefixedEntity = !entityID.startsWith("minecraft:") ? "minecraft:" + entityID : entityID;
        tag.a("id", prefixedEntity);
        itemStack.b(DataComponents.M, (Object)CustomData.a((NBTTagCompound)tag));
        itemStack.b(DataComponents.b, (Object)CustomData.a((NBTTagCompound)customTag));
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemStack);
    }

    @Override
    public String getVanillaEggNBTEntityID(ItemStack item) {
        net.minecraft.world.item.ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((ItemStack)craftStack);
        CustomData blockEntityData = (CustomData)itemStack.a(DataComponents.M, (Object)CustomData.a);
        NBTTagCompound tag = blockEntityData.c();
        if (tag.e("id")) {
            return tag.l("id").replace("minecraft:", "");
        }
        RegistryBlocks itemRegistry = BuiltInRegistries.g;
        MinecraftKey vanillaKey = itemRegistry.b((Object)itemStack.g());
        if (vanillaKey != null) {
            return vanillaKey.a().replace("minecraft:", "").replace("_spawn_egg", "");
        }
        return null;
    }

    @Override
    public void displayBossBar(String title, String colorName, String styleName, Player player, Plugin plugin, int period) {
        BarColor color = BarColor.valueOf((String)colorName.toUpperCase());
        BarStyle style = BarStyle.valueOf((String)styleName.toUpperCase());
        final BossBar bar = Bukkit.createBossBar((String)title, (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
        bar.addPlayer(player);
        bar.setVisible(true);
        final double interval = 1.0 / (double)((long)period * 20L);
        new BukkitRunnable(){

            public void run() {
                double progress = bar.getProgress();
                double newProgress = progress - interval;
                if (progress <= 0.0 || newProgress <= 0.0) {
                    bar.setVisible(false);
                    bar.removeAll();
                    this.cancel();
                } else {
                    bar.setProgress(newProgress);
                }
            }
        }.runTaskTimerAsynchronously(plugin, 0L, 1L);
    }

    @Override
    public Player getPlayer(String playerUUIDOrName) {
        try {
            UUID playerUUID = UUID.fromString(playerUUIDOrName);
            return Bukkit.getPlayer((UUID)playerUUID);
        }
        catch (IllegalArgumentException e) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!onlinePlayer.getName().equalsIgnoreCase(playerUUIDOrName)) continue;
                return onlinePlayer;
            }
            return null;
        }
    }

    @Override
    public ItemStack getItemInHand(Player player) {
        return player.getInventory().getItemInMainHand();
    }

    @Override
    public void reduceEggs(Player player) {
        ItemStack itemInMainHand = player.getInventory().getItemInMainHand();
        ItemStack itemInOffHand = player.getInventory().getItemInOffHand();
        if (this.getSpawnEggMaterials().contains(itemInMainHand.getType())) {
            ItemStack eggs = itemInMainHand;
            if (eggs.getAmount() == 1) {
                player.getInventory().setItemInMainHand(null);
            } else {
                eggs.setAmount(eggs.getAmount() - 1);
                player.getInventory().setItemInMainHand(eggs);
            }
        } else {
            ItemStack eggs = itemInOffHand;
            if (eggs.getAmount() == 1) {
                player.getInventory().setItemInOffHand(null);
            } else {
                eggs.setAmount(eggs.getAmount() - 1);
                player.getInventory().setItemInOffHand(eggs);
            }
        }
    }

    @Override
    public ItemStack getSpawnerItemInHand(Player player) {
        PlayerInventory inv = player.getInventory();
        ItemStack mainHand = inv.getItemInMainHand();
        ItemStack offHand = inv.getItemInOffHand();
        if ((this.getSpawnEggMaterials().contains(mainHand.getType()) || mainHand.getType() == Material.SPAWNER) && (this.getSpawnEggMaterials().contains(offHand.getType()) || offHand.getType() == Material.SPAWNER)) {
            return null;
        }
        if (this.getSpawnEggMaterials().contains(mainHand.getType()) || mainHand.getType() == Material.SPAWNER) {
            return mainHand;
        }
        if (this.getSpawnEggMaterials().contains(offHand.getType()) || offHand.getType() == Material.SPAWNER) {
            return offHand;
        }
        return null;
    }

    @Override
    public void setSpawnerItemInHand(Player player, ItemStack newItem) {
        PlayerInventory inv = player.getInventory();
        ItemStack mainHand = inv.getItemInMainHand();
        ItemStack offHand = inv.getItemInOffHand();
        if ((this.getSpawnEggMaterials().contains(mainHand.getType()) || mainHand.getType() == Material.SPAWNER) && (this.getSpawnEggMaterials().contains(offHand.getType()) || offHand.getType() == Material.SPAWNER)) {
            return;
        }
        if (this.getSpawnEggMaterials().contains(mainHand.getType()) || mainHand.getType() == Material.SPAWNER) {
            inv.setItemInMainHand(newItem);
        } else if (this.getSpawnEggMaterials().contains(offHand.getType()) || offHand.getType() == Material.SPAWNER) {
            inv.setItemInOffHand(newItem);
        }
    }

    @Override
    public Material getSpawnEggMaterial() {
        return Material.LEGACY_MONSTER_EGG;
    }

    @Override
    public Collection<Material> getSpawnEggMaterials() {
        return this.spawnEggs;
    }

    @Override
    public Player loadPlayer(OfflinePlayer offline) {
        if (!offline.hasPlayedBefore()) {
            return null;
        }
        GameProfile profile = new GameProfile(offline.getUniqueId(), offline.getName() != null ? offline.getName() : offline.getUniqueId().toString());
        DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
        EntityPlayer entity = new EntityPlayer((MinecraftServer)server, server.a(World.h), profile, ClientInformation.a());
        CraftPlayer target = entity.getBukkitEntity();
        if (target != null) {
            target.loadData();
        }
        return target;
    }
}

