/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.silkspawners.compat.v1_13_R2;

import com.google.common.base.CaseFormat;
import com.mojang.authlib.GameProfile;
import de.dustplanet.silkspawners.compat.api.NMSProvider;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.server.v1_13_R2.DimensionManager;
import net.minecraft.server.v1_13_R2.Entity;
import net.minecraft.server.v1_13_R2.EntityPlayer;
import net.minecraft.server.v1_13_R2.EntityTypes;
import net.minecraft.server.v1_13_R2.IRegistry;
import net.minecraft.server.v1_13_R2.Item;
import net.minecraft.server.v1_13_R2.ItemStack;
import net.minecraft.server.v1_13_R2.MinecraftKey;
import net.minecraft.server.v1_13_R2.MinecraftServer;
import net.minecraft.server.v1_13_R2.NBTBase;
import net.minecraft.server.v1_13_R2.NBTTagCompound;
import net.minecraft.server.v1_13_R2.Packet;
import net.minecraft.server.v1_13_R2.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_13_R2.PlayerInteractManager;
import net.minecraft.server.v1_13_R2.TileEntityMobSpawner;
import net.minecraft.server.v1_13_R2.TileEntityTypes;
import net.minecraft.server.v1_13_R2.World;
import net.minecraft.server.v1_13_R2.WorldServer;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_13_R2.CraftServer;
import org.bukkit.craftbukkit.v1_13_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_13_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_13_R2.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_13_R2.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.spigotmc.SpigotWorldConfig;

public class NMSHandler
implements NMSProvider {
    private Field tileField;
    private final Collection<Material> spawnEggs = Arrays.stream(Material.values()).filter(material -> material.name().endsWith("_SPAWN_EGG")).collect(Collectors.toList());

    public NMSHandler() {
        this(true);
    }

    public NMSHandler(boolean checkForNerfFlags) {
        try {
            this.tileField = CraftCreatureSpawner.class.getDeclaredField("spawner");
            this.tileField.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            try {
                this.tileField = CraftBlockEntityState.class.getDeclaredField("snapshot");
                this.tileField.setAccessible(true);
            }
            catch (NoSuchFieldException | SecurityException e1) {
                Bukkit.getLogger().warning("[SilkSpawners] Reflection failed: " + e.getMessage() + " " + e1.getMessage());
                e.printStackTrace();
                e1.printStackTrace();
            }
        }
        if (checkForNerfFlags) {
            WorldServer handle = ((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle();
            try {
                SpigotWorldConfig spigotConfig = handle.spigotConfig;
                if (spigotConfig.nerfSpawnerMobs) {
                    Bukkit.getLogger().warning("[SilkSpawners] Warning! \"nerf-spawner-mobs\" is set to true in the spigot.yml! Spawned mobs WON'T HAVE ANY AI!");
                }
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    @Override
    public void spawnEntity(org.bukkit.World w, String entityID, double x, double y, double z, Player player) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setString("id", entityID);
        WorldServer world = ((CraftWorld)w).getHandle();
        Entity entity = EntityTypes.a((NBTTagCompound)tag, (World)world);
        if (entity == null) {
            Bukkit.getLogger().warning("[SilkSpawners] Failed to spawn, falling through. You should report this (entity == null)!");
            return;
        }
        float yaw = world.random.nextFloat() * -360.0f + 180.0f;
        entity.setPositionRotation(x, y, z, yaw, 0.0f);
        world.addEntity(entity, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        PacketPlayOutEntityHeadRotation rotation = new PacketPlayOutEntityHeadRotation(entity, (byte)yaw);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)rotation);
    }

    @Override
    public List<String> rawEntityMap() {
        ArrayList<String> entities = new ArrayList<String>();
        try {
            IRegistry entityTypeRegistry = IRegistry.ENTITY_TYPE;
            for (EntityTypes next : entityTypeRegistry) {
                entities.add(EntityTypes.getName((EntityTypes)next).getKey());
            }
        }
        catch (IllegalArgumentException | SecurityException e) {
            Bukkit.getLogger().severe("[SilkSpawners] Failed to dump entity map: " + e.getMessage());
            e.printStackTrace();
        }
        return entities;
    }

    @Override
    public String getMobNameOfSpawner(BlockState blockState) {
        CraftCreatureSpawner spawner = (CraftCreatureSpawner)blockState;
        try {
            TileEntityMobSpawner tile = (TileEntityMobSpawner)this.tileField.get(spawner);
            MinecraftKey minecraftKey = tile.getSpawner().getMobName();
            return minecraftKey != null ? minecraftKey.getKey() : "";
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Bukkit.getLogger().warning("[SilkSpawners] Reflection failed: " + e.getMessage());
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public void setSpawnersUnstackable() {
        try {
            Item spawner = (Item)IRegistry.ITEM.get(new MinecraftKey("spawner"));
            Field maxStackSize = Item.class.getDeclaredField("maxStackSize");
            maxStackSize.setAccessible(true);
            maxStackSize.set(spawner, 1);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean setMobNameOfSpawner(BlockState blockState, String mobID) {
        String safeMobID = this.caseFormatOf(mobID.replace(" ", "_")).to(CaseFormat.LOWER_UNDERSCORE, mobID.replace(" ", "_")).toLowerCase(Locale.ENGLISH);
        CraftCreatureSpawner spawner = (CraftCreatureSpawner)blockState;
        try {
            TileEntityMobSpawner tile = (TileEntityMobSpawner)this.tileField.get(spawner);
            tile.getSpawner().setMobName((EntityTypes)IRegistry.ENTITY_TYPE.get(new MinecraftKey(safeMobID)));
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Bukkit.getLogger().warning("[SilkSpawners] Reflection failed: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public org.bukkit.inventory.ItemStack setNBTEntityID(org.bukkit.inventory.ItemStack item, String entity) {
        if (item == null || StringUtils.isBlank((String)entity)) {
            Bukkit.getLogger().warning("[SilkSpawners] Skipping invalid spawner to set NBT data on.");
            return null;
        }
        String prefixedEntity = !entity.startsWith("minecraft:") ? "minecraft:" + entity : entity;
        ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((org.bukkit.inventory.ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getOrCreateTag();
        if (!tag.hasKey("SilkSpawners")) {
            tag.set("SilkSpawners", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("SilkSpawners").setString("entity", entity);
        if (!tag.hasKey("BlockEntityTag")) {
            tag.set("BlockEntityTag", (NBTBase)new NBTTagCompound());
        }
        tag = tag.getCompound("BlockEntityTag");
        tag.setString("EntityId", entity);
        tag.setString("id", TileEntityTypes.a((TileEntityTypes)TileEntityTypes.MOB_SPAWNER).getKey());
        if (!tag.hasKey("SpawnData")) {
            tag.set("SpawnData", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("SpawnData").setString("id", prefixedEntity);
        if (!tag.hasKey("SpawnPotentials")) {
            tag.set("SpawnPotentials", (NBTBase)new NBTTagCompound());
        }
        if (!tag.hasKey("EntityTag")) {
            tag.set("EntityTag", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("EntityTag").setString("id", prefixedEntity);
        return CraftItemStack.asCraftMirror((ItemStack)itemStack);
    }

    @Override
    @Nullable
    public String getSilkSpawnersNBTEntityID(org.bukkit.inventory.ItemStack item) {
        ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((org.bukkit.inventory.ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getTag();
        if (tag == null || !tag.hasKey("SilkSpawners")) {
            return null;
        }
        return tag.getCompound("SilkSpawners").getString("entity");
    }

    @Override
    @Nullable
    public String getVanillaNBTEntityID(org.bukkit.inventory.ItemStack item) {
        ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((org.bukkit.inventory.ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getTag();
        if (tag == null || !tag.hasKey("BlockEntityTag")) {
            return null;
        }
        tag = tag.getCompound("BlockEntityTag");
        tag.setString("id", TileEntityTypes.a((TileEntityTypes)TileEntityTypes.MOB_SPAWNER).getKey());
        if (tag.hasKey("EntityId")) {
            return tag.getString("EntityId");
        }
        if (tag.hasKey("SpawnData") && tag.getCompound("SpawnData").hasKey("id")) {
            return tag.getCompound("SpawnData").getString("id");
        }
        if (tag.hasKey("SpawnPotentials") && !tag.getList("SpawnPotentials", 8).isEmpty()) {
            return tag.getList("SpawnPotentials", 8).getCompound(0).getCompound("Entity").getString("id");
        }
        return null;
    }

    @Override
    public Block getSpawnerFacing(Player player, int distance) {
        Block block = player.getTargetBlock((Set)null, distance);
        if (block == null || block.getType() != Material.SPAWNER) {
            return null;
        }
        return block;
    }

    @Override
    public org.bukkit.inventory.ItemStack newEggItem(String entityID, int amount, String displayName) {
        Material spawnEgg = Material.matchMaterial((String)(entityID.toUpperCase() + "_SPAWN_EGG"));
        if (spawnEgg == null) {
            spawnEgg = Material.LEGACY_MONSTER_EGG;
        }
        org.bukkit.inventory.ItemStack item = new org.bukkit.inventory.ItemStack(spawnEgg, amount);
        if (displayName != null) {
            ItemMeta itemMeta = item.getItemMeta();
            itemMeta.setDisplayName(displayName);
            item.setItemMeta(itemMeta);
        }
        ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((org.bukkit.inventory.ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getOrCreateTag();
        if (!tag.hasKey("SilkSpawners")) {
            tag.set("SilkSpawners", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("SilkSpawners").setString("entity", entityID);
        if (!tag.hasKey("EntityTag")) {
            tag.set("EntityTag", (NBTBase)new NBTTagCompound());
        }
        String prefixedEntity = !entityID.startsWith("minecraft:") ? "minecraft:" + entityID : entityID;
        tag.getCompound("EntityTag").setString("id", prefixedEntity);
        return CraftItemStack.asCraftMirror((ItemStack)itemStack);
    }

    @Override
    public String getVanillaEggNBTEntityID(org.bukkit.inventory.ItemStack item) {
        ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((org.bukkit.inventory.ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getTag();
        if (tag == null || !tag.hasKey("EntityTag")) {
            MinecraftKey vanillaKey = IRegistry.ITEM.getKey((Object)itemStack.getItem());
            if (vanillaKey != null) {
                return vanillaKey.getKey().replace("minecraft:", "").replace("_spawn_egg", "");
            }
        } else if ((tag = tag.getCompound("EntityTag")).hasKey("id")) {
            return tag.getString("id").replace("minecraft:", "");
        }
        return null;
    }

    @Override
    public void displayBossBar(String title, String colorName, String styleName, Player player, Plugin plugin, int period) {
        BarColor color = BarColor.valueOf((String)colorName.toUpperCase());
        BarStyle style = BarStyle.valueOf((String)styleName.toUpperCase());
        final BossBar bar = Bukkit.createBossBar((String)title, (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
        bar.addPlayer(player);
        bar.setVisible(true);
        final double interval = 1.0 / (double)((long)period * 20L);
        new BukkitRunnable(){

            public void run() {
                double progress = bar.getProgress();
                double newProgress = progress - interval;
                if (progress <= 0.0 || newProgress <= 0.0) {
                    bar.setVisible(false);
                    bar.removeAll();
                    this.cancel();
                } else {
                    bar.setProgress(newProgress);
                }
            }
        }.runTaskTimerAsynchronously(plugin, 0L, 1L);
    }

    @Override
    public Player getPlayer(String playerUUIDOrName) {
        try {
            UUID playerUUID = UUID.fromString(playerUUIDOrName);
            return Bukkit.getPlayer((UUID)playerUUID);
        }
        catch (IllegalArgumentException e) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!onlinePlayer.getName().equalsIgnoreCase(playerUUIDOrName)) continue;
                return onlinePlayer;
            }
            return null;
        }
    }

    @Override
    public org.bukkit.inventory.ItemStack getItemInHand(Player player) {
        return player.getInventory().getItemInMainHand();
    }

    @Override
    public void reduceEggs(Player player) {
        org.bukkit.inventory.ItemStack itemInMainHand = player.getInventory().getItemInMainHand();
        org.bukkit.inventory.ItemStack itemInOffHand = player.getInventory().getItemInOffHand();
        if (this.getSpawnEggMaterials().contains(itemInMainHand.getType())) {
            org.bukkit.inventory.ItemStack eggs = itemInMainHand;
            if (eggs.getAmount() == 1) {
                player.getInventory().setItemInMainHand(null);
            } else {
                eggs.setAmount(eggs.getAmount() - 1);
                player.getInventory().setItemInMainHand(eggs);
            }
        } else {
            org.bukkit.inventory.ItemStack eggs = itemInOffHand;
            if (eggs.getAmount() == 1) {
                player.getInventory().setItemInOffHand(null);
            } else {
                eggs.setAmount(eggs.getAmount() - 1);
                player.getInventory().setItemInOffHand(eggs);
            }
        }
    }

    @Override
    public org.bukkit.inventory.ItemStack getSpawnerItemInHand(Player player) {
        PlayerInventory inv = player.getInventory();
        org.bukkit.inventory.ItemStack mainHand = inv.getItemInMainHand();
        org.bukkit.inventory.ItemStack offHand = inv.getItemInOffHand();
        if ((this.getSpawnEggMaterials().contains(mainHand.getType()) || mainHand.getType() == Material.SPAWNER) && (this.getSpawnEggMaterials().contains(offHand.getType()) || offHand.getType() == Material.SPAWNER)) {
            return null;
        }
        if (this.getSpawnEggMaterials().contains(mainHand.getType()) || mainHand.getType() == Material.SPAWNER) {
            return mainHand;
        }
        if (this.getSpawnEggMaterials().contains(offHand.getType()) || offHand.getType() == Material.SPAWNER) {
            return offHand;
        }
        return null;
    }

    @Override
    public void setSpawnerItemInHand(Player player, org.bukkit.inventory.ItemStack newItem) {
        PlayerInventory inv = player.getInventory();
        org.bukkit.inventory.ItemStack mainHand = inv.getItemInMainHand();
        org.bukkit.inventory.ItemStack offHand = inv.getItemInOffHand();
        if ((this.getSpawnEggMaterials().contains(mainHand.getType()) || mainHand.getType() == Material.SPAWNER) && (this.getSpawnEggMaterials().contains(offHand.getType()) || offHand.getType() == Material.SPAWNER)) {
            return;
        }
        if (this.getSpawnEggMaterials().contains(mainHand.getType()) || mainHand.getType() == Material.SPAWNER) {
            inv.setItemInMainHand(newItem);
        } else if (this.getSpawnEggMaterials().contains(offHand.getType()) || offHand.getType() == Material.SPAWNER) {
            inv.setItemInOffHand(newItem);
        }
    }

    @Override
    public Material getSpawnEggMaterial() {
        return Material.LEGACY_MONSTER_EGG;
    }

    @Override
    public Collection<Material> getSpawnEggMaterials() {
        return this.spawnEggs;
    }

    @Override
    public Player loadPlayer(OfflinePlayer offline) {
        if (!offline.hasPlayedBefore()) {
            return null;
        }
        GameProfile profile = new GameProfile(offline.getUniqueId(), offline.getName() != null ? offline.getName() : offline.getUniqueId().toString());
        MinecraftServer server = ((CraftServer)Bukkit.getServer()).getServer();
        EntityPlayer entity = new EntityPlayer(server, server.getWorldServer(DimensionManager.OVERWORLD), profile, new PlayerInteractManager((World)server.getWorldServer(DimensionManager.OVERWORLD)));
        CraftPlayer target = entity.getBukkitEntity();
        if (target != null) {
            target.loadData();
        }
        return target;
    }
}

