/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.silkspawners.commands;

import de.dustplanet.silkspawners.SilkSpawners;
import de.dustplanet.silkspawners.events.SilkSpawnersSpawnerChangeEvent;
import de.dustplanet.util.SilkUtil;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;

public class SpawnerCommand
implements CommandExecutor {
    private final SilkUtil su;
    private final SilkSpawners plugin;

    public SpawnerCommand(SilkSpawners instance, SilkUtil util) {
        this.su = util;
        this.plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        block0 : switch (args.length) {
            case 1: {
                switch (args[0].toLowerCase(Locale.ENGLISH)) {
                    case "help": {
                        this.handleHelp(sender);
                        break block0;
                    }
                    case "all": 
                    case "list": {
                        this.handleList(sender);
                        break block0;
                    }
                    case "reload": 
                    case "rl": {
                        this.handleReload(sender);
                        break block0;
                    }
                    case "info": 
                    case "view": {
                        this.handleView(sender);
                        break block0;
                    }
                }
                this.handleUnknownArgument(sender);
                break;
            }
            case 2: {
                switch (args[0].toLowerCase(Locale.ENGLISH)) {
                    case "change": 
                    case "set": {
                        this.handleChange(sender, args[1]);
                        break block0;
                    }
                    case "selfget": 
                    case "i": {
                        this.handleGive(sender, sender.getName(), args[1], null);
                        break block0;
                    }
                }
                this.handleUnknownArgument(sender);
                break;
            }
            case 3: {
                switch (args[0].toLowerCase(Locale.ENGLISH)) {
                    case "give": 
                    case "add": {
                        this.handleGive(sender, args[1], args[2].toLowerCase(Locale.ENGLISH), null);
                        break block0;
                    }
                    case "selfget": 
                    case "i": {
                        this.handleGive(sender, sender.getName(), args[1], args[2]);
                        break block0;
                    }
                }
                this.handleUnknownArgument(sender);
                break;
            }
            case 4: {
                switch (args[0].toLowerCase(Locale.ENGLISH)) {
                    case "give": 
                    case "add": {
                        this.handleGive(sender, args[1], args[2].toLowerCase(Locale.ENGLISH), args[3]);
                        break block0;
                    }
                }
                this.handleUnknownArgument(sender);
                break;
            }
            default: {
                this.handleUnknownArgument(sender);
            }
        }
        return true;
    }

    private void handleGive(CommandSender sender, String receiver, String mob, String amountString) {
        int amount = this.plugin.config.getInt("defaultAmountGive", 1);
        boolean saveData = false;
        if (StringUtils.isNotBlank((String)amountString) && (amount = (int)this.su.getNumber(amountString)) == -1) {
            this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("useNumbers")));
            return;
        }
        Player player = this.su.nmsProvider.getPlayer(receiver);
        if (player == null) {
            player = this.su.nmsProvider.loadPlayer(Bukkit.getOfflinePlayer((String)receiver));
            if (player == null) {
                this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("playerOffline")));
                return;
            }
            saveData = true;
        }
        boolean isEgg = this.su.isEgg(mob);
        String egg = mob;
        if (isEgg) {
            egg = egg.replaceFirst("egg$", "");
        }
        if (isEgg) {
            this.handleGiveEgg(sender, player, egg, amount, saveData);
        } else {
            this.handleGiveSpawner(sender, player, mob, amount, saveData);
        }
    }

    private void handleGiveEgg(CommandSender sender, Player receiver, String mob, int amount, boolean saveData) {
        if (this.su.isUnknown(mob)) {
            this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("unknownCreature")).replace("%creature%", mob));
            return;
        }
        String entityID = this.su.getDisplayNameToMobID().get(mob);
        String creature = this.su.getCreatureName(entityID);
        if (this.su.hasPermission((Permissible)sender, "silkspawners.freeitemegg.", entityID)) {
            ItemStack eggItemStack = this.su.newEggItem(entityID, amount, this.su.getCreatureEggName(entityID));
            HashMap leftOvers = receiver.getInventory().addItem(new ItemStack[]{eggItemStack});
            if (!leftOvers.values().isEmpty()) {
                if (this.plugin.getConfig().getBoolean("spillSpawnersFromCommands", false)) {
                    World world = receiver.getWorld();
                    world.dropItemNaturally(receiver.getLocation(), eggItemStack);
                    this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noFreeSlotDroppedGround")));
                    return;
                }
                this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noFreeSlot")));
                return;
            }
            if (saveData) {
                receiver.saveData();
            }
            if (sender instanceof Player) {
                Player pSender = (Player)sender;
                if (pSender.getUniqueId() == receiver.getUniqueId()) {
                    this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("addedEgg")).replace("%creature%", creature).replace("%amount%", Integer.toString(amount)));
                } else {
                    this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("addedEggOtherPlayer").replace("%player%", receiver.getName())).replace("%creature%", creature).replace("%amount%", Integer.toString(amount)));
                }
            } else {
                this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("addedEggOtherPlayer").replace("%player%", receiver.getName())).replace("%creature%", creature).replace("%amount%", Integer.toString(amount)));
            }
            return;
        }
        this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noPermissionFreeEgg")));
    }

    private void handleGiveSpawner(CommandSender sender, Player receiver, String mob, int amount, boolean saveData) {
        if (this.su.isUnknown(mob)) {
            this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("unknownCreature")).replace("%creature%", mob));
            return;
        }
        String entityID = this.su.getDisplayNameToMobID().get(mob);
        String creature = this.su.getCreatureName(entityID);
        if (this.su.hasPermission((Permissible)sender, "silkspawners.freeitem.", entityID)) {
            ItemStack spawnerItemStack = this.su.newSpawnerItem(entityID, this.su.getCustomSpawnerName(entityID), amount, false);
            HashMap leftOvers = receiver.getInventory().addItem(new ItemStack[]{spawnerItemStack});
            if (!leftOvers.values().isEmpty()) {
                if (this.plugin.getConfig().getBoolean("spillSpawnersFromCommands", false)) {
                    World world = receiver.getWorld();
                    world.dropItemNaturally(receiver.getLocation(), spawnerItemStack);
                    this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noFreeSlotDroppedGround")));
                    return;
                }
                this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noFreeSlot")));
                return;
            }
            if (saveData) {
                receiver.saveData();
            }
            if (sender instanceof Player) {
                Player pSender = (Player)sender;
                if (pSender.getUniqueId() == receiver.getUniqueId()) {
                    this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("addedSpawner")).replace("%creature%", creature).replace("%amount%", Integer.toString(amount)));
                } else {
                    this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("addedSpawnerOtherPlayer").replace("%player%", receiver.getName())).replace("%creature%", creature).replace("%amount%", Integer.toString(amount)));
                }
            } else {
                this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("addedSpawnerOtherPlayer").replace("%player%", receiver.getName())).replace("%creature%", creature).replace("%amount%", Integer.toString(amount)));
            }
            return;
        }
        this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noPermissionFreeSpawner")));
    }

    private void handleChange(CommandSender sender, String newMob) {
        if (sender instanceof Player) {
            Material itemMaterial;
            Block block;
            if (this.su.isUnknown(newMob)) {
                this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("unknownCreature")).replace("%creature%", newMob));
                return;
            }
            String entityID = this.su.getDisplayNameToMobID().get(newMob);
            Player player = (Player)sender;
            int distance = this.plugin.config.getInt("spawnerCommandReachDistance", 6);
            if (distance != -1 && (block = this.su.nmsProvider.getSpawnerFacing(player, distance)) != null) {
                this.handleBlockChange(player, block, entityID);
                return;
            }
            ItemStack itemInHand = this.su.nmsProvider.getSpawnerItemInHand(player);
            try {
                itemMaterial = itemInHand.getType();
            }
            catch (NullPointerException e) {
                itemMaterial = null;
            }
            if (itemMaterial != null && itemMaterial == this.su.nmsProvider.getSpawnerMaterial()) {
                this.handleChangeSpawner(player, entityID, itemInHand);
            } else if (itemMaterial != null && this.su.nmsProvider.getSpawnEggMaterials().contains(itemMaterial)) {
                this.handleChangeEgg(player, entityID, itemInHand);
            } else {
                this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("spawnerNotDeterminable")));
            }
        } else {
            this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noConsole")));
        }
    }

    private void handleBlockChange(Player player, Block block, String entityID) {
        if (!this.su.hasPermission((Permissible)player, "silkspawners.changetype.", entityID)) {
            this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noPermissionChangingSpawner")));
            return;
        }
        SilkSpawnersSpawnerChangeEvent changeEvent = new SilkSpawnersSpawnerChangeEvent(player, block, entityID, this.su.getSpawnerEntityID(block), 1);
        this.plugin.getServer().getPluginManager().callEvent((Event)changeEvent);
        if (changeEvent.isCancelled()) {
            return;
        }
        String newEntityID = changeEvent.getEntityID();
        String newMob = this.su.getCreatureName(entityID);
        if (this.su.setSpawnerType(block, newEntityID, player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("changingDeniedWorldGuard")))) {
            this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("changedSpawner")).replace("%creature%", newMob));
        }
    }

    private void handleChangeSpawner(Player player, String entityID, ItemStack itemInHand) {
        if (!this.su.hasPermission((Permissible)player, "silkspawners.changetype.", entityID)) {
            this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noPermissionChangingSpawner")));
            return;
        }
        SilkSpawnersSpawnerChangeEvent changeEvent = new SilkSpawnersSpawnerChangeEvent(player, null, entityID, this.su.getStoredSpawnerItemEntityID(itemInHand), itemInHand.getAmount());
        this.plugin.getServer().getPluginManager().callEvent((Event)changeEvent);
        if (changeEvent.isCancelled()) {
            return;
        }
        String newEntityID = changeEvent.getEntityID();
        String newMob = this.su.getCreatureName(entityID);
        ItemStack newItem = this.su.setSpawnerType(itemInHand, newEntityID, this.plugin.localization.getString("spawnerName"));
        this.su.nmsProvider.setSpawnerItemInHand(player, newItem);
        this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("changedSpawner")).replace("%creature%", newMob));
    }

    private void handleChangeEgg(Player player, String entityID, ItemStack itemInHand) {
        if (!this.su.hasPermission((Permissible)player, "silkspawners.changetype.", entityID)) {
            this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noPermissionChangingEgg")));
            return;
        }
        SilkSpawnersSpawnerChangeEvent changeEvent = new SilkSpawnersSpawnerChangeEvent(player, null, entityID, this.su.getStoredSpawnerItemEntityID(itemInHand), itemInHand.getAmount());
        this.plugin.getServer().getPluginManager().callEvent((Event)changeEvent);
        if (changeEvent.isCancelled()) {
            return;
        }
        String newEntityID = changeEvent.getEntityID();
        String newMob = this.su.getCreatureName(entityID);
        ItemStack newItem = this.su.setSpawnerType(itemInHand, newEntityID, this.plugin.localization.getString("spawnerName"));
        this.su.nmsProvider.setSpawnerItemInHand(player, newItem);
        this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("changedEgg")).replace("%creature%", newMob));
    }

    private void handleUnknownArgument(CommandSender sender) {
        this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("unknownArgument")));
    }

    private void handleHelp(CommandSender sender) {
        if (sender.hasPermission("silkspawners.help")) {
            String message = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("help").replace("%version%", this.plugin.getDescription().getVersion()));
            this.su.sendMessage(sender, message);
        } else {
            this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noPermission")));
        }
    }

    private void handleReload(CommandSender sender) {
        if (sender.hasPermission("silkspawners.reload")) {
            this.plugin.reloadConfigs();
            this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("configsReloaded")));
        } else {
            this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noPermission")));
        }
    }

    private void handleList(CommandSender sender) {
        this.su.showAllCreatures(sender);
    }

    private void handleView(CommandSender sender) {
        if (sender instanceof Player) {
            int distance = this.plugin.config.getInt("spawnerCommandReachDistance", 6);
            if (distance == -1) {
                return;
            }
            Player player = (Player)sender;
            Block block = this.su.nmsProvider.getSpawnerFacing(player, distance);
            if (block == null) {
                this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("lookAtSpawner")));
                return;
            }
            String entityID = this.su.getSpawnerEntityID(block);
            if (player.hasPermission("silkspawners.viewtype")) {
                this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("getSpawnerType")).replace("%creature%", this.su.getCreatureName(entityID)));
            } else {
                this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noPermissionViewType")));
            }
        } else {
            this.su.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noConsole")));
        }
    }
}

