/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.silkspawners;

import com.vdurmont.semver4j.Semver;
import de.dustplanet.silkspawners.commands.SilkSpawnersTabCompleter;
import de.dustplanet.silkspawners.commands.SpawnerCommand;
import de.dustplanet.silkspawners.configs.Config;
import de.dustplanet.silkspawners.configs.Localization;
import de.dustplanet.silkspawners.configs.Mobs;
import de.dustplanet.silkspawners.listeners.SilkSpawnersBlockListener;
import de.dustplanet.silkspawners.listeners.SilkSpawnersEntityListener;
import de.dustplanet.silkspawners.listeners.SilkSpawnersInventoryListener;
import de.dustplanet.silkspawners.listeners.SilkSpawnersPlayerListener;
import de.dustplanet.util.CommentedConfiguration;
import de.dustplanet.util.SilkUtil;
import de.dustplanet.util.Updater;
import de.dustplanet.util.stats.bukkit.Metrics;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.UnsafeValues;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SilkSpawners
extends JavaPlugin {
    private SilkUtil su;
    private String nmsVersion;
    private static final int PLUGIN_ID = 35890;
    private static final int BSTATS_PLUGIN_ID = 273;
    private static final String[] COMPATIBLE_MINECRAFT_VERSIONS = new String[]{"v1_8_R3", "v1_11_R1", "v1_12_R1", "v1_13_R2", "v1_14_R1", "v1_15_R1", "v1_16_R1", "v1_16_R2", "v1_16_R3", "v1_17_R1", "v1_18_R1", "v1_18_R2", "v1_19_R1", "v1_19_R2", "v1_19_R3", "v1_20_R1", "v1_20_R2", "v1_20_R3", "v1_20_R4", "v1_21_R1"};
    public static final Map<Integer, String> PROTOCOL_VERSION_PACKAGE_MAP = new HashMap<Integer, String>(){
        private static final long serialVersionUID = -5188779509588704507L;
        {
            this.put(766, "v1_20_R4");
            this.put(767, "v1_21_R1");
        }
    };
    public CommentedConfiguration config;
    public CommentedConfiguration localization;
    public CommentedConfiguration mobs;

    public void onDisable() {
        if (this.su != null) {
            this.su.clearAll();
        }
    }

    public void onEnable() {
        Plugin factionsPlugin;
        this.initializeConfigs();
        String packageName = this.getServer().getClass().getPackage().getName();
        String _nmsVersion = packageName.substring(packageName.lastIndexOf(46) + 1);
        if (_nmsVersion.equals("craftbukkit")) {
            try {
                String minecraftVersion = (String)Server.class.getDeclaredMethod("getMinecraftVersion", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
                String normalizedVersion = minecraftVersion.matches("^\\d+\\.\\d+$") ? minecraftVersion + ".0" : minecraftVersion;
                Semver semver = new Semver(normalizedVersion);
                if (semver.isGreaterThanOrEqualTo("1.20.5")) {
                    int protocolVersion = (Integer)UnsafeValues.class.getDeclaredMethod("getProtocolVersion", new Class[0]).invoke((Object)Bukkit.getUnsafe(), new Object[0]);
                    _nmsVersion = PROTOCOL_VERSION_PACKAGE_MAP.get(protocolVersion);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.setNmsVersion(_nmsVersion);
        if (this.config.getBoolean("testMCVersion", true) && !Arrays.asList(COMPATIBLE_MINECRAFT_VERSIONS).contains(this.getNmsVersion())) {
            this.getLogger().info("This version of the plugin is NOT compatible with your Minecraft version!");
            this.getLogger().info("Please check your versions to make sure they match!");
            this.getLogger().info("Disabling now!");
            this.getLogger().log(Level.INFO, "Compatible versions are: {0}", Arrays.toString(COMPATIBLE_MINECRAFT_VERSIONS));
            this.getLogger().log(Level.INFO, "Your version is: {0}", this.getNmsVersion());
            this.getLogger().info("You can disable this check by setting testMCVersion to false in the config!");
            this.shutdown();
            return;
        }
        this.su = new SilkUtil(this);
        this.loadPermissions();
        this.loadRecipes();
        if (this.config.getBoolean("autoUpdater", true)) {
            if (this.getDescription().getVersion().contains("SNAPSHOT")) {
                this.getLogger().info("AutoUpdater is disabled because you are running a dev build!");
            } else {
                try {
                    new Updater((Plugin)this, 35890, this.getFile(), Updater.UpdateType.DEFAULT, updaterResult -> this.getLogger().log(Level.INFO, "Result from AutoUpdater is: {0}", (Object)updaterResult.getResult()), true);
                    this.getLogger().info("AutoUpdater is enabled and now running.");
                }
                catch (Exception e) {
                    this.getLogger().log(Level.INFO, "Error while auto updating:", e);
                }
            }
        } else {
            this.getLogger().info("AutoUpdater is disabled due to config setting.");
        }
        SpawnerCommand spawnerCommand = new SpawnerCommand(this, this.su);
        SilkSpawnersTabCompleter tabCompleter = new SilkSpawnersTabCompleter(this.su);
        this.getCommand("silkspawners").setExecutor((CommandExecutor)spawnerCommand);
        this.getCommand("silkspawners").setTabCompleter((TabCompleter)tabCompleter);
        SilkSpawnersBlockListener blockListener = new SilkSpawnersBlockListener(this, this.su);
        SilkSpawnersPlayerListener playerListener = new SilkSpawnersPlayerListener(this, this.su);
        SilkSpawnersInventoryListener inventoryListener = new SilkSpawnersInventoryListener(this, this.su);
        SilkSpawnersEntityListener entityListener = new SilkSpawnersEntityListener(this, this.su);
        this.getServer().getPluginManager().registerEvents((Listener)blockListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)playerListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)inventoryListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)entityListener, (Plugin)this);
        new Metrics(this, 273);
        if (this.config.getBoolean("barAPI.enable", false)) {
            Plugin barAPI = this.getServer().getPluginManager().getPlugin("BarAPI");
            if (barAPI != null) {
                this.getLogger().info("Loaded BarAPI successfully!");
                this.su.setBarAPI(true);
            } else {
                this.getLogger().info("BarAPI was not found and remains disabled!");
            }
        } else {
            this.getLogger().info("BarAPI is disabled due to config setting.");
        }
        if (this.config.getBoolean("factionsSupport", false) && (factionsPlugin = this.getServer().getPluginManager().getPlugin("Factions")) == null) {
            this.getLogger().warning("Factions support was enabled, but Factions was not found.");
            this.getLogger().warning("Disabling Factions support in config.yml again");
            this.config.set("factionsSupport", false);
            this.saveConfig();
        }
    }

    private void copy(String yml, File file) {
        try (FileOutputStream out = new FileOutputStream(file);
             InputStream in = this.getResource(yml);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Failed to copy the default config! (I/O)", e);
        }
    }

    private void loadPermissions() {
        this.loadPermissions("craft", "Allows you to craft the specific spawner", PermissionDefault.FALSE);
        this.loadPermissions("place", "Allows you to place the specific spawner", PermissionDefault.FALSE);
        this.loadPermissions("silkdrop", "Allows you to use silk touch to acquire mob spawner items", PermissionDefault.FALSE);
        this.loadPermissions("nosilk", "Allows you to use any tool to acquire mob spawner items", PermissionDefault.FALSE);
        this.loadPermissions("destroydrop", "Allows you to destroy mob spawners to acquire mob spawn eggs / iron bars / XP (as configured)", PermissionDefault.FALSE);
        this.loadPermissions("changetype", "Allows you to change the spawner type using /spawner [creature]", PermissionDefault.FALSE);
        this.loadPermissions("changetypewithegg", "Allows you to change the spawner type by left-clicking with a spawn egg", PermissionDefault.FALSE);
        this.loadPermissions("freeitem", "Allows you to get spawner items in your hand for free using /spawner [creature]", PermissionDefault.FALSE);
        this.loadPermissions("freeitemegg", "Allows you to get spawn eggs in your hand for free using /spawner [creature]egg", PermissionDefault.FALSE);
        this.loadPermissions("list", "Allows you to list the available mobs", PermissionDefault.TRUE);
    }

    private void loadPermissions(String permissionPart, String description, PermissionDefault permDefault) {
        HashMap<String, Boolean> childPermissions = new HashMap<String, Boolean>();
        for (String mobAlias : this.su.getDisplayNameToMobID().keySet()) {
            mobAlias = mobAlias.toLowerCase(Locale.ENGLISH).replace(" ", "");
            childPermissions.put("silkspawners." + permissionPart + "." + mobAlias, true);
        }
        Permission perm = new Permission("silkspawners." + permissionPart + ".*", description, permDefault, childPermissions);
        try {
            this.getServer().getPluginManager().addPermission(perm);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().log(Level.INFO, "Permission {0} is already registered. Skipping...", perm.getName());
        }
    }

    private void initializeConfigs() {
        File mobsFile;
        File localizationFile;
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!(configFile.exists() || this.getDataFolder().exists() || this.getDataFolder().mkdirs())) {
            this.getLogger().severe("The config folder could NOT be created, make sure it's writable!");
            this.getLogger().severe("Disabling now!");
            this.shutdown();
            return;
        }
        if (!configFile.exists()) {
            this.copy("config.yml", configFile);
        }
        if (!(localizationFile = new File(this.getDataFolder(), "localization.yml")).exists()) {
            this.copy("localization.yml", localizationFile);
        }
        if (!(mobsFile = new File(this.getDataFolder(), "mobs.yml")).exists()) {
            this.copy("mobs.yml", mobsFile);
        }
        this.config = new CommentedConfiguration(configFile);
        new Config(this.config).loadConfig();
        this.localization = new CommentedConfiguration(localizationFile);
        new Localization(this.localization).loadConfig();
        this.mobs = new CommentedConfiguration(mobsFile);
        new Mobs(this.mobs).loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void loadRecipes() {
        if (!this.config.getBoolean("craftableSpawners", false)) {
            return;
        }
        this.getLogger().fine("Loading custom recipes");
        legacySpawnEggs = this.su.isLegacySpawnEggs();
        if (legacySpawnEggs) {
            this.loadBaseEggRecipe();
        }
        for (String entityID : this.su.getKnownEntities()) {
            block36: {
                block40: {
                    block35: {
                        block34: {
                            block39: {
                                skip = false;
                                if (!this.mobs.getBoolean("creatures." + entityID + ".enableCraftingSpawner", true)) {
                                    this.getLogger().log(Level.FINE, "Skipping crafting recipe for {0} per config", entityID);
                                    continue;
                                }
                                amount = 1;
                                amount = this.mobs.contains("creatures." + entityID + ".recipe.amount") != false ? this.mobs.getInt("creatures." + entityID + ".recipe.amount", 1) : this.config.getInt("recipeAmount", 1);
                                this.getLogger().log(Level.FINE, "Amount of {0}: {1}", new Object[]{entityID, amount});
                                spawnerItem = this.su.newSpawnerItem(entityID, this.su.getCustomSpawnerName(entityID), amount, true);
                                recipe = null;
                                try {
                                    recipe = new ShapedRecipe(new NamespacedKey((Plugin)this, entityID), spawnerItem);
                                }
                                catch (Error | Exception e) {
                                    recipe = new ShapedRecipe(spawnerItem);
                                }
                                top = this.mobs.contains("creatures." + entityID + ".recipe.top") != false ? this.mobs.getString("creatures." + entityID + ".recipe.top", "AAA") : this.config.getString("recipeTop", "AAA");
                                middle = this.mobs.contains("creatures." + entityID + ".recipe.middle") != false ? this.mobs.getString("creatures." + entityID + ".recipe.middle", "AXA") : this.config.getString("recipeMiddle", "AXA");
                                bottom = this.mobs.contains("creatures." + entityID + ".recipe.bottom") != false ? this.mobs.getString("creatures." + entityID + ".recipe.bottom", "AAA") : this.config.getString("recipeBottom", "AAA");
                                this.getLogger().log(Level.FINE, "Shape of {0}:", entityID);
                                this.getLogger().fine(top);
                                this.getLogger().fine(middle);
                                this.getLogger().fine(bottom);
                                recipe.shape(new String[]{top, middle, bottom});
                                if (!this.mobs.contains("creatures." + entityID + ".recipe.ingredients")) break block39;
                                ingredientsList = this.mobs.getStringList("creatures." + entityID + ".recipe.ingredients");
                                ** GOTO lbl50
                            }
                            if (this.config.contains("ingredients")) break block34;
                            skip = true;
                            try {
                                if (skip) continue;
                                recipeAdded = this.getServer().addRecipe((Recipe)recipe);
                                this.getLogger().log(Level.FINE, "Recipe of {0} added: {1}", new Object[]{entityID, recipeAdded});
                            }
                            catch (IllegalStateException | NullPointerException e) {
                                this.getLogger().log(Level.INFO, "Unable to add recipe of {0}", entityID);
                                this.getLogger().log(Level.INFO, "Error:", e);
                            }
                            continue;
                        }
                        ingredientsList = this.config.getStringList("ingredients");
lbl50:
                        // 2 sources

                        if (ingredientsList != null && !ingredientsList.isEmpty()) break block35;
                        skip = true;
                        try {
                            if (skip) continue;
                            recipeAdded = this.getServer().addRecipe((Recipe)recipe);
                            this.getLogger().log(Level.FINE, "Recipe of {0} added: {1}", new Object[]{entityID, recipeAdded});
                        }
                        catch (IllegalStateException | NullPointerException e) {
                            this.getLogger().log(Level.INFO, "Unable to add recipe of {0}", entityID);
                            this.getLogger().log(Level.INFO, "Error:", e);
                        }
                        continue;
                    }
                    this.getLogger().log(Level.FINE, "Ingredients of {0}:", entityID);
                    this.getLogger().fine(ingredientsList.toString());
                    shape = Arrays.asList(recipe.getShape());
                    if (!this.shapeContainsIngredient(shape, 'X')) ** GOTO lbl90
                    this.getLogger().log(Level.FINE, "shape of {0} contains X", entityID);
                    if (!legacySpawnEggs) break block40;
                    recipe.setIngredient('X', this.su.nmsProvider.getSpawnEggMaterial(), this.su.nmsProvider.getIDForEntity(entityID));
                    ** GOTO lbl90
                }
                material = Material.getMaterial((String)(entityID.toUpperCase() + "_SPAWN_EGG"));
                if (material != null) break block36;
                this.getLogger().log(Level.FINE, "could not find egg material for {0}", entityID);
                skip = true;
                try {
                    if (skip) continue;
                    recipeAdded = this.getServer().addRecipe((Recipe)recipe);
                    this.getLogger().log(Level.FINE, "Recipe of {0} added: {1}", new Object[]{entityID, recipeAdded});
                }
                catch (IllegalStateException | NullPointerException e) {
                    this.getLogger().log(Level.INFO, "Unable to add recipe of {0}", entityID);
                    this.getLogger().log(Level.INFO, "Error:", e);
                }
                continue;
            }
            recipe.setIngredient('X', material);
lbl90:
            // 6 sources

            for (String ingredient : ingredientsList) {
                ingredients = ingredient.split(",");
                if (ingredients.length != 2) {
                    this.getLogger().log(Level.INFO, "ingredient length of {0} invalid: {1}", new Object[]{entityID, ingredients.length});
                    skip = true;
                    continue;
                }
                character = ingredients[0].toUpperCase().charAt(0);
                if (!this.shapeContainsIngredient(shape, character)) {
                    this.getLogger().log(Level.INFO, "shape of {0} does not contain {1}", new Object[]{entityID, Character.valueOf(character)});
                    skip = true;
                    continue;
                }
                material = Material.matchMaterial((String)ingredients[1]);
                if (material == null) {
                    this.getLogger().log(Level.INFO, "shape material {0} of {1} matched null, falling back to IRON_BARS", new Object[]{ingredients[1], entityID});
                    material = this.su.nmsProvider.getIronFenceMaterial();
                }
                recipe.setIngredient(character, material);
            }
            try {
                if (skip) continue;
                recipeAdded = this.getServer().addRecipe((Recipe)recipe);
                this.getLogger().log(Level.FINE, "Recipe of {0} added: {1}", new Object[]{entityID, recipeAdded});
            }
            catch (IllegalStateException | NullPointerException e) {
                this.getLogger().log(Level.INFO, "Unable to add recipe of {0}", entityID);
                this.getLogger().log(Level.INFO, "Error:", e);
            }
            continue;
            catch (IllegalArgumentException e) {
                block37: {
                    block38: {
                        try {
                            this.getLogger().log(Level.WARNING, "Could not add the recipe of {0}!", entityID);
                            this.getLogger().log(Level.WARNING, "Error:", e);
                            recipe.shape(new String[]{"AAA", "ABA", "AAA"});
                            recipe.setIngredient('A', this.su.nmsProvider.getIronFenceMaterial());
                            if (legacySpawnEggs) {
                                recipe.setIngredient('X', this.su.nmsProvider.getSpawnEggMaterial(), 0);
                                break block37;
                            }
                            material = Material.getMaterial((String)(entityID.toUpperCase() + "_SPAWN_EGG"));
                            if (material != null) break block38;
                            this.getLogger().log(Level.INFO, "Could not find egg material for {0}", entityID);
                            skip = true;
                        }
                        catch (Throwable var18_32) {
                            try {
                                if (!skip) {
                                    recipeAdded = this.getServer().addRecipe((Recipe)recipe);
                                    this.getLogger().log(Level.FINE, "Recipe of {0} added: {1}", new Object[]{entityID, recipeAdded});
                                }
                            }
                            catch (IllegalStateException | NullPointerException e) {
                                this.getLogger().log(Level.INFO, "Unable to add recipe of {0}", entityID);
                                this.getLogger().log(Level.INFO, "Error:", e);
                            }
                            throw var18_32;
                        }
                        try {
                            if (skip) continue;
                            recipeAdded = this.getServer().addRecipe((Recipe)recipe);
                            this.getLogger().log(Level.FINE, "Recipe of {0} added: {1}", new Object[]{entityID, recipeAdded});
                        }
                        catch (IllegalStateException | NullPointerException e) {
                            this.getLogger().log(Level.INFO, "Unable to add recipe of {0}", entityID);
                            this.getLogger().log(Level.INFO, "Error:", e);
                        }
                        continue;
                    }
                    recipe.setIngredient('X', material);
                }
                try {
                    if (skip) continue;
                    recipeAdded = this.getServer().addRecipe((Recipe)recipe);
                    this.getLogger().log(Level.FINE, "Recipe of {0} added: {1}", new Object[]{entityID, recipeAdded});
                }
                catch (IllegalStateException | NullPointerException e) {
                    this.getLogger().log(Level.INFO, "Unable to add recipe of {0}", entityID);
                    this.getLogger().log(Level.INFO, "Error:", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBaseEggRecipe() {
        String baseSpawnerEntityID = this.su.getDefaultEntityID();
        int baseSpawnerAmount = this.config.getInt("recipeAmount", 1);
        ItemStack baseSpawnerItem = this.su.newSpawnerItem(baseSpawnerEntityID, "&e&o??? &r&fSpawner", baseSpawnerAmount, false);
        ShapedRecipe baseSpawnerRecipe = null;
        try {
            baseSpawnerRecipe = new ShapedRecipe(new NamespacedKey((Plugin)this, "baseSpawner"), baseSpawnerItem);
        }
        catch (Error | Exception e) {
            baseSpawnerRecipe = new ShapedRecipe(baseSpawnerItem);
        }
        String baseSpawnerTop = this.config.getString("recipeTop", "AAA");
        String baseSpawnerMiddle = this.config.getString("recipeMiddle", "AXA");
        String baseSpawnerBottom = this.config.getString("recipeBottom", "AAA");
        baseSpawnerRecipe.shape(new String[]{baseSpawnerTop, baseSpawnerMiddle, baseSpawnerBottom});
        List baseSpawnerIngredientsList = this.config.getStringList("ingredients");
        if (baseSpawnerIngredientsList != null && !baseSpawnerIngredientsList.isEmpty()) {
            boolean skip = false;
            try {
                List<String> baseSpawnerShape = Arrays.asList(baseSpawnerRecipe.getShape());
                if (this.shapeContainsIngredient(baseSpawnerShape, 'X')) {
                    baseSpawnerRecipe.setIngredient('X', this.su.nmsProvider.getSpawnEggMaterial());
                }
                for (String ingredient : baseSpawnerIngredientsList) {
                    String[] ingredients = ingredient.split(",");
                    if (ingredients.length != 2) {
                        this.getLogger().log(Level.INFO, "ingredient length of default invalid: {0}", ingredients.length);
                        skip = true;
                        continue;
                    }
                    char character = ingredients[0].toUpperCase().charAt(0);
                    if (!this.shapeContainsIngredient(baseSpawnerShape, character)) {
                        this.getLogger().log(Level.INFO, "shape of default does not contain {0}", Character.valueOf(character));
                        skip = true;
                        continue;
                    }
                    Material material = Material.matchMaterial((String)ingredients[1]);
                    if (material == null) {
                        this.getLogger().log(Level.INFO, "shape material {0} of default spawner matched null", ingredients[1]);
                        material = this.su.nmsProvider.getIronFenceMaterial();
                    }
                    baseSpawnerRecipe.setIngredient(character, material);
                }
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(Level.WARNING, "Could not add the default recipe!", e);
                baseSpawnerRecipe.shape(new String[]{"AAA", "ABA", "AAA"});
                baseSpawnerRecipe.setIngredient('A', this.su.nmsProvider.getIronFenceMaterial());
                baseSpawnerRecipe.setIngredient('B', this.su.nmsProvider.getSpawnEggMaterial());
            }
            finally {
                if (!skip) {
                    this.getServer().addRecipe((Recipe)baseSpawnerRecipe);
                }
            }
        }
    }

    private boolean shapeContainsIngredient(List<String> shape, char c) {
        boolean match = false;
        for (String recipePart : shape) {
            for (char recipeIngredient : recipePart.toCharArray()) {
                if (recipeIngredient != c) continue;
                match = true;
                break;
            }
            if (!match) continue;
            break;
        }
        return match;
    }

    public void informPlayer(Player player, String message) {
        if (this.isBlank(message)) {
            return;
        }
        if (player.hasPermission("silkspawners.info")) {
            this.su.sendMessage((CommandSender)player, message);
        }
    }

    public boolean isBlank(CharSequence cs) {
        int strLen;
        int n = strLen = cs == null ? 0 : cs.length();
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void reloadConfigs() {
        this.config.load();
        this.config.save();
        this.loadRecipes();
        this.su.load();
        this.mobs.load();
        this.mobs.save();
        this.localization.load();
        this.localization.save();
    }

    public void shutdown() {
        this.setEnabled(false);
    }

    public void reloadConfig() {
        this.reloadConfigs();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    @Generated
    public String getNmsVersion() {
        return this.nmsVersion;
    }

    @Generated
    public void setNmsVersion(String nmsVersion) {
        this.nmsVersion = nmsVersion;
    }

    @Generated
    public CommentedConfiguration getMobs() {
        return this.mobs;
    }
}

