/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.bridge.silkspawners.spawner;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import de.dustplanet.silkspawners.SilkSpawners;
import de.dustplanet.silkspawners.compat.api.NMSProvider;
import de.dustplanet.util.SilkUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.brcdev.shopgui.bridge.silkspawners.nms.NmsUtils;
import net.brcdev.shopgui.bridge.silkspawners.nms.NmsVersion;
import net.brcdev.shopgui.bridge.silkspawners.spawner.SilkSpawnersProvider;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SilkSpawnersCurrentProvider
implements SilkSpawnersProvider {
    private SilkUtil silkUtil;
    private BiMap<EntityType, String> entityTypesMap;

    @Override
    public void hookIntoSilkSpawners(Plugin silkSpawnersPlugin) {
        this.silkUtil = new SilkUtil((SilkSpawners)silkSpawnersPlugin);
        this.loadEntityTypes();
    }

    public String getName() {
        return "SilkSpawners";
    }

    public ItemStack getSpawnerItem(EntityType entityType) {
        ItemStack itemStack = null;
        String entityTypeName = this.entityTypesMap.containsKey((Object)entityType) ? (String)this.entityTypesMap.get((Object)entityType) : entityType.name().toLowerCase();
        try {
            Method customNameMethod = SilkUtil.class.getMethod("getCustomSpawnerName", String.class);
            String customName = (String)customNameMethod.invoke((Object)this.silkUtil, entityTypeName);
            Method method = SilkUtil.class.getMethod("newSpawnerItem", String.class, String.class, Integer.TYPE, Boolean.TYPE);
            itemStack = (ItemStack)method.invoke((Object)this.silkUtil, entityTypeName, customName, 1, false);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return itemStack;
    }

    public EntityType getSpawnerEntityType(ItemStack itemStack) {
        EntityType entityType = null;
        try {
            Method method = NMSProvider.class.getMethod("getSilkSpawnersNBTEntityID", ItemStack.class);
            String entityTypeName = ((String)method.invoke((Object)this.silkUtil.nmsProvider, itemStack)).toUpperCase();
            if (this.entityTypesMap.containsValue((Object)entityTypeName.toLowerCase())) {
                entityType = (EntityType)this.entityTypesMap.inverse().get((Object)entityTypeName.toLowerCase());
            } else {
                try {
                    entityType = EntityType.valueOf((String)entityTypeName);
                }
                catch (IllegalArgumentException ex) {
                    entityType = this.getEntityTypeFromStringWithoutUnderScores(entityTypeName);
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return entityType;
    }

    private EntityType getEntityTypeFromStringWithoutUnderScores(String entityTypeName) {
        for (EntityType entityType : EntityType.values()) {
            if (!entityType.name().replace("_", "").equalsIgnoreCase(entityTypeName)) continue;
            return entityType;
        }
        return null;
    }

    private void loadEntityTypes() {
        this.entityTypesMap = HashBiMap.create();
        if (NmsUtils.isNmsVersionLowerThan(NmsVersion.v1_16)) {
            this.entityTypesMap.put((Object)EntityType.valueOf((String)"PIG_ZOMBIE"), (Object)"zombie_pigman");
        }
        this.entityTypesMap.put((Object)EntityType.MUSHROOM_COW, (Object)"mooshroom");
        if (NmsUtils.isNmsVersionLowerThan(NmsVersion.v1_11)) {
            this.entityTypesMap.put((Object)EntityType.IRON_GOLEM, (Object)"VillagerGolem");
        } else if (NmsUtils.isNmsVersionLowerThan(NmsVersion.v1_13)) {
            this.entityTypesMap.put((Object)EntityType.IRON_GOLEM, (Object)"villager_golem");
        }
    }
}

