/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.bridge.silkspawners.nms;

import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.brcdev.shopgui.bridge.silkspawners.nms.NmsVersion;
import net.brcdev.shopgui.exception.UnsupportedMinecraftVersionException;
import org.bukkit.Bukkit;
import org.bukkit.Server;

public class NmsUtils {
    private static final Pattern MINECRAFT_SHORT_VERSION_PATTERN = Pattern.compile("(v\\d_\\d+)");
    private static final Pattern NMS_RELEASE_NUMBER_PATTERN = Pattern.compile("R(\\d+)");

    public static boolean isNmsVersionAtLeast(NmsVersion requiredNmsVersion) {
        NmsVersion currentVersion = NmsUtils.readNmsVersion();
        return currentVersion.extractVersionNumber() >= requiredNmsVersion.extractVersionNumber();
    }

    public static boolean isNmsVersionLowerThan(NmsVersion maximalNmsVersion) {
        return !NmsUtils.isNmsVersionAtLeast(maximalNmsVersion);
    }

    private static NmsVersion readNmsVersion() {
        NmsVersion version = null;
        try {
            String minecraftVersion;
            switch (minecraftVersion = NmsUtils.getPaperMinecraftVersion()) {
                case "1.20.6": {
                    version = NmsUtils.parseShortNmsVersion("v1_20");
                    break;
                }
                case "1.21": 
                case "1.21.1": {
                    version = NmsUtils.parseShortNmsVersion("v1_21");
                }
            }
        }
        catch (ReflectiveOperationException e) {
            version = NmsUtils.parseShortNmsVersion(NmsUtils.extractNmsVersion(MINECRAFT_SHORT_VERSION_PATTERN));
        }
        if (version == null) {
            version = NmsUtils.parseShortNmsVersion(NmsUtils.extractNmsVersion(MINECRAFT_SHORT_VERSION_PATTERN));
        }
        return version;
    }

    private static String getPaperMinecraftVersion() throws ReflectiveOperationException {
        Server server = Bukkit.getServer();
        Class<?> serverClass = server.getClass();
        Method method_getMinecraftVersion = serverClass.getMethod("getMinecraftVersion", new Class[0]);
        return (String)method_getMinecraftVersion.invoke((Object)server, new Object[0]);
    }

    private static String extractNmsVersion(Pattern pattern) {
        String nmsClasspath = Bukkit.getServer().getClass().getPackage().getName();
        Matcher matcher = pattern.matcher(nmsClasspath);
        if (matcher.find()) {
            return matcher.group();
        }
        throw new UnsupportedMinecraftVersionException();
    }

    private static NmsVersion parseShortNmsVersion(String version) {
        NmsVersion nmsVersion;
        try {
            nmsVersion = NmsVersion.valueOf(version);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedMinecraftVersionException();
        }
        return nmsVersion;
    }
}

