/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.bridge.silkspawners;

import net.brcdev.shopgui.ShopGuiPlusApi;
import net.brcdev.shopgui.bridge.silkspawners.spawner.SilkSpawnersCurrentProvider;
import net.brcdev.shopgui.bridge.silkspawners.spawner.SilkSpawnersLegacyProvider;
import net.brcdev.shopgui.bridge.silkspawners.spawner.SilkSpawnersProvider;
import net.brcdev.shopgui.exception.api.ExternalSpawnerProviderNameConflictException;
import net.brcdev.shopgui.spawner.external.provider.ExternalSpawnerProvider;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public class ShopGuiBridgeSilkSpawnersPlugin
extends JavaPlugin {
    private SilkSpawnersProvider spawnerProvider;

    public void onEnable() {
        this.hookIntoSilkSpawners();
        this.hookIntoShopGui();
    }

    private void hookIntoSilkSpawners() {
        this.spawnerProvider = this.usingLegacySilkSpawners() ? new SilkSpawnersLegacyProvider() : new SilkSpawnersCurrentProvider();
        this.spawnerProvider.hookIntoSilkSpawners(Bukkit.getPluginManager().getPlugin("SilkSpawners"));
    }

    private void hookIntoShopGui() {
        try {
            ShopGuiPlusApi.registerSpawnerProvider((ExternalSpawnerProvider)this.spawnerProvider);
        }
        catch (ExternalSpawnerProviderNameConflictException e) {
            this.getLogger().warning("Failed to hook into ShopGUI+: " + e.getMessage());
        }
    }

    private boolean usingLegacySilkSpawners() {
        int versionMajorNumber;
        String version = Bukkit.getPluginManager().getPlugin("SilkSpawners").getDescription().getVersion();
        try {
            versionMajorNumber = Integer.parseInt(String.valueOf(version.charAt(0)));
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException ex) {
            return true;
        }
        return versionMajorNumber < 6;
    }
}

