/*
 * Decompiled with CFR 0.152.
 */
package shaded.de.tr7zw.changeme.nbtapi.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.UUID;
import javax.annotation.Nullable;
import shaded.de.tr7zw.changeme.nbtapi.NBTType;
import shaded.de.tr7zw.changeme.nbtapi.iface.ReadWriteNBT;
import shaded.de.tr7zw.changeme.nbtapi.iface.ReadWriteNBTCompoundList;
import shaded.de.tr7zw.changeme.nbtapi.iface.ReadableNBT;
import shaded.de.tr7zw.changeme.nbtapi.iface.ReadableNBTList;

public class GameprofileUtil {
    @Nullable
    public static GameProfile readGameProfile(ReadableNBT readableNBT) {
        String string = null;
        UUID uUID = null;
        if (readableNBT.hasTag("Name") && readableNBT.getType("Name") == NBTType.NBTTagString) {
            string = readableNBT.getString("Name");
        }
        if (readableNBT.hasTag("Id") && readableNBT.getType("Id") == NBTType.NBTTagIntArray && readableNBT.getIntArray("Id").length == 4) {
            uUID = readableNBT.getUUID("Id");
        }
        try {
            GameProfile gameProfile = new GameProfile(uUID, string);
            if (readableNBT.hasTag("Properties") && readableNBT.getType("Properties") == NBTType.NBTTagCompound) {
                ReadableNBT readableNBT2 = readableNBT.getCompound("Properties");
                for (String string2 : readableNBT2.getKeys()) {
                    ReadableNBTList<ReadWriteNBT> readableNBTList = readableNBT2.getCompoundList(string);
                    for (int i = 0; i < readableNBTList.size(); ++i) {
                        ReadableNBT readableNBT3 = readableNBTList.get(i);
                        String string3 = readableNBT3.getString("Value");
                        if (readableNBT3.hasTag("Signature") && readableNBT3.getType("Signature") == NBTType.NBTTagString) {
                            gameProfile.getProperties().put((Object)string2, (Object)new Property(string2, string3, readableNBT3.getString("Signature")));
                            continue;
                        }
                        gameProfile.getProperties().put((Object)string2, (Object)new Property(string2, string3));
                    }
                }
            }
            return gameProfile;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static ReadWriteNBT writeGameProfile(ReadWriteNBT readWriteNBT, GameProfile gameProfile) {
        if (gameProfile.getName() != null && !gameProfile.getName().isEmpty()) {
            readWriteNBT.setString("Name", gameProfile.getName());
        }
        if (gameProfile.getId() != null) {
            readWriteNBT.setUUID("Id", gameProfile.getId());
        }
        if (!gameProfile.getProperties().isEmpty()) {
            ReadWriteNBT readWriteNBT2 = readWriteNBT.getOrCreateCompound("Properties");
            for (String string : gameProfile.getProperties().keySet()) {
                ReadWriteNBTCompoundList readWriteNBTCompoundList = readWriteNBT2.getCompoundList(string);
                for (Property property : gameProfile.getProperties().get((Object)string)) {
                    ReadWriteNBT readWriteNBT3 = readWriteNBTCompoundList.addCompound();
                    readWriteNBT3.setString("Value", property.getValue());
                    if (!property.hasSignature()) continue;
                    readWriteNBT3.setString("Signature", property.getSignature());
                }
            }
        }
        return readWriteNBT;
    }
}

