/*
 * Decompiled with CFR 0.152.
 */
package shaded.de.tr7zw.changeme.nbtapi.utils;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import shaded.de.tr7zw.changeme.nbtapi.NBTCompound;
import shaded.de.tr7zw.changeme.nbtapi.NBTContainer;
import shaded.de.tr7zw.changeme.nbtapi.NBTReflectionUtil;
import shaded.de.tr7zw.changeme.nbtapi.NbtApiException;
import shaded.de.tr7zw.changeme.nbtapi.iface.ReadWriteNBT;
import shaded.de.tr7zw.changeme.nbtapi.utils.MinecraftVersion;
import shaded.de.tr7zw.changeme.nbtapi.utils.nmsmappings.ClassWrapper;
import shaded.de.tr7zw.changeme.nbtapi.utils.nmsmappings.MojangToMapping;
import shaded.de.tr7zw.changeme.nbtapi.utils.nmsmappings.ReflectionMethod;

public class DataFixerUtil {
    public static final int VERSION1_12_2 = 1343;
    public static final int VERSION1_16_5 = 2586;
    public static final int VERSION1_17_1 = 2730;
    public static final int VERSION1_18_2 = 2975;
    public static final int VERSION1_19_2 = 3120;
    public static final int VERSION1_19_4 = 3337;
    public static final int VERSION1_20_1 = 3465;
    public static final int VERSION1_20_2 = 3578;
    public static final int VERSION1_20_4 = 3700;
    public static final int VERSION1_20_5 = 3837;
    public static final int VERSION1_21 = 3953;

    public static Object fixUpRawItemData(Object object, int n, int n2) {
        DataFixer dataFixer = (DataFixer)ReflectionMethod.GET_DATAFIXER.run(null, new Object[0]);
        DSL.TypeReference typeReference = (DSL.TypeReference)ClassWrapper.NMS_REFERENCES.getClazz().getField(MojangToMapping.getMapping().get("net.minecraft.util.datafix.fixes.References#ITEM_STACK")).get(null);
        DynamicOps dynamicOps = (DynamicOps)ClassWrapper.NMS_NBTOPS.getClazz().getField(MojangToMapping.getMapping().get("net.minecraft.nbt.NbtOps#INSTANCE")).get(null);
        Dynamic dynamic = dataFixer.update(typeReference, new Dynamic(dynamicOps, object), n, n2);
        return dynamic.getValue();
    }

    public static ReadWriteNBT fixUpItemData(ReadWriteNBT readWriteNBT, int n, int n2) {
        return new NBTContainer(DataFixerUtil.fixUpRawItemData(NBTReflectionUtil.getToCompount(((NBTCompound)readWriteNBT).getCompound(), (NBTCompound)readWriteNBT), n, n2));
    }

    public static int getCurrentVersion() {
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_21_R1)) {
            return 3953;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R4)) {
            return 3837;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R3)) {
            return 3700;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R1)) {
            return 3465;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_19_R3)) {
            return 3337;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_19_R1)) {
            return 3120;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_18_R1)) {
            return 2975;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_17_R1)) {
            return 2730;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_16_R1)) {
            return 2586;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_12_R1)) {
            return 1343;
        }
        throw new NbtApiException("Trying to update data *to* a version before 1.12.2? Something is probably going wrong, contact the plugin author.");
    }
}

