/*
 * Decompiled with CFR 0.152.
 */
package shaded.de.tr7zw.changeme.nbtapi;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import shaded.de.tr7zw.changeme.nbtapi.NBTCompound;
import shaded.de.tr7zw.changeme.nbtapi.NBTContainer;
import shaded.de.tr7zw.changeme.nbtapi.NBTReflectionUtil;
import shaded.de.tr7zw.changeme.nbtapi.utils.nmsmappings.ObjectCreator;

public class NBTFile
extends NBTCompound {
    private final File file;
    private Object nbt;

    public NBTFile(File file) {
        super(null, null);
        if (file == null) {
            throw new NullPointerException("File can't be null!");
        }
        this.file = file;
        if (file.exists()) {
            this.nbt = NBTReflectionUtil.readNBT(Files.newInputStream(file.toPath(), new OpenOption[0]));
        } else {
            this.nbt = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
            this.save();
        }
    }

    public void save() {
        try {
            this.getWriteLock().lock();
            NBTFile.saveTo(this.file, this);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public Object getCompound() {
        return this.nbt;
    }

    @Override
    protected void setCompound(Object object) {
        this.nbt = object;
    }

    public static NBTCompound readFrom(File file) {
        if (!file.exists()) {
            return new NBTContainer();
        }
        return new NBTContainer(NBTReflectionUtil.readNBT(Files.newInputStream(file.toPath(), new OpenOption[0])));
    }

    public static void saveTo(File file, NBTCompound nBTCompound) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            if (!file.createNewFile()) {
                throw new IOException("Unable to create file at " + file.getAbsolutePath());
            }
        }
        nBTCompound.writeCompound(Files.newOutputStream(file.toPath(), new OpenOption[0]));
    }
}

