/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.util;

import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.core.BInventoryHolder;
import net.brcdev.shopgui.gui.gui.OpenGui;
import net.brcdev.shopgui.player.PlayerData;
import net.brcdev.shopgui.util.ItemUtils;
import net.brcdev.shopgui.util.NmsUtils;
import net.brcdev.shopgui.util.NmsVersion;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class InventoryUtils {
    public static boolean compareInventories(Inventory inventory, Inventory inventory2) {
        return InventoryUtils.compareInventoriesInternal(inventory, inventory2) && InventoryUtils.compareInventoryContents(inventory, inventory2);
    }

    private static boolean compareInventoriesInternal(Inventory inventory, Inventory inventory2) {
        return inventory.getType() == inventory2.getType() && inventory.getHolder() instanceof BInventoryHolder && inventory2.getHolder() instanceof BInventoryHolder && inventory.getHolder().getClass().equals(inventory2.getHolder().getClass()) && StringUtils.equals((String)((BInventoryHolder)inventory.getHolder()).getTitle(), (String)((BInventoryHolder)inventory2.getHolder()).getTitle());
    }

    private static boolean compareInventoryContents(Inventory inventory, Inventory inventory2) {
        ItemStack[] itemStackArray;
        ItemStack[] itemStackArray2 = inventory.getContents();
        if (itemStackArray2.length != (itemStackArray = inventory2.getContents()).length) {
            return false;
        }
        for (int i = 0; i < itemStackArray2.length; ++i) {
            if (itemStackArray2[i] == null && itemStackArray[i] == null || !(itemStackArray2[i] == null && itemStackArray[i] != null || itemStackArray2[i] != null && itemStackArray[i] == null) && itemStackArray2[i].isSimilar(itemStackArray[i])) continue;
            return false;
        }
        return true;
    }

    public static void openInventory(Player player, PlayerData playerData, Inventory inventory, OpenGui openGui) {
        playerData.setSwitchingGui(true);
        InventoryUtils.runTaskSynchronously(() -> {
            player.openInventory(inventory);
            InventoryUtils.runTaskSynchronously(() -> {
                if (player.getOpenInventory().getTopInventory() != null && InventoryUtils.compareInventories(inventory, player.getOpenInventory().getTopInventory())) {
                    openGui.setOpenInventory(inventory);
                    playerData.setSwitchingGui(false);
                    playerData.setOpenGui(openGui);
                } else {
                    playerData.resetOpenGui();
                    player.closeInventory();
                    InventoryUtils.updateInventory(player, playerData);
                }
            });
        });
    }

    public static void updateInventory(Player player, PlayerData playerData) {
        InventoryUtils.runTaskSynchronously(() -> {
            if (!playerData.hasOpenGui()) {
                player.updateInventory();
            }
        });
    }

    private static void runTaskSynchronously(Runnable runnable) {
        Bukkit.getScheduler().runTaskLater((Plugin)ShopGuiPlugin.getInstance(), runnable, 1L);
    }

    public static boolean canPlayerCarryItem(Player player, ItemStack itemStack, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        int n2 = itemStack.getAmount();
        for (int i = 0; i < 36; ++i) {
            if (n2 <= 0) {
                return true;
            }
            ItemStack itemStack2 = player.getInventory().getItem(i);
            if (itemStack2 == null || itemStack2.getType() == Material.AIR) {
                n2 -= n;
                continue;
            }
            if (!ItemUtils.compareItemStacks(itemStack2, itemStack, bl, bl2, bl3, bl4)) continue;
            n2 -= Math.max(0, n - itemStack2.getAmount());
        }
        return n2 <= 0;
    }

    public static int getPlayersItemAmount(Player player, ItemStack itemStack, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        int n = 0;
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            ItemStack itemStack2;
            if (bl5 && i >= 36 && i <= 39 || bl6 && i == 40 || !ItemUtils.compareItemStacks(itemStack2 = player.getInventory().getItem(i), itemStack, bl, bl2, bl3, bl4)) continue;
            n += itemStack2.getAmount();
        }
        return n;
    }

    public static int getPlayersItemAmountInHand(Player player, ItemStack itemStack, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ItemStack itemStack2 = InventoryUtils.getItemInPlayersMainHand(player);
        if (!ItemUtils.compareItemStacks(itemStack2, itemStack, bl, bl2, bl3, bl4)) {
            return 0;
        }
        return itemStack2.getAmount();
    }

    public static void removeItemFromPlayer(Player player, ItemStack itemStack, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n2 = n;
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            ItemStack itemStack2 = player.getInventory().getItem(i);
            if (!ItemUtils.compareItemStacks(itemStack2, itemStack, bl, bl2, bl3, bl4)) continue;
            if (n2 >= itemStack2.getAmount()) {
                player.getInventory().clear(i);
                n2 -= itemStack2.getAmount();
                continue;
            }
            if (n2 <= 0) break;
            itemStack2.setAmount(itemStack2.getAmount() - n2);
            n2 = 0;
        }
        player.updateInventory();
    }

    public static void removeItemFromPlayersHand(Player player, ItemStack itemStack, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ItemStack itemStack2 = InventoryUtils.getItemInPlayersMainHand(player);
        if (!ItemUtils.compareItemStacks(itemStack2, itemStack, bl, bl2, bl3, bl4)) {
            return;
        }
        if (n >= itemStack2.getAmount()) {
            InventoryUtils.setItemInPlayersMainHand(player, null);
        } else {
            itemStack2.setAmount(itemStack2.getAmount() - n);
            InventoryUtils.setItemInPlayersMainHand(player, itemStack2);
        }
        player.updateInventory();
    }

    public static void addItemToInventory(Player player, ItemStack itemStack, int n) {
        int n2 = itemStack.getAmount();
        ItemStack itemStack2 = itemStack.clone();
        itemStack2.setAmount(n);
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            int n3;
            if (n2 < 1) {
                return;
            }
            ItemStack itemStack3 = player.getInventory().getItem(i);
            if (itemStack3 == null || itemStack3.getType() == Material.AIR) {
                if (n2 >= n) {
                    player.getInventory().setItem(i, itemStack2.clone());
                    n2 -= n;
                    continue;
                }
                itemStack2.setAmount(n2);
                player.getInventory().setItem(i, itemStack2.clone());
                return;
            }
            if (!ItemUtils.compareItemStacks(itemStack3, itemStack, true, true, true, true) || (n3 = Math.min(Math.max(0, n - itemStack3.getAmount()), n2)) <= 0) continue;
            ItemStack itemStack4 = itemStack3.clone();
            itemStack4.setAmount(itemStack4.getAmount() + n3);
            player.getInventory().setItem(i, itemStack4);
            n2 -= n3;
        }
        player.updateInventory();
    }

    public static int countEmptyInventorySlots(Player player) {
        int n = 0;
        for (int i = 0; i <= 35; ++i) {
            if (player.getInventory().getItem(i) != null && player.getInventory().getItem(i).getType() != Material.AIR) continue;
            ++n;
        }
        return n;
    }

    public static ItemStack getItemInPlayersMainHand(Player player) {
        return NmsUtils.isNmsVersionLowerThan(NmsVersion.v1_9) ? player.getItemInHand() : player.getInventory().getItemInMainHand();
    }

    public static void setItemInPlayersMainHand(Player player, ItemStack itemStack) {
        if (NmsUtils.isNmsVersionLowerThan(NmsVersion.v1_9)) {
            player.setItemInHand(itemStack);
        } else {
            player.getInventory().setItemInMainHand(itemStack);
        }
    }
}

