/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.util;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Color;

public class ColorUtils {
    private static final Map<String, Color> COLOR_NAMES = new HashMap<String, Color>();

    @Nullable
    public static Color getColor(String string) {
        String[] stringArray;
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        Color color = ColorUtils.parseColorName(string);
        if (color == null && (stringArray = string.split(",")).length == 3) {
            try {
                color = Color.fromRGB((int)Integer.parseInt(stringArray[0]), (int)Integer.parseInt(stringArray[1]), (int)Integer.parseInt(stringArray[2]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return color;
    }

    @Nullable
    private static Color parseColorName(String string) {
        return COLOR_NAMES.get(string);
    }

    static {
        COLOR_NAMES.put("WHITE", Color.WHITE);
        COLOR_NAMES.put("SILVER", Color.SILVER);
        COLOR_NAMES.put("GRAY", Color.GRAY);
        COLOR_NAMES.put("BLACK", Color.BLACK);
        COLOR_NAMES.put("RED", Color.RED);
        COLOR_NAMES.put("MAROON", Color.MAROON);
        COLOR_NAMES.put("YELLOW", Color.YELLOW);
        COLOR_NAMES.put("OLIVE", Color.OLIVE);
        COLOR_NAMES.put("LIME", Color.LIME);
        COLOR_NAMES.put("GREEN", Color.GREEN);
        COLOR_NAMES.put("AQUA", Color.AQUA);
        COLOR_NAMES.put("TEAL", Color.TEAL);
        COLOR_NAMES.put("BLUE", Color.BLUE);
        COLOR_NAMES.put("NAVY", Color.NAVY);
        COLOR_NAMES.put("FUCHSIA", Color.FUCHSIA);
        COLOR_NAMES.put("PURPLE", Color.PURPLE);
        COLOR_NAMES.put("ORANGE", Color.ORANGE);
    }
}

