/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.spawner.internal.provider;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.brcdev.shopgui.exception.item.spawner.InvalidSpawnerEntityTypeException;
import net.brcdev.shopgui.spawner.internal.provider.InternalSpawnerProvider;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class InternalSpawnerProviderPreV1_8
implements InternalSpawnerProvider {
    private static final BiMap<String, Short> ENTITY_TYPE_IDS = HashBiMap.create((int)32);

    private static void loadEntityTypeIds() {
        ENTITY_TYPE_IDS.put((Object)"BAT", (Object)65);
        ENTITY_TYPE_IDS.put((Object)"BLAZE", (Object)61);
        ENTITY_TYPE_IDS.put((Object)"CAVE_SPIDER", (Object)59);
        ENTITY_TYPE_IDS.put((Object)"CHICKEN", (Object)93);
        ENTITY_TYPE_IDS.put((Object)"COW", (Object)92);
        ENTITY_TYPE_IDS.put((Object)"CREEPER", (Object)50);
        ENTITY_TYPE_IDS.put((Object)"ENDER_DRAGON", (Object)63);
        ENTITY_TYPE_IDS.put((Object)"ENDERMAN", (Object)58);
        ENTITY_TYPE_IDS.put((Object)"GHAST", (Object)56);
        ENTITY_TYPE_IDS.put((Object)"GIANT", (Object)53);
        ENTITY_TYPE_IDS.put((Object)"HORSE", (Object)100);
        ENTITY_TYPE_IDS.put((Object)"IRON_GOLEM", (Object)99);
        ENTITY_TYPE_IDS.put((Object)"MAGMA_CUBE", (Object)62);
        ENTITY_TYPE_IDS.put((Object)"MUSHROOM_COW", (Object)96);
        ENTITY_TYPE_IDS.put((Object)"OCELOT", (Object)98);
        ENTITY_TYPE_IDS.put((Object)"PIG", (Object)90);
        ENTITY_TYPE_IDS.put((Object)"PIG_ZOMBIE", (Object)57);
        ENTITY_TYPE_IDS.put((Object)"SHEEP", (Object)91);
        ENTITY_TYPE_IDS.put((Object)"SILVERFISH", (Object)60);
        ENTITY_TYPE_IDS.put((Object)"SKELETON", (Object)51);
        ENTITY_TYPE_IDS.put((Object)"SLIME", (Object)55);
        ENTITY_TYPE_IDS.put((Object)"SNOWMAN", (Object)97);
        ENTITY_TYPE_IDS.put((Object)"SPIDER", (Object)52);
        ENTITY_TYPE_IDS.put((Object)"SQUID", (Object)94);
        ENTITY_TYPE_IDS.put((Object)"VILLAGER", (Object)120);
        ENTITY_TYPE_IDS.put((Object)"WITCH", (Object)66);
        ENTITY_TYPE_IDS.put((Object)"WITHER", (Object)64);
        ENTITY_TYPE_IDS.put((Object)"WOLF", (Object)95);
        ENTITY_TYPE_IDS.put((Object)"ZOMBIE", (Object)54);
    }

    @Override
    public ItemStack getSpawnerItem(EntityType entityType) {
        if (!ENTITY_TYPE_IDS.containsKey((Object)entityType.name())) {
            throw new InvalidSpawnerEntityTypeException();
        }
        short s = (Short)ENTITY_TYPE_IDS.get((Object)entityType.name());
        return new ItemStack(this.getSpawnerMaterial(), 1, s);
    }

    @Override
    public EntityType getEntityType(ItemStack itemStack) {
        if (itemStack.getType() != this.getSpawnerMaterial() || !ENTITY_TYPE_IDS.containsValue((Object)itemStack.getDurability())) {
            return EntityType.UNKNOWN;
        }
        return EntityType.valueOf((String)((String)ENTITY_TYPE_IDS.inverse().get((Object)itemStack.getDurability())));
    }

    @Override
    public Material getSpawnerMaterial() {
        return Material.getMaterial((String)"MOB_SPAWNER");
    }

    static {
        InternalSpawnerProviderPreV1_8.loadEntityTypeIds();
    }
}

