/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.spawner.internal;

import me.coley.recaf.metadata.InsnComment;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.spawner.internal.provider.InternalSpawnerProvider;
import net.brcdev.shopgui.spawner.internal.provider.InternalSpawnerProviderPostV1_8;
import net.brcdev.shopgui.spawner.internal.provider.InternalSpawnerProviderPreV1_8;
import net.brcdev.shopgui.util.NmsUtils;
import net.brcdev.shopgui.util.NmsVersion;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class InternalSpawnerHandler
implements Listener {
    private InternalSpawnerProvider internalSpawnerProvider;

    public InternalSpawnerHandler(ShopGuiPlugin shopGuiPlugin) {
        this.initSpawnerInternalHandler();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)shopGuiPlugin);
    }

    private void initSpawnerInternalHandler() {
        this.internalSpawnerProvider = NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_8) ? new InternalSpawnerProviderPostV1_8() : new InternalSpawnerProviderPreV1_8();
    }

    public ItemStack getSpawnerItem(EntityType entityType) {
        ItemStack itemStack = this.internalSpawnerProvider.getSpawnerItem(entityType);
        itemStack = this.setSpawnerItemStackName(itemStack, entityType);
        return itemStack;
    }

    public EntityType getEntityType(ItemStack itemStack) {
        return this.internalSpawnerProvider.getEntityType(itemStack);
    }

    @InsnComment(At_0="cWN3kTN2Z0MZFEdP12axZ3cntWU3lkaOp3ZE5EMRRlT5tGWUh0aDVEeQV3RhNEZ21mTVtUN")
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent blockPlaceEvent) {
        ItemStack itemStack = blockPlaceEvent.getItemInHand();
        if (itemStack == null) {
            return;
        }
        EntityType entityType = this.getEntityType(itemStack);
        if (entityType == null || entityType == EntityType.UNKNOWN) {
            return;
        }
        Block block = blockPlaceEvent.getBlock();
        BlockState blockState = block.getState();
        CreatureSpawner creatureSpawner = (CreatureSpawner)blockState;
        creatureSpawner.setSpawnedType(entityType);
        blockState.update();
    }

    private ItemStack setSpawnerItemStackName(ItemStack itemStack, EntityType entityType) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(WordUtils.capitalizeFully((String)entityType.name().replace("_", " ")) + " Spawner");
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }
}

