/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.spawner;

import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.spawner.external.ExternalSpawnerHandler;
import net.brcdev.shopgui.spawner.external.provider.ExternalSpawnerProvider;
import net.brcdev.shopgui.spawner.internal.InternalSpawnerHandler;
import net.brcdev.shopgui.util.Constants;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.PluginManager;

public class SpawnerManager {
    private ShopGuiPlugin main;
    private InternalSpawnerHandler internalHandler;
    private ExternalSpawnerHandler externalHandler;

    public SpawnerManager(ShopGuiPlugin shopGuiPlugin) {
        this.main = shopGuiPlugin;
        this.externalHandler = new ExternalSpawnerHandler(shopGuiPlugin);
    }

    public void setup() {
        this.printMineableSpawnersBridgeInfo();
        this.printSilkSpawnersBridgeInfo();
        this.externalHandler.setupMainProvider();
        if (!this.externalHandler.isProviderSetup()) {
            this.internalHandler = new InternalSpawnerHandler(this.main);
        }
    }

    public ItemStack getSpawnerItem(EntityType entityType) {
        if (this.externalHandler.isProviderSetup()) {
            return this.externalHandler.getProvider().getSpawnerItem(entityType);
        }
        return this.internalHandler.getSpawnerItem(entityType);
    }

    public EntityType getEntityType(ItemStack itemStack) {
        if (this.externalHandler.isProviderSetup()) {
            return this.externalHandler.getProvider().getSpawnerEntityType(itemStack);
        }
        return this.internalHandler.getEntityType(itemStack);
    }

    public void registerExternalSpawnerProvider(ExternalSpawnerProvider externalSpawnerProvider) {
        this.externalHandler.registerExternalSpawnerProvider(externalSpawnerProvider);
    }

    private void printMineableSpawnersBridgeInfo() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (pluginManager.getPlugin(Constants.PLUGIN_MINEABLESPAWNERS) == null || pluginManager.getPlugin(Constants.PLUGIN_MINEABLESPAWNERS_BRIDGE) != null) {
            return;
        }
        this.main.warning("Found " + Constants.PLUGIN_MINEABLESPAWNERS + " but not hooked into it. You need to download an additional addon: " + Constants.URL_MINEABLESPAWNERS_BRIDGE);
    }

    private void printSilkSpawnersBridgeInfo() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (pluginManager.getPlugin(Constants.PLUGIN_SILKSPAWNERS) == null || pluginManager.getPlugin(Constants.PLUGIN_SILKSPAWNERS_BRIDGE) != null) {
            return;
        }
        this.main.warning("Found " + Constants.PLUGIN_SILKSPAWNERS + " but not hooked into it. You need to download an additional addon: " + Constants.URL_SILKSPAWNERS_BRIDGE);
    }
}

