/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.sound;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.sound.SoundAction;
import net.brcdev.shopgui.util.NmsUtils;
import net.brcdev.shopgui.util.NmsVersion;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class SoundManager {
    private ShopGuiPlugin main;
    private Map<SoundAction, String> sounds;
    private Map<SoundAction, Sound> legacySounds;

    public SoundManager(ShopGuiPlugin shopGuiPlugin) {
        this.main = shopGuiPlugin;
        this.sounds = new HashMap<SoundAction, String>();
        this.legacySounds = new HashMap<SoundAction, Sound>();
    }

    public void loadSounds() {
        this.sounds.clear();
        this.legacySounds.clear();
        ConfigurationSection configurationSection = this.main.getConfigMain().getConfig().getConfigurationSection("sounds");
        if (configurationSection == null) {
            ShopGuiPlugin.getInstance().warning("Error occurred when loading sounds (config.yml), no sounds loaded");
            return;
        }
        Arrays.asList(SoundAction.values()).forEach(soundAction -> this.loadSound(configurationSection, (SoundAction)((Object)soundAction)));
        this.main.info("Loaded " + (this.sounds.size() + this.legacySounds.size()) + " sounds.");
    }

    private void loadSound(ConfigurationSection configurationSection, SoundAction soundAction) {
        if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_17)) {
            String string = configurationSection.getString(soundAction.name());
            if (string == null || string.isEmpty()) {
                return;
            }
            if (!string.contains(":")) {
                try {
                    Sound sound = Sound.valueOf((String)string.toUpperCase());
                    string = sound.getKey().getKey();
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    return;
                }
            }
            this.sounds.put(soundAction, string);
        } else {
            Sound sound = null;
            try {
                sound = Sound.valueOf((String)configurationSection.getString(soundAction.name()));
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                ShopGuiPlugin.getInstance().warning("Error occurred when loading sounds > " + soundAction.name() + " (config.yml), default sound loaded: " + runtimeException.getMessage());
            }
            this.legacySounds.put(soundAction, sound);
        }
    }

    public void playSound(Player player, SoundAction soundAction) {
        if (this.legacySounds.containsKey((Object)soundAction)) {
            Sound sound = this.legacySounds.get((Object)soundAction);
            player.playSound(player.getLocation(), sound, 0.2f, 1.0f);
        } else if (this.sounds.containsKey((Object)soundAction)) {
            String string = this.sounds.get((Object)soundAction);
            player.playSound(player.getLocation(), string, 0.2f, 1.0f);
        }
    }
}

