/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.shop.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.exception.player.PlayerDataNotLoadedException;
import net.brcdev.shopgui.gui.element.special.GuiSpecialElement;
import net.brcdev.shopgui.modifier.PriceModifierActionType;
import net.brcdev.shopgui.player.PlayerData;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.item.ShopItemPermission;
import net.brcdev.shopgui.shop.item.ShopItemType;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ShopItem {
    private Shop shop;
    private String id;
    private ShopItemType type;
    private ItemStack item;
    private ItemStack placeholder;
    private int page;
    private int slot;
    private int enchantmentLevel;
    private double buyPrice;
    private double sellPrice;
    private int originalStackSize;
    private List<ShopItemPermission> permissions;
    private Enchantment enchantment;
    private List<String> commands;
    private GuiSpecialElement specialElement;
    private boolean runCommandsAsBuyer;
    private boolean runSingleCommand;
    private boolean closeGuiOnClick;
    private int commandsLimit;
    private boolean requireInventorySpace;
    private boolean unstack;
    private boolean stacked;
    private boolean stripMeta;
    private boolean compareMeta;
    private boolean compareModel;
    private boolean compareDamage;
    private boolean compareNbt;
    private int itemStackSizeCappedAt;
    private boolean force;
    private String messageBuy;
    private String messageSell;
    private String messageSellAll;
    private int enchantmentStackSizeLimit;
    private String shopLinkShopId;
    private List<String> requiredPermissions;
    private List<String> commandsOnClick;
    private List<String> commandsOnBuy;
    private List<String> commandsOnSell;
    private List<String> commandsOnClickConsole;
    private List<String> commandsOnBuyConsole;
    private List<String> commandsOnSellConsole;

    public ShopItem(Shop shop, String string, ShopItemType shopItemType) {
        this.shop = shop;
        this.id = string;
        this.type = shopItemType;
        this.messageBuy = "";
        this.messageSell = "";
        this.messageSellAll = "";
        this.commandsOnClick = new ArrayList<String>();
        this.commandsOnBuy = new ArrayList<String>();
        this.commandsOnSell = new ArrayList<String>();
        this.commandsOnClickConsole = new ArrayList<String>();
        this.commandsOnBuyConsole = new ArrayList<String>();
        this.commandsOnSellConsole = new ArrayList<String>();
    }

    public ShopItem(Shop shop, String string, ShopItemType shopItemType, ItemStack itemStack) {
        this.shop = shop;
        this.id = string;
        this.type = shopItemType;
        this.item = itemStack;
        this.messageBuy = "";
        this.messageSell = "";
        this.messageSellAll = "";
        this.commandsOnClick = new ArrayList<String>();
        this.commandsOnBuy = new ArrayList<String>();
        this.commandsOnSell = new ArrayList<String>();
        this.commandsOnClickConsole = new ArrayList<String>();
        this.commandsOnBuyConsole = new ArrayList<String>();
        this.commandsOnSellConsole = new ArrayList<String>();
    }

    public ShopItem(Shop shop, String string, ShopItemType shopItemType, ItemStack itemStack, boolean bl, boolean bl2, int n, double d, double d2, int n2) {
        this.shop = shop;
        this.id = string;
        this.type = shopItemType;
        this.item = itemStack;
        this.unstack = bl;
        this.stacked = bl2;
        this.page = n;
        this.buyPrice = d;
        this.sellPrice = d2;
        this.originalStackSize = n2;
        this.messageBuy = "";
        this.messageSell = "";
        this.messageSellAll = "";
        this.commandsOnClick = new ArrayList<String>();
        this.commandsOnBuy = new ArrayList<String>();
        this.commandsOnSell = new ArrayList<String>();
        this.commandsOnClickConsole = new ArrayList<String>();
        this.commandsOnBuyConsole = new ArrayList<String>();
        this.commandsOnSellConsole = new ArrayList<String>();
    }

    public ShopItem(Shop shop, String string, ShopItemType shopItemType, ItemStack itemStack, boolean bl, boolean bl2, int n, int n2, double d, double d2, int n3) {
        this(shop, string, shopItemType, itemStack, bl, bl2, n, d, d2, n3);
        this.slot = n2;
    }

    public ShopItem(ShopItem shopItem) {
        this.shop = shopItem.shop;
        this.id = shopItem.id;
        this.type = shopItem.type;
        this.item = shopItem.item;
        this.placeholder = shopItem.placeholder;
        this.page = shopItem.page;
        this.slot = shopItem.slot;
        this.enchantmentLevel = shopItem.enchantmentLevel;
        this.buyPrice = shopItem.buyPrice;
        this.sellPrice = shopItem.sellPrice;
        this.originalStackSize = shopItem.originalStackSize;
        this.permissions = shopItem.permissions;
        this.enchantment = shopItem.enchantment;
        this.commands = shopItem.commands;
        this.specialElement = shopItem.specialElement;
        this.runCommandsAsBuyer = shopItem.runCommandsAsBuyer;
        this.runSingleCommand = shopItem.runSingleCommand;
        this.closeGuiOnClick = shopItem.closeGuiOnClick;
        this.commandsLimit = shopItem.commandsLimit;
        this.requireInventorySpace = shopItem.requireInventorySpace;
        this.unstack = shopItem.unstack;
        this.stacked = shopItem.stacked;
        this.stripMeta = shopItem.stripMeta;
        this.compareMeta = shopItem.compareMeta;
        this.compareModel = shopItem.compareModel;
        this.compareDamage = shopItem.compareDamage;
        this.compareNbt = shopItem.compareNbt;
        this.itemStackSizeCappedAt = shopItem.itemStackSizeCappedAt;
        this.force = shopItem.force;
        this.messageBuy = shopItem.messageBuy;
        this.messageSell = shopItem.messageSell;
        this.messageSellAll = shopItem.messageSellAll;
        this.enchantmentStackSizeLimit = shopItem.enchantmentStackSizeLimit;
        this.shopLinkShopId = shopItem.shopLinkShopId;
        this.requiredPermissions = shopItem.requiredPermissions;
        this.commandsOnClick = shopItem.commandsOnClick;
        this.commandsOnBuy = shopItem.commandsOnBuy;
        this.commandsOnSell = shopItem.commandsOnSell;
        this.commandsOnClickConsole = shopItem.commandsOnClickConsole;
        this.commandsOnBuyConsole = shopItem.commandsOnBuyConsole;
        this.commandsOnSellConsole = shopItem.commandsOnSellConsole;
    }

    public Shop getShop() {
        return this.shop;
    }

    public void setShop(Shop shop) {
        this.shop = shop;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack itemStack) {
        this.item = itemStack;
    }

    public ItemStack getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(ItemStack itemStack) {
        this.placeholder = itemStack;
    }

    public ShopItemType getType() {
        return this.type;
    }

    public void setType(ShopItemType shopItemType) {
        this.type = shopItemType;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int n) {
        this.page = n;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int n) {
        this.slot = n;
    }

    public double getBuyPrice() {
        return this.buyPrice;
    }

    public void setBuyPrice(double d) {
        this.buyPrice = d;
    }

    @Deprecated
    public double getBuyPrice(Player player, PlayerData playerData) {
        return this.getBuyPrice(player);
    }

    public double getBuyPrice(Player player) {
        double d = 1.0;
        try {
            d = ShopGuiPlugin.getInstance().getPriceModifierManager().getPriceModifier((OfflinePlayer)player, this, PriceModifierActionType.BUY).getModifier();
        }
        catch (PlayerDataNotLoadedException playerDataNotLoadedException) {
            // empty catch block
        }
        return this.buyPrice * d;
    }

    public double getSellPrice() {
        return this.sellPrice;
    }

    public void setSellPrice(double d) {
        this.sellPrice = d;
    }

    @Deprecated
    public double getSellPrice(Player player, PlayerData playerData) {
        return this.getSellPrice(player);
    }

    public double getSellPrice(Player player) {
        double d = 1.0;
        try {
            d = ShopGuiPlugin.getInstance().getPriceModifierManager().getPriceModifier((OfflinePlayer)player, this, PriceModifierActionType.SELL).getModifier();
        }
        catch (PlayerDataNotLoadedException playerDataNotLoadedException) {
            // empty catch block
        }
        return this.sellPrice * d;
    }

    public int getOriginalStackSize() {
        return this.originalStackSize;
    }

    public void setOriginalStackSize(int n) {
        this.originalStackSize = n;
    }

    public List<ShopItemPermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<ShopItemPermission> list) {
        this.permissions = list;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public void setEnchantment(Enchantment enchantment) {
        this.enchantment = enchantment;
    }

    public int getEnchantmentLevel() {
        return this.enchantmentLevel;
    }

    public void setEnchantmentLevel(int n) {
        this.enchantmentLevel = n;
    }

    public double getBuyPriceForAmount(int n) {
        return Settings.parsePrice(this.buyPrice / (double)this.placeholder.getAmount() * (double)n);
    }

    @Deprecated
    public double getBuyPriceForAmount(Player player, PlayerData playerData, int n) {
        return Settings.parsePrice(this.getBuyPrice(player, playerData) / (double)this.placeholder.getAmount() * (double)n);
    }

    public double getBuyPriceForAmount(Player player, int n) {
        return Settings.parsePrice(this.getBuyPrice(player) / (double)this.placeholder.getAmount() * (double)n);
    }

    public double getSellPriceForAmount(int n) {
        return Settings.parsePrice(this.sellPrice / (double)this.placeholder.getAmount() * (double)n);
    }

    @Deprecated
    public double getSellPriceForAmount(Player player, PlayerData playerData, int n) {
        return Settings.parsePrice(this.getSellPrice(player, playerData) / (double)this.placeholder.getAmount() * (double)n);
    }

    public double getSellPriceForAmount(Player player, int n) {
        return Settings.parsePrice(this.getSellPrice(player) / (double)this.placeholder.getAmount() * (double)n);
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> list) {
        this.commands = list;
    }

    public GuiSpecialElement getSpecialElement() {
        return this.specialElement;
    }

    public void setSpecialElement(GuiSpecialElement guiSpecialElement) {
        this.specialElement = guiSpecialElement;
    }

    public boolean isRunCommandsAsBuyer() {
        return this.runCommandsAsBuyer;
    }

    public void setRunCommandsAsBuyer(boolean bl) {
        this.runCommandsAsBuyer = bl;
    }

    public boolean isRunSingleCommand() {
        return this.runSingleCommand;
    }

    public void setRunSingleCommand(boolean bl) {
        this.runSingleCommand = bl;
    }

    public boolean isCloseGuiOnClick() {
        return this.closeGuiOnClick;
    }

    public void setCloseGuiOnClick(boolean bl) {
        this.closeGuiOnClick = bl;
    }

    public int getCommandsLimit() {
        return this.commandsLimit;
    }

    public boolean isRequireInventorySpace() {
        return this.requireInventorySpace;
    }

    public void setCommandsLimit(int n) {
        this.commandsLimit = n;
    }

    public void setRequireInventorySpace(boolean bl) {
        this.requireInventorySpace = bl;
    }

    public boolean isUnstack() {
        return this.unstack;
    }

    public void setUnstack(boolean bl) {
        this.unstack = bl;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean bl) {
        this.stacked = bl;
    }

    public boolean isStripMeta() {
        return this.stripMeta;
    }

    public void setStripMeta(boolean bl) {
        this.stripMeta = bl;
    }

    public boolean isCompareMeta() {
        return this.compareMeta;
    }

    public void setCompareMeta(boolean bl) {
        this.compareMeta = bl;
    }

    public boolean isCompareModel() {
        return this.compareModel;
    }

    public void setCompareModel(boolean bl) {
        this.compareModel = bl;
    }

    public boolean isCompareDamage() {
        return this.compareDamage;
    }

    public void setCompareDamage(boolean bl) {
        this.compareDamage = bl;
    }

    public boolean isCompareNbt() {
        return this.compareNbt;
    }

    public void setCompareNbt(boolean bl) {
        this.compareNbt = bl;
    }

    public boolean isItemStackSizeCapped() {
        return this.itemStackSizeCappedAt > 0;
    }

    public int getItemStackSizeCappedAt() {
        return this.itemStackSizeCappedAt;
    }

    public void setItemStackSizeCappedAt(int n) {
        this.itemStackSizeCappedAt = n;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public String getMessageBuy() {
        return this.messageBuy;
    }

    public void setMessageBuy(String string) {
        this.messageBuy = string;
    }

    public String getMessageSell() {
        return this.messageSell;
    }

    public void setMessageSell(String string) {
        this.messageSell = string;
    }

    public String getMessageSellAll() {
        return this.messageSellAll;
    }

    public void setMessageSellAll(String string) {
        this.messageSellAll = string;
    }

    public int getEnchantmentStackSizeLimit() {
        return this.enchantmentStackSizeLimit;
    }

    public void setEnchantmentStackSizeLimit(int n) {
        this.enchantmentStackSizeLimit = n;
    }

    public String getShopLinkShopId() {
        return this.shopLinkShopId;
    }

    public void setShopLinkShopId(String string) {
        this.shopLinkShopId = string;
    }

    public List<String> getRequiredPermissions() {
        return this.requiredPermissions;
    }

    public void setRequiredPermissions(List<String> list) {
        this.requiredPermissions = list;
    }

    public List<String> getCommandsOnClick() {
        return this.commandsOnClick;
    }

    public void setCommandsOnClick(List<String> list) {
        this.commandsOnClick = list;
    }

    public List<String> getCommandsOnBuy() {
        return this.commandsOnBuy;
    }

    public void setCommandsOnBuy(List<String> list) {
        this.commandsOnBuy = list;
    }

    public List<String> getCommandsOnSell() {
        return this.commandsOnSell;
    }

    public void setCommandsOnSell(List<String> list) {
        this.commandsOnSell = list;
    }

    public List<String> getCommandsOnClickConsole() {
        return this.commandsOnClickConsole;
    }

    public void setCommandsOnClickConsole(List<String> list) {
        this.commandsOnClickConsole = list;
    }

    public List<String> getCommandsOnBuyConsole() {
        return this.commandsOnBuyConsole;
    }

    public void setCommandsOnBuyConsole(List<String> list) {
        this.commandsOnBuyConsole = list;
    }

    public List<String> getCommandsOnSellConsole() {
        return this.commandsOnSellConsole;
    }

    public void setCommandsOnSellConsole(List<String> list) {
        this.commandsOnSellConsole = list;
    }

    public int getMaxStackSize() {
        int n = 64;
        switch (this.type) {
            case ITEM: {
                n = Math.min(Settings.getMaxStackSize(this.item), 64);
                break;
            }
            case COMMAND: {
                n = Math.min(this.commandsLimit, 64);
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasRequiredPermissions(Player player) {
        if (this.requiredPermissions == null) return true;
        if (!this.requiredPermissions.stream().allMatch(arg_0 -> ((Player)player).hasPermission(arg_0))) return false;
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ShopItem shopItem = (ShopItem)object;
        return this.page == shopItem.page && this.slot == shopItem.slot && this.enchantmentLevel == shopItem.enchantmentLevel && Double.compare(shopItem.buyPrice, this.buyPrice) == 0 && Double.compare(shopItem.sellPrice, this.sellPrice) == 0 && this.originalStackSize == shopItem.originalStackSize && this.runCommandsAsBuyer == shopItem.runCommandsAsBuyer && this.requireInventorySpace == shopItem.requireInventorySpace && this.unstack == shopItem.unstack && this.stacked == shopItem.stacked && this.stripMeta == shopItem.stripMeta && this.compareMeta == shopItem.compareMeta && this.compareModel == shopItem.compareModel && this.compareDamage == shopItem.compareDamage && this.compareNbt == shopItem.compareNbt && this.itemStackSizeCappedAt == shopItem.itemStackSizeCappedAt && this.force == shopItem.force && this.enchantmentStackSizeLimit == shopItem.enchantmentStackSizeLimit && Objects.equals(this.shop, shopItem.shop) && Objects.equals(this.id, shopItem.id) && this.type == shopItem.type && Objects.equals(this.item, shopItem.item) && Objects.equals(this.placeholder, shopItem.placeholder) && Objects.equals(this.permissions, shopItem.permissions) && Objects.equals(this.enchantment, shopItem.enchantment) && Objects.equals(this.commands, shopItem.commands) && Objects.equals(this.specialElement, shopItem.specialElement) && Objects.equals(this.messageBuy, shopItem.messageBuy) && Objects.equals(this.messageSell, shopItem.messageSell) && Objects.equals(this.messageSellAll, shopItem.messageSellAll) && Objects.equals(this.requiredPermissions, shopItem.requiredPermissions) && Objects.equals(this.commandsOnClick, shopItem.commandsOnClick) && Objects.equals(this.commandsOnBuy, shopItem.commandsOnBuy) && Objects.equals(this.commandsOnSell, shopItem.commandsOnSell) && Objects.equals(this.commandsOnClickConsole, shopItem.commandsOnClickConsole) && Objects.equals(this.commandsOnBuyConsole, shopItem.commandsOnBuyConsole) && Objects.equals(this.commandsOnSellConsole, shopItem.commandsOnSellConsole);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shop, this.id, this.type, this.item, this.placeholder, this.page, this.slot, this.enchantmentLevel, this.buyPrice, this.sellPrice, this.originalStackSize, this.permissions, this.enchantment, this.commands, this.specialElement, this.runCommandsAsBuyer, this.requireInventorySpace, this.unstack, this.stacked, this.stripMeta, this.compareMeta, this.compareModel, this.compareDamage, this.compareNbt, this.itemStackSizeCappedAt, this.force, this.messageBuy, this.messageSell, this.messageSellAll, this.enchantmentStackSizeLimit, this.requiredPermissions, this.commandsOnClick, this.commandsOnBuy, this.commandsOnSell, this.commandsOnClickConsole, this.commandsOnBuyConsole, this.commandsOnSellConsole});
    }
}

