/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.shop;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.config.Lang;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.economy.EconomyType;
import net.brcdev.shopgui.gui.click.GuiClickActions;
import net.brcdev.shopgui.gui.element.button.GuiButton;
import net.brcdev.shopgui.permission.PermissionManager;
import net.brcdev.shopgui.player.PlayerData;
import net.brcdev.shopgui.provider.economy.EconomyProvider;
import net.brcdev.shopgui.shop.item.ShopItem;
import net.brcdev.shopgui.util.ItemUtils;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Shop {
    private String id;
    private String name;
    private Map<Integer, String> namePerPage;
    private int size;
    private boolean enablePerItemPermissions;
    private boolean denyDirectAccess;
    private boolean enableBuyGUI;
    private boolean enableSellGUI;
    private boolean enableSellGUISellAll;
    private EconomyType economyType;
    private ItemStack fillItem;
    private GuiClickActions guiClickActions;
    private List<String> worldsWhitelist;
    private List<String> worldsBlacklist;
    private List<ShopItem> shopItems;
    private GuiButton buttonGoBack;
    private GuiButton buttonPreviousPage;
    private GuiButton buttonNextPage;

    public Shop(String string, String string2, Map<Integer, String> map, int n, EconomyType economyType, ItemStack itemStack, GuiClickActions guiClickActions, List<String> list, List<String> list2) {
        this.id = string;
        this.name = string2;
        this.namePerPage = map;
        this.size = n;
        this.economyType = economyType;
        this.fillItem = itemStack;
        this.guiClickActions = guiClickActions;
        this.worldsWhitelist = list;
        this.worldsBlacklist = list2;
        this.shopItems = new ArrayList<ShopItem>();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Map<Integer, String> getNamePerPage() {
        return this.namePerPage;
    }

    public void setNamePerPage(Map<Integer, String> map) {
        this.namePerPage = map;
    }

    public String getName(int n) {
        return this.namePerPage.containsKey(n) ? this.namePerPage.get(n) : this.name;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public boolean isEnablePerItemPermissions() {
        return this.enablePerItemPermissions;
    }

    public void setEnablePerItemPermissions(boolean bl) {
        this.enablePerItemPermissions = bl;
    }

    public boolean isDenyDirectAccess() {
        return this.denyDirectAccess;
    }

    public void setDenyDirectAccess(boolean bl) {
        this.denyDirectAccess = bl;
    }

    public boolean isEnableBuyGUI() {
        return this.enableBuyGUI;
    }

    public void setEnableBuyGUI(boolean bl) {
        this.enableBuyGUI = bl;
    }

    public boolean isEnableSellGUI() {
        return this.enableSellGUI;
    }

    public void setEnableSellGUI(boolean bl) {
        this.enableSellGUI = bl;
    }

    public boolean isEnableSellGUISellAll() {
        return this.enableSellGUISellAll;
    }

    public void setEnableSellGUISellAll(boolean bl) {
        this.enableSellGUISellAll = bl;
    }

    public EconomyType getEconomyType() {
        return this.economyType;
    }

    public void setEconomyType(EconomyType economyType) {
        this.economyType = economyType;
    }

    public ItemStack getFillItem() {
        return this.fillItem;
    }

    public void setFillItem(ItemStack itemStack) {
        this.fillItem = itemStack;
    }

    public GuiClickActions getGuiClickActions() {
        return this.guiClickActions;
    }

    public void setGuiClickActions(GuiClickActions guiClickActions) {
        this.guiClickActions = guiClickActions;
    }

    public List<String> getWorldsWhitelist() {
        return this.worldsWhitelist;
    }

    public void setWorldsWhitelist(List<String> list) {
        this.worldsWhitelist = list;
    }

    public List<String> getWorldsBlacklist() {
        return this.worldsBlacklist;
    }

    public void setWorldsBlacklist(List<String> list) {
        this.worldsBlacklist = list;
    }

    public List<ShopItem> getShopItems() {
        return this.shopItems;
    }

    public void setShopItems(List<ShopItem> list) {
        this.shopItems = list;
    }

    public ShopItem getShopItem(String string) {
        for (ShopItem shopItem : this.shopItems) {
            if (!shopItem.getId().equalsIgnoreCase(string)) continue;
            return shopItem;
        }
        return null;
    }

    public ShopItem getShopItem(int n, int n2) {
        for (ShopItem shopItem : this.shopItems) {
            if (shopItem.getPage() != n || shopItem.getSlot() != n2) continue;
            return shopItem;
        }
        return null;
    }

    public GuiButton getButtonGoBack() {
        if (this.buttonGoBack != null) {
            return this.buttonGoBack;
        }
        return Settings.buttonGoBack;
    }

    public void setButtonGoBack(GuiButton guiButton) {
        this.buttonGoBack = guiButton;
    }

    public GuiButton getButtonPreviousPage() {
        if (this.buttonPreviousPage != null) {
            return this.buttonPreviousPage;
        }
        return Settings.buttonPreviousPage;
    }

    public void setButtonPreviousPage(GuiButton guiButton) {
        this.buttonPreviousPage = guiButton;
    }

    public GuiButton getButtonNextPage() {
        if (this.buttonNextPage != null) {
            return this.buttonNextPage;
        }
        return Settings.buttonNextPage;
    }

    public void setButtonNextPage(GuiButton guiButton) {
        this.buttonNextPage = guiButton;
    }

    public boolean hasAccess(Player player) {
        return PermissionManager.hasPermission(player, "shopguiplus.shops." + this.id);
    }

    public boolean hasAccessToItem(Player player, ShopItem shopItem, boolean bl) {
        if (!shopItem.hasRequiredPermissions(player)) {
            if (bl) {
                player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ITEM_NOACCESS.toString());
            }
            return false;
        }
        if (this.enablePerItemPermissions && !PermissionManager.hasPermission(player, "shopguiplus.item." + this.id + "." + shopItem.getId()) && !PermissionManager.hasPermission(player, "shopguiplus.item." + this.id + ".*")) {
            if (bl) {
                player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ITEM_NOACCESS.toString());
            }
            return false;
        }
        return true;
    }

    @Deprecated
    public ShopItem findShopItem(Player player, PlayerData playerData, ItemStack itemStack, boolean bl) {
        return this.findShopItem(player, itemStack, bl);
    }

    public ShopItem findShopItem(Player player, ItemStack itemStack, boolean bl) {
        for (ShopItem shopItem : this.shopItems) {
            double d;
            if (!this.hasAccessToItem(player, shopItem, false) || !ItemUtils.compareItemStacks(itemStack, shopItem.getItem(), shopItem.isCompareMeta(), shopItem.isCompareModel(), shopItem.isCompareDamage(), shopItem.isCompareNbt()) || (d = shopItem.getSellPrice(player)) < 0.0 || bl && d == 0.0) continue;
            return shopItem;
        }
        return null;
    }

    public ShopItem findShopItem(ItemStack itemStack, boolean bl) {
        for (ShopItem shopItem : this.shopItems) {
            if (bl && shopItem.getSellPrice() <= 0.0 || !ItemUtils.compareItemStacks(itemStack, shopItem.getItem(), shopItem.isCompareMeta(), shopItem.isCompareModel(), shopItem.isCompareDamage(), shopItem.isCompareNbt())) continue;
            return shopItem;
        }
        return null;
    }

    public EconomyProvider getEconomyProvider() {
        return ShopGuiPlugin.getInstance().getEconomyManager().getEconomyProvider(this.economyType);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Shop shop = (Shop)object;
        return this.id.equals(shop.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

