/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.shop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.brcdev.shopgui.config.Lang;
import net.brcdev.shopgui.provider.economy.EconomyProvider;
import net.brcdev.shopgui.shop.SellAllResult;
import net.brcdev.shopgui.shop.item.ShopItem;
import net.brcdev.shopgui.util.ChatUtils;

public class SellAllResults {
    private List<SellAllResult> results = new ArrayList<SellAllResult>();

    public List<SellAllResult> getResults() {
        return this.results;
    }

    public void addSellResult(ShopItem shopItem, int n, double d) {
        Optional<SellAllResult> optional = this.results.stream().filter(sellAllResult -> sellAllResult.getShopItem().equals(shopItem)).findFirst();
        if (optional.isPresent()) {
            SellAllResult sellAllResult2 = optional.get();
            sellAllResult2.setQuantity(sellAllResult2.getQuantity() + n);
            sellAllResult2.setPrice(sellAllResult2.getPrice() + d);
        } else {
            this.results.add(new SellAllResult(shopItem, n, d));
        }
    }

    public String getTotalEarningsList() {
        String string = "";
        HashMap<EconomyProvider, Double> hashMap = new HashMap<EconomyProvider, Double>();
        for (SellAllResult sellAllResult : this.results) {
            EconomyProvider economyProvider = sellAllResult.getShopItem().getShop().getEconomyProvider();
            if (hashMap.containsKey(economyProvider)) {
                hashMap.put(economyProvider, (Double)hashMap.get(economyProvider) + sellAllResult.getPrice());
                continue;
            }
            hashMap.put(economyProvider, sellAllResult.getPrice());
        }
        ArrayList arrayList = new ArrayList(hashMap.entrySet());
        for (int i = 0; i < arrayList.size(); ++i) {
            Map.Entry entry = (Map.Entry)arrayList.get(i);
            string = string + ChatUtils.formatCurrencyString((EconomyProvider)entry.getKey(), (double)((Double)entry.getValue()));
            if (i < arrayList.size() - 2) {
                string = string + ", ";
                continue;
            }
            if (i != arrayList.size() - 2) continue;
            string = string + Lang.MSG_AND.toString();
        }
        return string;
    }
}

