/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.shop;

import java.util.ArrayList;
import java.util.List;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.exception.item.ItemLoadException;
import net.brcdev.shopgui.gui.element.GuiElement;
import net.brcdev.shopgui.gui.element.GuiElementInInventory;
import net.brcdev.shopgui.gui.element.special.GuiSpecialElement;
import net.brcdev.shopgui.gui.element.special.GuiSpecialElementType;
import net.brcdev.shopgui.inventory.MainMenuInventoryHolder;
import net.brcdev.shopgui.provider.economy.EconomyProvider;
import net.brcdev.shopgui.shop.MainMenuItem;
import net.brcdev.shopgui.shop.ShopManager;
import net.brcdev.shopgui.util.ChatUtils;
import net.brcdev.shopgui.util.CollectionUtils;
import net.brcdev.shopgui.util.ItemUtils;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class MainMenu {
    private List<MainMenuItem> items = new ArrayList<MainMenuItem>();
    private int size;
    private String name;
    private ItemStack fillItem;

    public List<MainMenuItem> getItems() {
        return this.items;
    }

    public void setItems(List<MainMenuItem> list) {
        this.items = list;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public ItemStack getFillItem() {
        return this.fillItem;
    }

    public void setFillItem(ItemStack itemStack) {
        this.fillItem = itemStack;
    }

    public MainMenu load() {
        int n;
        this.items.clear();
        int n2 = 0;
        ShopGuiPlugin shopGuiPlugin = ShopGuiPlugin.getInstance();
        this.name = Settings.shopMenuName;
        if (Settings.shopMenuSize % 9 != 0) {
            shopGuiPlugin.warning("Invalid main shop menu size specified. Valid values are 9, 18, 27, 36, 45 and 54. Using default size of 9.");
            n = 9;
        } else {
            n = Settings.shopMenuSize;
        }
        this.size = n;
        this.fillItem = Settings.shopMenuFillItem;
        ConfigurationSection configurationSection = shopGuiPlugin.getConfigMain().getConfig().getConfigurationSection("shopMenuItems");
        block11: for (String string : configurationSection.getKeys(false)) {
            Object object;
            ShopManager.MainMenuItemType mainMenuItemType;
            String string2 = configurationSection.getString(string + ".shop");
            try {
                mainMenuItemType = ShopManager.MainMenuItemType.valueOf(configurationSection.getString(string + ".type").toUpperCase());
            }
            catch (NullPointerException nullPointerException) {
                mainMenuItemType = string2 != null ? ShopManager.MainMenuItemType.SHOP : ShopManager.MainMenuItemType.DUMMY;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                shopGuiPlugin.warning("Invalid item type specified for shopMenuItems > " + string + " (config.yml), item not loaded.");
                continue;
            }
            ItemStack itemStack = null;
            if (mainMenuItemType != ShopManager.MainMenuItemType.SPECIAL) {
                try {
                    itemStack = ItemUtils.loadItemStackFromConfig(configurationSection, string + ".item");
                }
                catch (ItemLoadException itemLoadException) {
                    shopGuiPlugin.warning("Error occurred when loading shopMenuItems > " + string + " (config.yml), item not loaded: " + itemLoadException.getMessage());
                    continue;
                }
            }
            int n3 = configurationSection.getInt(string + ".slot");
            MainMenuItem mainMenuItem = mainMenuItemType == ShopManager.MainMenuItemType.SPECIAL ? new MainMenuItem(mainMenuItemType, n3) : new MainMenuItem(mainMenuItemType, itemStack.clone(), n3);
            mainMenuItem.setCloseGuiOnClick(configurationSection.getBoolean(string + ".closeGuiOnClick"));
            switch (mainMenuItemType) {
                case SHOP: {
                    mainMenuItem.setShopId(string2);
                    break;
                }
                case SPECIAL: {
                    try {
                        object = GuiSpecialElementType.valueOf(configurationSection.getString(string + ".special").toUpperCase());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        shopGuiPlugin.warning("Invalid special item type specified for " + string2 + " > " + string + ", item not loaded.");
                        continue block11;
                    }
                    GuiSpecialElement guiSpecialElement = Settings.getGuiSpecialElement(object);
                    if (guiSpecialElement == null) {
                        shopGuiPlugin.warning("Invalid special item type specified for " + string2 + " > " + string + ", item not loaded.");
                        continue block11;
                    }
                    mainMenuItem.setSpecialElement(guiSpecialElement);
                    break;
                }
            }
            if (CollectionUtils.isNotEmpty(configurationSection.getStringList(string + ".commandsOnClick"))) {
                mainMenuItem.setCommandsOnClick(configurationSection.getStringList(string + ".commandsOnClick"));
            }
            if (CollectionUtils.isNotEmpty(configurationSection.getStringList(string + ".commandsOnClickConsole"))) {
                mainMenuItem.setCommandsOnClickConsole(configurationSection.getStringList(string + ".commandsOnClickConsole"));
            }
            if (configurationSection.get(string + ".slots") != null) {
                object = configurationSection.getIntegerList(string + ".slots");
                mainMenuItem.setSlots((List<Integer>)object);
            }
            this.items.add(mainMenuItem);
            ++n2;
        }
        shopGuiPlugin.getLogger().info("Loaded " + n2 + " main menu items.");
        return this;
    }

    public MainMenuItem getMainMenuItemBySlot(int n) {
        for (MainMenuItem mainMenuItem : this.items) {
            if (!mainMenuItem.getSlots().contains(n)) continue;
            return mainMenuItem;
        }
        return null;
    }

    public String getShopIdBySlot(int n) {
        for (MainMenuItem mainMenuItem : this.items) {
            if (!mainMenuItem.getSlots().contains(n)) continue;
            return mainMenuItem.getShopId();
        }
        return "";
    }

    public Inventory getInventory(Player player) {
        Inventory inventory = new MainMenuInventoryHolder(this.size, ChatUtils.fixColors(this.name)).getInventory();
        for (MainMenuItem mainMenuItem : this.items) {
            Object object;
            if (mainMenuItem.getType() == ShopManager.MainMenuItemType.SPECIAL) {
                object = mainMenuItem.getSpecialElement();
                switch (((GuiSpecialElement)object).getType()) {
                    case BALANCE: {
                        EconomyProvider economyProvider = ShopGuiPlugin.getInstance().getEconomyManager().getDefaultEconomyProvider();
                        ((GuiElementInInventory)object).setSlots(mainMenuItem.getSlots());
                        ((GuiElement)object).replacePlaceholder("%balance%", ChatUtils.formatCurrencyString(economyProvider, economyProvider.getBalance(player)));
                        break;
                    }
                }
                ((GuiElementInInventory)object).setInInventory(inventory);
                continue;
            }
            object = mainMenuItem.getSlots().iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                inventory.setItem(n, mainMenuItem.getItem());
            }
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null && inventory.getItem(i).getType() != Material.AIR) continue;
            inventory.setItem(i, this.fillItem.clone());
        }
        return inventory;
    }
}

