/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.exception.item.ItemLoadException;
import net.brcdev.shopgui.gui.element.button.GuiButton;
import net.brcdev.shopgui.util.ItemUtils;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public class MenuSettings {
    private String name;
    private int rows;
    private boolean replaceButtonsType;
    private ItemStack fillItem;
    private List<GuiButton> buttons = new ArrayList<GuiButton>();

    public MenuSettings(FileConfiguration fileConfiguration, String string) {
        this.load(fileConfiguration, string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public boolean isReplaceButtonsType() {
        return this.replaceButtonsType;
    }

    public void setReplaceButtonsType(boolean bl) {
        this.replaceButtonsType = bl;
    }

    public ItemStack getFillItem() {
        return this.fillItem;
    }

    public void setFillItem(ItemStack itemStack) {
        this.fillItem = itemStack;
    }

    public List<GuiButton> getButtons() {
        return this.buttons;
    }

    public void setButtons(List<GuiButton> list) {
        this.buttons = list;
    }

    private void load(FileConfiguration fileConfiguration, String string) {
        this.name = fileConfiguration.getString(string + ".name", "");
        this.rows = fileConfiguration.getInt(string + ".size") > 0 && fileConfiguration.getInt(string + ".size") % 9 == 0 ? fileConfiguration.getInt(string + ".size") / 9 : fileConfiguration.getInt(string + ".rows", 6);
        this.replaceButtonsType = fileConfiguration.getBoolean(string + ".replaceButtonsType", false);
        this.fillItem = new ItemStack(Material.AIR, 1);
        if (fileConfiguration.get(string + ".fillItem") != null) {
            try {
                this.fillItem = ItemUtils.loadItemStackFromConfig((ConfigurationSection)fileConfiguration, string + ".fillItem");
            }
            catch (ItemLoadException itemLoadException) {
                // empty catch block
            }
        }
        if (fileConfiguration.getConfigurationSection(string + ".buttons") != null) {
            for (String string2 : fileConfiguration.getConfigurationSection(string + ".buttons").getKeys(false)) {
                try {
                    this.loadGuiButton(fileConfiguration, string, string2);
                }
                catch (ItemLoadException itemLoadException) {
                    ShopGuiPlugin.getInstance().warning("Error occurred when loading button " + string + " > " + string2 + ", button not loaded: " + itemLoadException.getMessage());
                }
            }
        }
    }

    private boolean loadGuiButton(FileConfiguration fileConfiguration, String string, String string2) {
        List<Object> list = new ArrayList();
        if (fileConfiguration.get(string + ".buttons." + string2 + ".slots") != null) {
            list = fileConfiguration.getIntegerList(string + ".buttons." + string2 + ".slots");
        } else if (fileConfiguration.get(string + ".buttons." + string2 + ".slot") != null) {
            list = Arrays.asList(fileConfiguration.getInt(string + ".buttons." + string2 + ".slot"));
        }
        GuiButton guiButton = new GuiButton(list, string2, ItemUtils.loadItemStackFromConfig((ConfigurationSection)fileConfiguration, string + ".buttons." + string2 + ".item"), fileConfiguration.getInt(string + ".buttons." + string2 + ".value", 1));
        guiButton.setFillItem(this.fillItem);
        return this.buttons.add(guiButton);
    }

    public GuiButton getButton(String string) {
        for (GuiButton guiButton : this.buttons) {
            if (!guiButton.getId().equals(string)) continue;
            return guiButton;
        }
        return null;
    }

    public GuiButton getButton(int n, Collection<GuiButton> collection) {
        for (GuiButton guiButton : collection) {
            if (guiButton.getSlot() != n) continue;
            return guiButton;
        }
        return null;
    }

    public List<GuiButton> getButtons(String ... stringArray) {
        List<String> list = Arrays.asList(stringArray);
        ArrayList<GuiButton> arrayList = new ArrayList<GuiButton>();
        block0: for (GuiButton guiButton : this.buttons) {
            for (String string : list) {
                if (!guiButton.getId().startsWith(string)) continue;
                arrayList.add(guiButton);
                continue block0;
            }
        }
        return arrayList;
    }

    public GuiButton getButton(int n, String ... stringArray) {
        return this.getButton(n, this.getButtons(stringArray));
    }
}

