/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.provider.item;

import me.arcaniax.hdb.api.DatabaseLoadEvent;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import net.brcdev.shopgui.provider.item.ItemProvider;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class HeadDatabaseItemProvider
extends ItemProvider
implements Listener {
    private HeadDatabaseAPI headDatabaseApi;

    public HeadDatabaseItemProvider() {
        super("HeadDatabase");
        this.ready = false;
        this.headDatabaseApi = new HeadDatabaseAPI();
    }

    @Override
    public boolean isValidItem(ItemStack itemStack) {
        return this.headDatabaseApi.getItemID(itemStack) != null;
    }

    @Override
    public ItemStack loadItem(ConfigurationSection configurationSection) {
        String string = configurationSection.getString("headDatabase");
        if (string == null) {
            return null;
        }
        return this.headDatabaseApi.getItemHead(string);
    }

    @Override
    public boolean compare(ItemStack itemStack, ItemStack itemStack2) {
        if (!this.isValidItem(itemStack) || !this.isValidItem(itemStack2)) {
            return true;
        }
        return this.headDatabaseApi.getItemID(itemStack).equals(this.headDatabaseApi.getItemID(itemStack2));
    }

    @EventHandler
    public void onDatabaseLoad(DatabaseLoadEvent databaseLoadEvent) {
        this.ready = true;
    }
}

