/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.provider.item;

import com.ssomar.score.api.executableitems.ExecutableItemsAPI;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.api.executableitems.config.ExecutableItemsManagerInterface;
import com.ssomar.score.api.executableitems.load.ExecutableItemsPostLoadEvent;
import java.util.Optional;
import net.brcdev.shopgui.provider.item.ItemProvider;
import net.brcdev.shopgui.util.Constants;
import net.brcdev.shopgui.util.PluginUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class ExecutableItemsItemProvider
extends ItemProvider
implements Listener {
    private ExecutableItemsManagerInterface executableItemsManager;

    public ExecutableItemsItemProvider() {
        super("ExecutableItems");
        if (PluginUtils.isPluginEnabled(Constants.PLUGIN_EXECUTABLEITEMS)) {
            this.hook();
        } else {
            this.ready = false;
        }
    }

    @Override
    public boolean isValidItem(ItemStack itemStack) {
        return this.executableItemsManager.getExecutableItem(itemStack).isPresent();
    }

    @Override
    public ItemStack loadItem(ConfigurationSection configurationSection) {
        String string = configurationSection.getString("executableItems");
        if (string == null) {
            return null;
        }
        Optional optional = this.executableItemsManager.getExecutableItem(string);
        return optional.map(executableItemInterface -> executableItemInterface.buildItem(1, Optional.empty())).orElse(null);
    }

    @Override
    public boolean compare(ItemStack itemStack, ItemStack itemStack2) {
        if (!this.isValidItem(itemStack) || !this.isValidItem(itemStack2)) {
            return true;
        }
        Optional optional = this.executableItemsManager.getExecutableItem(itemStack);
        Optional optional2 = this.executableItemsManager.getExecutableItem(itemStack2);
        if (!optional.isPresent() || !optional2.isPresent()) {
            return false;
        }
        return ((ExecutableItemInterface)optional.get()).getId().equals(((ExecutableItemInterface)optional2.get()).getId());
    }

    @EventHandler
    public void onExecutableItemsPostLoad(ExecutableItemsPostLoadEvent executableItemsPostLoadEvent) {
        this.hook();
    }

    private void hook() {
        this.executableItemsManager = ExecutableItemsAPI.getExecutableItemsManager();
        this.ready = true;
    }
}

