/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.provider.economy;

import net.brcdev.shopgui.provider.economy.EconomyProvider;
import org.bukkit.entity.Player;

public class EconomyExpProvider
extends EconomyProvider {
    public EconomyExpProvider() {
        this.currencyPrefix = "";
        this.currencySuffix = " exp";
    }

    public static void setTotalExperience(Player player, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Experience is negative!");
        }
        player.setExp(0.0f);
        player.setLevel(0);
        player.setTotalExperience(0);
        int n2 = n;
        while (n2 > 0) {
            int n3 = EconomyExpProvider.getExpAtLevel(player);
            if ((n2 -= n3) >= 0) {
                player.giveExp(n3);
                continue;
            }
            player.giveExp(n2 += n3);
            n2 = 0;
        }
    }

    private static int getExpAtLevel(Player player) {
        return EconomyExpProvider.getExpAtLevel(player.getLevel());
    }

    public static int getExpAtLevel(int n) {
        if (n <= 15) {
            return 2 * n + 7;
        }
        if (n <= 30) {
            return 5 * n - 38;
        }
        return 9 * n - 158;
    }

    public static int getTotalExperience(Player player) {
        int n = Math.round((float)EconomyExpProvider.getExpAtLevel(player) * player.getExp());
        int n2 = player.getLevel();
        while (n2 > 0) {
            n += EconomyExpProvider.getExpAtLevel(--n2);
        }
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    public static int getExpUntilNextLevel(Player player) {
        int n = Math.round((float)EconomyExpProvider.getExpAtLevel(player) * player.getExp());
        int n2 = player.getLevel();
        return EconomyExpProvider.getExpAtLevel(n2) - n;
    }

    @Override
    public String getName() {
        return "Exp";
    }

    @Override
    public double getBalance(Player player) {
        return EconomyExpProvider.getTotalExperience(player);
    }

    @Override
    public void deposit(Player player, double d) {
        EconomyExpProvider.setTotalExperience(player, EconomyExpProvider.getTotalExperience(player) + (int)d);
    }

    @Override
    public void withdraw(Player player, double d) {
        if (EconomyExpProvider.getTotalExperience(player) >= (int)d) {
            EconomyExpProvider.setTotalExperience(player, EconomyExpProvider.getTotalExperience(player) - (int)d);
        } else {
            EconomyExpProvider.setTotalExperience(player, 0);
        }
    }
}

