/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.player;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.database.Callback;
import net.brcdev.shopgui.exception.player.PlayerDataNotLoadedException;
import net.brcdev.shopgui.modifier.PriceModifierActionType;
import net.brcdev.shopgui.modifier.PriceModifierEntry;
import net.brcdev.shopgui.modifier.command.CommandPriceModifiers;
import net.brcdev.shopgui.player.PlayerData;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerManager {
    private ShopGuiPlugin main;
    private HashMap<UUID, PlayerData> playerData = new HashMap();

    public PlayerManager(ShopGuiPlugin shopGuiPlugin) {
        this.main = shopGuiPlugin;
    }

    public void loadData(final Player player, final Callback callback) {
        this.main.getDataManager().loadPlayerData(player, new Callback<PlayerData>(){

            @Override
            public void onSuccess(PlayerData playerData) {
                if (!PlayerManager.this.isPlayerLoaded((OfflinePlayer)player)) {
                    PlayerManager.this.playerData.put(player.getUniqueId(), playerData);
                }
                Bukkit.getScheduler().runTask((Plugin)PlayerManager.this.main, () -> callback.onSuccess(playerData));
            }

            @Override
            public void onFailure(PlayerData playerData) {
                Bukkit.getScheduler().runTask((Plugin)PlayerManager.this.main, () -> callback.onFailure(playerData));
            }
        });
    }

    public PlayerData registerPlayer(Player player) {
        PriceModifierEntry priceModifierEntry = new PriceModifierEntry(new HashMap<PriceModifierActionType, Double>());
        priceModifierEntry.set(PriceModifierActionType.BUY, 1.0);
        priceModifierEntry.set(PriceModifierActionType.SELL, 1.0);
        CommandPriceModifiers commandPriceModifiers = new CommandPriceModifiers(priceModifierEntry, new HashMap<String, PriceModifierEntry>(), new HashMap<String, Map<String, PriceModifierEntry>>());
        PlayerData playerData = new PlayerData(player.getUniqueId(), player.getName(), commandPriceModifiers);
        this.playerData.put(player.getUniqueId(), playerData);
        this.main.getDataManager().registerPlayerData(playerData);
        return playerData;
    }

    public void unloadData(OfflinePlayer offlinePlayer) {
        if (this.playerData.containsKey(offlinePlayer.getUniqueId())) {
            this.playerData.remove(offlinePlayer.getUniqueId());
        }
    }

    public boolean isPlayerLoaded(OfflinePlayer offlinePlayer) {
        return this.playerData.containsKey(offlinePlayer.getUniqueId());
    }

    public PlayerData getPlayerData(OfflinePlayer offlinePlayer) {
        if (!this.isPlayerLoaded(offlinePlayer)) {
            throw new PlayerDataNotLoadedException(offlinePlayer);
        }
        return this.playerData.get(offlinePlayer.getUniqueId());
    }

    public void handlePlayerData(Player player, Callback<PlayerData> callback) {
        if (this.isPlayerLoaded((OfflinePlayer)player)) {
            callback.onSuccess(this.playerData.get(player.getUniqueId()));
        } else {
            this.loadData(player, callback);
        }
    }
}

