/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.modifier;

import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.modifier.PriceModifier;
import net.brcdev.shopgui.modifier.PriceModifierActionType;
import net.brcdev.shopgui.modifier.PriceModifierType;
import net.brcdev.shopgui.modifier.command.CommandPriceModifierManager;
import net.brcdev.shopgui.modifier.permission.PermissionPriceModifier;
import net.brcdev.shopgui.modifier.permission.PermissionPriceModifierManager;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.item.ShopItem;
import org.bukkit.OfflinePlayer;

public class PriceModifierManager {
    private ShopGuiPlugin main;
    private CommandPriceModifierManager commandPriceModifierManager;
    private PermissionPriceModifierManager permissionPriceModifierManager;

    public PriceModifierManager(ShopGuiPlugin shopGuiPlugin) {
        this.main = shopGuiPlugin;
        this.commandPriceModifierManager = new CommandPriceModifierManager(shopGuiPlugin);
        this.permissionPriceModifierManager = new PermissionPriceModifierManager(shopGuiPlugin);
    }

    public CommandPriceModifierManager getCommandPriceModifierManager() {
        return this.commandPriceModifierManager;
    }

    public PermissionPriceModifierManager getPermissionPriceModifierManager() {
        return this.permissionPriceModifierManager;
    }

    public void loadPriceModifiers() {
        this.permissionPriceModifierManager.loadPermissionPriceModifiers();
        this.main.info("Loaded " + this.permissionPriceModifierManager.getPermissionPriceModifiers().size() + " permission-based price modifiers.");
    }

    public PriceModifier getPriceModifier(OfflinePlayer offlinePlayer, ShopItem shopItem, PriceModifierActionType priceModifierActionType) {
        PermissionPriceModifier permissionPriceModifier = null;
        double d = this.commandPriceModifierManager.getItemPriceModifier(offlinePlayer, shopItem, priceModifierActionType);
        if (offlinePlayer.isOnline()) {
            permissionPriceModifier = this.permissionPriceModifierManager.getPlayersPermissionPriceModifier(offlinePlayer.getPlayer(), shopItem, priceModifierActionType);
        }
        return this.getEffectivePriceModifier(priceModifierActionType, permissionPriceModifier, d);
    }

    public void setPriceModifier(OfflinePlayer offlinePlayer, ShopItem shopItem, PriceModifierActionType priceModifierActionType, double d) {
        this.commandPriceModifierManager.setItemPriceModifier(offlinePlayer, shopItem, priceModifierActionType, d);
    }

    public void resetPriceModifier(OfflinePlayer offlinePlayer, ShopItem shopItem, PriceModifierActionType priceModifierActionType) {
        this.commandPriceModifierManager.resetItemPriceModifier(offlinePlayer, shopItem, priceModifierActionType);
    }

    public PriceModifier getPriceModifier(OfflinePlayer offlinePlayer, Shop shop, PriceModifierActionType priceModifierActionType) {
        PermissionPriceModifier permissionPriceModifier = null;
        double d = this.commandPriceModifierManager.getShopPriceModifier(offlinePlayer, shop, priceModifierActionType);
        if (offlinePlayer.isOnline()) {
            permissionPriceModifier = this.permissionPriceModifierManager.getShopPriceModifier(offlinePlayer.getPlayer(), shop, priceModifierActionType);
        }
        return this.getEffectivePriceModifier(priceModifierActionType, permissionPriceModifier, d);
    }

    public void setPriceModifier(OfflinePlayer offlinePlayer, Shop shop, PriceModifierActionType priceModifierActionType, double d) {
        this.commandPriceModifierManager.setShopPriceModifier(offlinePlayer, shop, priceModifierActionType, d);
    }

    public void resetPriceModifier(OfflinePlayer offlinePlayer, Shop shop, PriceModifierActionType priceModifierActionType) {
        this.commandPriceModifierManager.resetShopPriceModifier(offlinePlayer, shop, priceModifierActionType);
    }

    public PriceModifier getPriceModifier(OfflinePlayer offlinePlayer, PriceModifierActionType priceModifierActionType) {
        PermissionPriceModifier permissionPriceModifier = null;
        double d = this.commandPriceModifierManager.getGlobalPriceModifier(offlinePlayer, priceModifierActionType);
        if (offlinePlayer.isOnline()) {
            permissionPriceModifier = this.permissionPriceModifierManager.getGlobalPriceModifier(offlinePlayer.getPlayer(), priceModifierActionType);
        }
        return this.getEffectivePriceModifier(priceModifierActionType, permissionPriceModifier, d);
    }

    public void setPriceModifier(OfflinePlayer offlinePlayer, PriceModifierActionType priceModifierActionType, double d) {
        this.commandPriceModifierManager.setGlobalPriceModifier(offlinePlayer, priceModifierActionType, d);
    }

    public void resetPriceModifier(OfflinePlayer offlinePlayer, PriceModifierActionType priceModifierActionType) {
        this.commandPriceModifierManager.resetGlobalPriceModifier(offlinePlayer, priceModifierActionType);
    }

    private PriceModifier getEffectivePriceModifier(PriceModifierActionType priceModifierActionType, PermissionPriceModifier permissionPriceModifier, double d) {
        PriceModifierType priceModifierType = null;
        double d2 = 1.0;
        if (permissionPriceModifier == null) {
            priceModifierType = PriceModifierType.COMMAND;
            d2 = d;
        } else {
            switch (Settings.priceModifiersType) {
                case BOTH: {
                    if (d != 1.0 && (priceModifierActionType == PriceModifierActionType.BUY && d < permissionPriceModifier.getValue() || priceModifierActionType == PriceModifierActionType.SELL && d > permissionPriceModifier.getValue())) {
                        priceModifierType = PriceModifierType.COMMAND;
                        d2 = d;
                        break;
                    }
                    priceModifierType = PriceModifierType.PERMISSION;
                    d2 = permissionPriceModifier.getValue();
                    break;
                }
                case COMMAND: {
                    priceModifierType = PriceModifierType.COMMAND;
                    d2 = d;
                    break;
                }
                case PERMISSION: {
                    priceModifierType = PriceModifierType.PERMISSION;
                    d2 = permissionPriceModifier.getValue();
                }
            }
        }
        return new PriceModifier(priceModifierType, d2);
    }
}

