/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.listener;

import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.config.Lang;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.core.BInventoryHolder;
import net.brcdev.shopgui.database.Callback;
import net.brcdev.shopgui.event.ShopPostTransactionEvent;
import net.brcdev.shopgui.event.ShopPreTransactionEvent;
import net.brcdev.shopgui.exception.player.PlayerDataNotLoadedException;
import net.brcdev.shopgui.gui.click.GuiClickAction;
import net.brcdev.shopgui.gui.element.button.GuiButton;
import net.brcdev.shopgui.gui.gui.AmountSelectionBulkGui;
import net.brcdev.shopgui.gui.gui.AmountSelectionGui;
import net.brcdev.shopgui.gui.gui.OpenGui;
import net.brcdev.shopgui.gui.gui.ShopGui;
import net.brcdev.shopgui.permission.PermissionManager;
import net.brcdev.shopgui.player.PlayerData;
import net.brcdev.shopgui.shop.MainMenuItem;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.ShopManager;
import net.brcdev.shopgui.shop.ShopTransactionResult;
import net.brcdev.shopgui.shop.item.ShopItem;
import net.brcdev.shopgui.shop.item.ShopItemPermission;
import net.brcdev.shopgui.shop.item.ShopItemType;
import net.brcdev.shopgui.sound.SoundAction;
import net.brcdev.shopgui.util.ChatUtils;
import net.brcdev.shopgui.util.InventoryUtils;
import net.brcdev.shopgui.util.ItemUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PlayerListener
implements Listener {
    private ShopGuiPlugin main;

    public PlayerListener(ShopGuiPlugin shopGuiPlugin) {
        this.main = shopGuiPlugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        this.main.getPlayerManager().loadData(player, new Callback(){

            public void onSuccess(Object object) {
            }

            public void onFailure(Object object) {
            }
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        this.main.getPlayerManager().unloadData((OfflinePlayer)player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClose(InventoryCloseEvent inventoryCloseEvent) {
        Player player = (Player)inventoryCloseEvent.getPlayer();
        if (this.main.getPlayerManager().isPlayerLoaded((OfflinePlayer)player)) {
            PlayerData playerData;
            try {
                playerData = this.main.getPlayerManager().getPlayerData((OfflinePlayer)player);
            }
            catch (PlayerDataNotLoadedException playerDataNotLoadedException) {
                return;
            }
            if (playerData.hasOpenGui() && !playerData.isSwitchingGui()) {
                InventoryUtils.updateInventory(player, playerData);
                playerData.resetOpenGui();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        PlayerData playerData;
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        int n = inventoryClickEvent.getRawSlot();
        ClickType clickType = inventoryClickEvent.getClick();
        if (inventoryClickEvent.getInventory().getHolder() instanceof BInventoryHolder) {
            inventoryClickEvent.setCancelled(true);
        }
        if (inventoryClickEvent.getSlotType() == InventoryType.SlotType.OUTSIDE) {
            return;
        }
        if (!this.main.getPlayerManager().isPlayerLoaded((OfflinePlayer)player)) {
            return;
        }
        try {
            playerData = this.main.getPlayerManager().getPlayerData((OfflinePlayer)player);
        }
        catch (PlayerDataNotLoadedException playerDataNotLoadedException) {
            return;
        }
        if (!playerData.hasOpenGui()) {
            return;
        }
        if (playerData.getLastGuiClick() != 0L && System.currentTimeMillis() - playerData.getLastGuiClick() < Settings.guiClickCooldown) {
            inventoryClickEvent.setCancelled(true);
            return;
        }
        inventoryClickEvent.setCancelled(true);
        playerData.setLastGuiClick(System.currentTimeMillis());
        OpenGui openGui = playerData.getOpenGui();
        switch (openGui.getType()) {
            case AMOUNT_SELECTION: {
                this.clickAmountSelectionGui(player, n, playerData, openGui);
                break;
            }
            case AMOUNT_SELECTION_BULK_BUY: {
                this.clickAmountSelectionBulkBuyGui(player, n, playerData, openGui);
                break;
            }
            case AMOUNT_SELECTION_BULK_SELL: {
                this.clickAmountSelectionBulkSellGui(player, n, playerData, openGui);
                break;
            }
            case SHOP: {
                this.clickShopGui(player, n, clickType, playerData, openGui);
                break;
            }
            default: {
                this.clickMainGui(player, n);
            }
        }
    }

    private void clickShopGui(Player player, int n, ClickType clickType, PlayerData playerData, OpenGui openGui) {
        Object object2;
        ShopGui shopGui = (ShopGui)openGui;
        Shop shop = shopGui.getShop();
        int n2 = shopGui.getCurrentPage();
        if (n >= shopGui.getShopInventory().get(n2).getSize()) {
            return;
        }
        if (shop.getButtonGoBack().getSlots().contains(n)) {
            this.main.getShopManager().openMainMenu(player, playerData.isAllowAllShopsAccessFromCurrentGui());
            return;
        }
        if (shop.getButtonPreviousPage().getSlots().contains(n) && shopGui.getShopInventory().containsKey(n2 - 1)) {
            this.main.getSoundManager().playSound(player, SoundAction.SHOP_SWITCH_PAGE);
            int n3 = n2 - 1;
            shopGui.setCurrentPage(n3);
            InventoryUtils.openInventory(player, playerData, shopGui.getShopInventory().get(n3), openGui);
            return;
        }
        if (shop.getButtonNextPage().getSlots().contains(n) && shopGui.getShopInventory().containsKey(n2 + 1)) {
            this.main.getSoundManager().playSound(player, SoundAction.SHOP_SWITCH_PAGE);
            int n4 = n2 + 1;
            shopGui.setCurrentPage(n4);
            InventoryUtils.openInventory(player, playerData, shopGui.getShopInventory().get(n4), openGui);
            return;
        }
        ShopItem shopItem = shop.getShopItem(n2, n);
        if (shopItem == null) {
            return;
        }
        if (!shop.hasAccessToItem(player, shopItem, true)) {
            return;
        }
        this.main.getSoundManager().playSound(player, SoundAction.SHOP_SELECT_ITEM);
        for (Object object2 : shopItem.getCommandsOnClick()) {
            Bukkit.dispatchCommand((CommandSender)player, (String)object2.replace("%PLAYER%", player.getName()));
        }
        for (Object object2 : shopItem.getCommandsOnClickConsole()) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)object2.replace("%PLAYER%", player.getName()));
        }
        if (shopItem.getType() == ShopItemType.SHOP_LINK) {
            this.main.getShopManager().openShopMenu(player, shopItem.getShopLinkShopId(), true);
            return;
        }
        if (shopItem.isCloseGuiOnClick()) {
            this.main.getShopManager().closeGui(player);
            return;
        }
        ItemStack itemStack = shopItem.getPlaceholder().clone();
        object2 = null;
        if (shop.getGuiClickActions().hasClickType(clickType)) {
            object2 = shop.getGuiClickActions().getGuiClickAction(clickType);
        } else if (Settings.clickActions.hasClickType(clickType)) {
            object2 = Settings.clickActions.getGuiClickAction(clickType);
        }
        if (object2 != null) {
            if (object2 == GuiClickAction.BUY) {
                switch (shopItem.getType()) {
                    case ITEM: {
                        this.clickBuyItem(player, playerData, shopItem, itemStack);
                        break;
                    }
                    case PERMISSION: {
                        this.clickBuyPermission(player, shopGui, shopItem);
                        break;
                    }
                    case ENCHANTMENT: {
                        this.clickBuyEnchantment(player, shopItem);
                        break;
                    }
                    case COMMAND: {
                        this.clickBuyCommand(player, playerData, shopItem, itemStack);
                    }
                }
            } else if (object2 == GuiClickAction.SELL && shopItem.getType() == ShopItemType.ITEM) {
                this.clickSellItem(player, playerData, shopItem, itemStack);
            } else if (object2 == GuiClickAction.SELL_ALL && shopItem.getType() == ShopItemType.ITEM) {
                if (!Settings.enableSellAll) {
                    return;
                }
                if (shopItem.getSellPrice(player) < 0.0) {
                    player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ITEM_CANNOTSELL.toString());
                    return;
                }
                this.clickSellAllItem(player, shopItem);
            }
        }
    }

    private void clickMainGui(Player player, int n) {
        if (this.main.getShopManager().getMainMenuItemBySlot(n) == null) {
            return;
        }
        MainMenuItem mainMenuItem = this.main.getShopManager().getMainMenuItemBySlot(n);
        if (mainMenuItem.isCloseGuiOnClick()) {
            this.main.getShopManager().closeGui(player);
            return;
        }
        if (mainMenuItem.getType() == ShopManager.MainMenuItemType.SHOP) {
            String string = mainMenuItem.getShopId();
            if (PermissionManager.hasPermission(player, "shopguiplus.shops." + string)) {
                mainMenuItem.executeAllCommands(player);
            }
            this.main.getShopManager().openShopMenu(player, string, true);
        } else if (mainMenuItem.getType() == ShopManager.MainMenuItemType.DUMMY) {
            mainMenuItem.executeAllCommands(player);
        }
    }

    private void clickAmountSelectionBulkSellGui(Player player, int n, PlayerData playerData, OpenGui openGui) {
        AmountSelectionBulkGui amountSelectionBulkGui = (AmountSelectionBulkGui)openGui;
        if (amountSelectionBulkGui.getMenuSettings().getButton("cancel").getSlots().contains(n)) {
            if (Settings.openBulkGuiImmediately) {
                if (Settings.returnToShop) {
                    this.main.getShopManager().openShopMenu(player, amountSelectionBulkGui.getShop(), amountSelectionBulkGui.getShopItem().getPage(), false);
                } else {
                    player.closeInventory();
                }
                return;
            }
            this.clickSellItem(player, playerData, amountSelectionBulkGui.getShopItem(), amountSelectionBulkGui.getItemStack());
        } else {
            GuiButton guiButton = amountSelectionBulkGui.getMenuSettings().getButton(n, "sell");
            if (guiButton == null) {
                return;
            }
            this.main.getShopManager().handleItemSell(player, amountSelectionBulkGui.getShopItem(), guiButton.getValue() * amountSelectionBulkGui.getShopItem().getMaxStackSize(), true, true);
            if (!Settings.quickBuySell) {
                if (Settings.returnToShop) {
                    this.main.getShopManager().openShopMenu(player, amountSelectionBulkGui.getShop(), amountSelectionBulkGui.getShopItem().getPage(), false);
                } else {
                    player.closeInventory();
                }
            }
        }
    }

    private void clickAmountSelectionBulkBuyGui(Player player, int n, PlayerData playerData, OpenGui openGui) {
        AmountSelectionBulkGui amountSelectionBulkGui = (AmountSelectionBulkGui)openGui;
        if (amountSelectionBulkGui.getMenuSettings().getButton("cancel").getSlots().contains(n)) {
            if (Settings.openBulkGuiImmediately) {
                if (Settings.returnToShop) {
                    this.main.getShopManager().openShopMenu(player, amountSelectionBulkGui.getShop(), amountSelectionBulkGui.getShopItem().getPage(), false);
                } else {
                    player.closeInventory();
                }
                return;
            }
            this.clickBuyItem(player, playerData, amountSelectionBulkGui.getShopItem(), amountSelectionBulkGui.getItemStack());
        } else {
            GuiButton guiButton = amountSelectionBulkGui.getMenuSettings().getButton(n, "buy");
            if (guiButton == null) {
                return;
            }
            this.main.getShopManager().handleItemBuy(player, amountSelectionBulkGui.getShopItem(), guiButton.getValue() * amountSelectionBulkGui.getShopItem().getMaxStackSize(), true);
            if (!Settings.quickBuySell) {
                if (Settings.returnToShop) {
                    this.main.getShopManager().openShopMenu(player, amountSelectionBulkGui.getShop(), amountSelectionBulkGui.getShopItem().getPage(), false);
                } else {
                    player.closeInventory();
                }
            }
        }
    }

    private void clickAmountSelectionGui(Player player, int n, PlayerData playerData, OpenGui openGui) {
        AmountSelectionGui amountSelectionGui = (AmountSelectionGui)openGui;
        Inventory inventory = amountSelectionGui.getInventory();
        if (n >= inventory.getSize()) {
            return;
        }
        if (Settings.enableAmountSelectionFix && playerData.getLastAmountSelectionGuiClick() != 0L && System.currentTimeMillis() - playerData.getLastAmountSelectionGuiClick() <= 100L) {
            return;
        }
        int n2 = amountSelectionGui.getShopItem().getMaxStackSize();
        if (Settings.amountSelectionGUISettings.getButton("set1").getSlots().contains(n)) {
            amountSelectionGui.setItemAmount(playerData, 1);
        } else if (Settings.amountSelectionGUISettings.getButton("remove10").getSlots().contains(n)) {
            if (amountSelectionGui.getItemAmount() - 10 >= 1) {
                amountSelectionGui.setItemAmount(playerData, amountSelectionGui.getItemAmount() - 10);
            }
        } else if (Settings.amountSelectionGUISettings.getButton("remove1").getSlots().contains(n)) {
            if (amountSelectionGui.getItemAmount() - 1 >= 1) {
                amountSelectionGui.setItemAmount(playerData, amountSelectionGui.getItemAmount() - 1);
            }
        } else if (Settings.amountSelectionGUISettings.getButton("add1").getSlots().contains(n)) {
            if (amountSelectionGui.getItemAmount() + 1 <= n2) {
                amountSelectionGui.setItemAmount(playerData, amountSelectionGui.getItemAmount() + 1);
            }
        } else if (Settings.amountSelectionGUISettings.getButton("add10").getSlots().contains(n)) {
            if (amountSelectionGui.getItemAmount() + 10 <= n2) {
                amountSelectionGui.setItemAmount(playerData, amountSelectionGui.getItemAmount() + 10);
            }
        } else if (Settings.amountSelectionGUISettings.getButton("set64").getSlots().contains(n)) {
            amountSelectionGui.setItemAmount(playerData, n2);
        } else if (Settings.amountSelectionGUISettings.getButton("confirm").getSlots().contains(n)) {
            if (amountSelectionGui.getActionType() == ShopManager.ShopAction.BUY) {
                if (amountSelectionGui.getShopItem().getType() == ShopItemType.ITEM) {
                    this.main.getShopManager().handleItemBuy(player, amountSelectionGui.getShopItem(), amountSelectionGui.getItemStack().getAmount(), true);
                } else if (amountSelectionGui.getShopItem().getType() == ShopItemType.COMMAND) {
                    this.main.getShopManager().handleCommandBuy(player, amountSelectionGui.getShopItem(), amountSelectionGui.getItemStack().getAmount(), true);
                }
            } else if (amountSelectionGui.getActionType() == ShopManager.ShopAction.SELL) {
                this.main.getShopManager().handleItemSell(player, amountSelectionGui.getShopItem(), amountSelectionGui.getItemStack().getAmount(), true, true);
            }
            if (!Settings.quickBuySell) {
                if (Settings.returnToShop) {
                    this.main.getShopManager().openShopMenu(player, amountSelectionGui.getShop(), amountSelectionGui.getShopItem().getPage(), false);
                } else {
                    player.closeInventory();
                }
            }
        } else if (Settings.amountSelectionGUISettings.getButton("sellAll").getSlots().contains(n)) {
            if (amountSelectionGui.getActionType() != ShopManager.ShopAction.SELL) {
                return;
            }
            this.main.getShopManager().handleItemSellAll(player, amountSelectionGui.getShopItem(), true);
            if (Settings.returnToShop) {
                this.main.getShopManager().openShopMenu(player, amountSelectionGui.getShop(), amountSelectionGui.getShopItem().getPage(), false);
            } else {
                player.closeInventory();
            }
        } else if (Settings.amountSelectionGUISettings.getButton("cancel").getSlots().contains(n)) {
            if (Settings.returnToShop) {
                this.main.getShopManager().openShopMenu(player, amountSelectionGui.getShop(), amountSelectionGui.getShopItem().getPage(), false);
            } else {
                player.closeInventory();
            }
        } else if (amountSelectionGui.getShopItem().getType() == ShopItemType.ITEM) {
            if (amountSelectionGui.getActionType() == ShopManager.ShopAction.BUY && Settings.amountSelectionGUISettings.getButton("buyMore").getSlots().contains(n) && PermissionManager.hasPermission(player, "shopguiplus.buymore")) {
                AmountSelectionBulkGui amountSelectionBulkGui = new AmountSelectionBulkGui(player, playerData, OpenGui.MenuType.AMOUNT_SELECTION_BULK_BUY, amountSelectionGui.getShop(), ShopManager.ShopAction.BUY, amountSelectionGui.getShopItem(), amountSelectionGui.getItemStack(), Settings.amountSelectionGUISettingsBulkBuy);
                InventoryUtils.openInventory(player, playerData, amountSelectionBulkGui.getInventory(), amountSelectionBulkGui);
            } else if (amountSelectionGui.getActionType() == ShopManager.ShopAction.SELL && Settings.amountSelectionGUISettings.getButton("sellMore").getSlots().contains(n) && PermissionManager.hasPermission(player, "shopguiplus.sellmore")) {
                AmountSelectionBulkGui amountSelectionBulkGui = new AmountSelectionBulkGui(player, playerData, OpenGui.MenuType.AMOUNT_SELECTION_BULK_SELL, amountSelectionGui.getShop(), ShopManager.ShopAction.SELL, amountSelectionGui.getShopItem(), amountSelectionGui.getItemStack(), Settings.amountSelectionGUISettingsBulkSell);
                InventoryUtils.openInventory(player, playerData, amountSelectionBulkGui.getInventory(), amountSelectionBulkGui);
            }
        }
    }

    private void clickBuyItem(Player player, PlayerData playerData, ShopItem shopItem, ItemStack itemStack) {
        Shop shop = shopItem.getShop();
        if (shopItem.getBuyPrice(player) < 0.0) {
            player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ITEM_CANNOTBUY.toString());
            return;
        }
        if (Settings.enableBuyGUI && shop.isEnableBuyGUI()) {
            if (Settings.openBulkGuiImmediately) {
                if (PermissionManager.hasPermission(player, "shopguiplus.buymore")) {
                    AmountSelectionBulkGui amountSelectionBulkGui = new AmountSelectionBulkGui(player, playerData, OpenGui.MenuType.AMOUNT_SELECTION_BULK_BUY, shop, ShopManager.ShopAction.BUY, shopItem, itemStack, Settings.amountSelectionGUISettingsBulkBuy);
                    InventoryUtils.openInventory(player, playerData, amountSelectionBulkGui.getInventory(), amountSelectionBulkGui);
                } else {
                    player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_NOACCESS.toString());
                }
            } else {
                AmountSelectionGui amountSelectionGui = new AmountSelectionGui(player, playerData, OpenGui.MenuType.AMOUNT_SELECTION, shop, ShopManager.ShopAction.BUY, shopItem, itemStack);
                InventoryUtils.openInventory(player, playerData, amountSelectionGui.getInventory(), amountSelectionGui);
            }
            return;
        }
        this.main.getShopManager().handleItemBuy(player, shopItem, itemStack.getAmount(), true);
    }

    private void clickSellItem(Player player, PlayerData playerData, ShopItem shopItem, ItemStack itemStack) {
        Shop shop = shopItem.getShop();
        if (shopItem.getSellPrice(player) < 0.0) {
            player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ITEM_CANNOTSELL.toString());
            return;
        }
        if (Settings.enableSellGUI && shop.isEnableSellGUI()) {
            if (Settings.openBulkGuiImmediately) {
                if (PermissionManager.hasPermission(player, "shopguiplus.sellmore")) {
                    AmountSelectionBulkGui amountSelectionBulkGui = new AmountSelectionBulkGui(player, playerData, OpenGui.MenuType.AMOUNT_SELECTION_BULK_SELL, shop, ShopManager.ShopAction.SELL, shopItem, itemStack, Settings.amountSelectionGUISettingsBulkSell);
                    InventoryUtils.openInventory(player, playerData, amountSelectionBulkGui.getInventory(), amountSelectionBulkGui);
                } else {
                    player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_NOACCESS.toString());
                }
            } else {
                AmountSelectionGui amountSelectionGui = new AmountSelectionGui(player, playerData, OpenGui.MenuType.AMOUNT_SELECTION, shop, ShopManager.ShopAction.SELL, shopItem, itemStack);
                InventoryUtils.openInventory(player, playerData, amountSelectionGui.getInventory(), amountSelectionGui);
            }
            return;
        }
        this.main.getShopManager().handleItemSell(player, shopItem, itemStack.getAmount(), true, true);
    }

    private void clickSellAllItem(Player player, ShopItem shopItem) {
        this.main.getShopManager().handleItemSellAll(player, shopItem, true);
    }

    private void clickBuyEnchantment(Player player, ShopItem shopItem) {
        Shop shop = shopItem.getShop();
        ItemStack itemStack = player.getItemInHand();
        int n = 1;
        double d = shopItem.getBuyPrice(player);
        ShopPreTransactionEvent shopPreTransactionEvent = this.callPreTransactionEvent(ShopManager.ShopAction.BUY, player, shopItem, n, d);
        if (shopPreTransactionEvent.isCancelled()) {
            this.callPostTransactionEvent(ShopManager.ShopAction.BUY, ShopTransactionResult.ShopTransactionResultType.FAILURE_CANCELLED, shopItem, player, n, d);
            return;
        }
        try {
            if (itemStack == null || itemStack.getType() == Material.AIR || !ItemUtils.canEnchantItem(itemStack, shopItem.getEnchantment()) && !Settings.disableUnsafeEnchantmentCheck) {
                this.callPostTransactionEvent(ShopManager.ShopAction.BUY, ShopTransactionResult.ShopTransactionResultType.FAILURE_ENCHANTMENT_INAPPLICABLE, shopItem, player, n, d);
                player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ENCHANT_CANNOTAPPLY.toString().replace("%enchantment%", ChatUtils.formatEnchantmentName(shopItem.getEnchantment())));
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            this.callPostTransactionEvent(ShopManager.ShopAction.BUY, ShopTransactionResult.ShopTransactionResultType.FAILURE_ENCHANTMENT_INAPPLICABLE, shopItem, player, n, d);
            player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ENCHANT_CANNOTAPPLY.toString().replace("%enchantment%", ChatUtils.formatEnchantmentName(shopItem.getEnchantment())));
            return;
        }
        if (itemStack.getEnchantmentLevel(shopItem.getEnchantment()) >= shopItem.getEnchantmentLevel()) {
            this.callPostTransactionEvent(ShopManager.ShopAction.BUY, ShopTransactionResult.ShopTransactionResultType.FAILURE_ENCHANTMENT_ALREADY_APPLIED, shopItem, player, n, d);
            player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ENCHANT_ALREADYAPPLIED.toString().replace("%enchantment%", ChatUtils.formatEnchantmentName(shopItem.getEnchantment())));
            return;
        }
        if (Settings.maxEnchantments >= 0 && itemStack.getEnchantments().size() >= Settings.maxEnchantments) {
            this.callPostTransactionEvent(ShopManager.ShopAction.BUY, ShopTransactionResult.ShopTransactionResultType.FAILURE_ENCHANTMENT_MAX_AMOUNT, shopItem, player, n, d);
            player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ENCHANT_MAX.toString().replace("%amount%", String.valueOf(Settings.maxEnchantments)));
            return;
        }
        if (Settings.limitEnchantmentLevelDiff && shopItem.getEnchantmentLevel() - itemStack.getEnchantmentLevel(shopItem.getEnchantment()) > 1) {
            this.callPostTransactionEvent(ShopManager.ShopAction.BUY, ShopTransactionResult.ShopTransactionResultType.FAILURE_ENCHANTMENT_LEVEL_DIFF, shopItem, player, n, d);
            player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ENCHANT_LEVELDIFF.toString().replace("%enchantment%", ChatUtils.formatEnchantmentName(shopItem.getEnchantment())).replace("%level%", String.valueOf(shopItem.getEnchantmentLevel() - 1)));
            return;
        }
        if (shopItem.getEnchantmentStackSizeLimit() > 0 && itemStack.getAmount() > shopItem.getEnchantmentStackSizeLimit()) {
            this.callPostTransactionEvent(ShopManager.ShopAction.BUY, ShopTransactionResult.ShopTransactionResultType.FAILURE_ENCHANTMENT_TOO_MANY_ITEMS, shopItem, player, n, d);
            player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ENCHANT_TOOMANY.toString().replace("%amount%", String.valueOf(shopItem.getEnchantmentStackSizeLimit())));
            return;
        }
        if (!shop.getEconomyProvider().has(player, d)) {
            this.callPostTransactionEvent(ShopManager.ShopAction.BUY, ShopTransactionResult.ShopTransactionResultType.FAILURE_NO_MONEY, shopItem, player, n, d);
            player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_ENCHANT_CANNOTAFFORD.toString().replace("%price%", ChatUtils.formatCurrencyString(shop, d)).replace("%enchantment%", ChatUtils.formatEnchantmentName(shopItem.getEnchantment())));
            return;
        }
        if (!Settings.returnToShop) {
            player.closeInventory();
        }
        shop.getEconomyProvider().withdraw(player, d);
        itemStack.addUnsafeEnchantment(shopItem.getEnchantment(), shopItem.getEnchantmentLevel());
        String string = !shopItem.getMessageBuy().isEmpty() ? ChatUtils.fixColors(shopItem.getMessageBuy()) : (Settings.useDifferentMessagesForFreeItems && d == 0.0 ? Lang.MSG_ENCHANT_BOUGHTFREE.toMsg() : Lang.MSG_ENCHANT_BOUGHT.toMsg());
        player.sendMessage(string.replace("%price%", ChatUtils.formatCurrencyString(shop, d)).replace("%enchantment%", ChatUtils.formatEnchantmentName(shopItem.getEnchantment())));
        this.main.logTransaction(Settings.logFormatBuyEnchantment.replace("%player%", player.getName()).replace("%price%", ChatUtils.formatCurrencyString(shop, d)).replace("%shop%", shop.getId()).replace("%enchantment%", ChatUtils.formatEnchantmentName(shopItem.getEnchantment())));
        for (String string2 : shopItem.getCommandsOnBuyConsole()) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)string2.replace("%PLAYER%", player.getName()).replace("%AMOUNT%", String.valueOf(n)));
        }
        for (String string2 : shopItem.getCommandsOnBuy()) {
            Bukkit.dispatchCommand((CommandSender)player, (String)string2.replace("%PLAYER%", player.getName()).replace("%AMOUNT%", String.valueOf(n)));
        }
        this.callPostTransactionEvent(ShopManager.ShopAction.BUY, ShopTransactionResult.ShopTransactionResultType.SUCCESS, shopItem, player, n, d);
    }

    private void clickBuyPermission(Player player, ShopGui shopGui, ShopItem shopItem) {
        double d;
        Shop shop = shopItem.getShop();
        int n = shopItem.getPermissions().size();
        ShopPreTransactionEvent shopPreTransactionEvent = this.callPreTransactionEvent(ShopManager.ShopAction.BUY, player, shopItem, n, d = shopItem.getBuyPrice(player));
        if (shopPreTransactionEvent.isCancelled()) {
            this.callPostTransactionEvent(ShopManager.ShopAction.BUY, ShopTransactionResult.ShopTransactionResultType.FAILURE_CANCELLED, shopItem, player, n, d);
            return;
        }
        if (!this.main.enablePermissions()) {
            this.callPostTransactionEvent(ShopManager.ShopAction.BUY, ShopTransactionResult.ShopTransactionResultType.FAILURE_NO_MONEY, shopItem, player, n, d);
            player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_PERMISSION_PERMISSIONSDISABLED.toString());
            return;
        }
        if (!shopItem.isForce()) {
            for (ShopItemPermission object : shopItem.getPermissions()) {
                if (!object.has(player)) continue;
                this.callPostTransactionEvent(ShopManager.ShopAction.BUY, ShopTransactionResult.ShopTransactionResultType.FAILURE_PERMISSION_ALREADY_HAVE, shopItem, player, n, d);
                player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_PERMISSION_ALREADYHAVE.toString().replace("%permission%", ItemUtils.formatItemName(shopItem.getItem(), player)));
                return;
            }
        } else {
            boolean bl = true;
            for (ShopItemPermission shopItemPermission : shopItem.getPermissions()) {
                if (shopItemPermission.has(player)) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.callPostTransactionEvent(ShopManager.ShopAction.BUY, ShopTransactionResult.ShopTransactionResultType.FAILURE_PERMISSION_ALREADY_HAVE, shopItem, player, n, d);
                player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_PERMISSION_ALREADYHAVE.toString().replace("%permission%", ItemUtils.formatItemName(shopItem.getItem(), player)));
                return;
            }
        }
        if (!shop.getEconomyProvider().has(player, d)) {
            this.callPostTransactionEvent(ShopManager.ShopAction.BUY, ShopTransactionResult.ShopTransactionResultType.FAILURE_NO_MONEY, shopItem, player, n, d);
            player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_PERMISSION_CANNOTAFFORD.toString().replace("%price%", ChatUtils.formatCurrencyString(shop, d)).replace("%permission%", ItemUtils.formatItemName(shopItem.getItem(), player)));
            return;
        }
        if (!Settings.returnToShop) {
            player.closeInventory();
        }
        shop.getEconomyProvider().withdraw(player, d);
        for (ShopItemPermission shopItemPermission : shopItem.getPermissions()) {
            this.main.getPermissions().playerAdd(shopItemPermission.getWorld(), (OfflinePlayer)player, shopItemPermission.getPermissionNode());
        }
        this.main.getShopManager().openShopMenu(player, shopGui.getShop(), shopGui.getCurrentPage(), true);
        String string = !shopItem.getMessageBuy().isEmpty() ? ChatUtils.fixColors(shopItem.getMessageBuy()) : (Settings.useDifferentMessagesForFreeItems && d == 0.0 ? Lang.MSG_PERMISSION_BOUGHTFREE.toMsg() : Lang.MSG_PERMISSION_BOUGHT.toMsg());
        player.sendMessage(string.replace("%price%", ChatUtils.formatCurrencyString(shop, d)).replace("%permission%", ItemUtils.formatItemName(shopItem.getItem(), player)));
        this.main.logTransaction(Settings.logFormatBuyPermission.replace("%player%", player.getName()).replace("%price%", ChatUtils.formatCurrencyString(shop, d)).replace("%shop%", shop.getId()).replace("%permission%", ItemUtils.formatItemName(shopItem.getItem(), player)));
        for (String string2 : shopItem.getCommandsOnBuyConsole()) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)string2.replace("%PLAYER%", player.getName()).replace("%AMOUNT%", String.valueOf(n)));
        }
        for (String string3 : shopItem.getCommandsOnBuy()) {
            Bukkit.dispatchCommand((CommandSender)player, (String)string3.replace("%PLAYER%", player.getName()).replace("%AMOUNT%", String.valueOf(n)));
        }
        this.callPostTransactionEvent(ShopManager.ShopAction.BUY, ShopTransactionResult.ShopTransactionResultType.SUCCESS, shopItem, player, n, d);
    }

    private void clickBuyCommand(Player player, PlayerData playerData, ShopItem shopItem, ItemStack itemStack) {
        Shop shop = shopItem.getShop();
        if (Settings.enableBuyGUI && shop.isEnableBuyGUI()) {
            if (Settings.openBulkGuiImmediately) {
                if (PermissionManager.hasPermission(player, "shopguiplus.buymore")) {
                    AmountSelectionBulkGui amountSelectionBulkGui = new AmountSelectionBulkGui(player, playerData, OpenGui.MenuType.AMOUNT_SELECTION_BULK_BUY, shop, ShopManager.ShopAction.BUY, shopItem, itemStack, Settings.amountSelectionGUISettingsBulkBuy);
                    InventoryUtils.openInventory(player, playerData, amountSelectionBulkGui.getInventory(), amountSelectionBulkGui);
                } else {
                    player.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_NOACCESS.toString());
                }
            } else {
                AmountSelectionGui amountSelectionGui = new AmountSelectionGui(player, playerData, OpenGui.MenuType.AMOUNT_SELECTION, shop, ShopManager.ShopAction.BUY, shopItem, itemStack);
                InventoryUtils.openInventory(player, playerData, amountSelectionGui.getInventory(), amountSelectionGui);
            }
            return;
        }
        this.main.getShopManager().handleCommandBuy(player, shopItem, itemStack.getAmount(), true);
    }

    private ShopPreTransactionEvent callPreTransactionEvent(ShopManager.ShopAction shopAction, Player player, ShopItem shopItem, int n, double d) {
        ShopPreTransactionEvent shopPreTransactionEvent = new ShopPreTransactionEvent(shopAction, shopItem, player, n, d);
        Bukkit.getPluginManager().callEvent((Event)shopPreTransactionEvent);
        return shopPreTransactionEvent;
    }

    private ShopPostTransactionEvent callPostTransactionEvent(ShopManager.ShopAction shopAction, ShopTransactionResult.ShopTransactionResultType shopTransactionResultType, ShopItem shopItem, Player player, int n, double d) {
        ShopTransactionResult shopTransactionResult = new ShopTransactionResult(shopAction, shopTransactionResultType, shopItem, player, n, d);
        ShopPostTransactionEvent shopPostTransactionEvent = new ShopPostTransactionEvent(shopTransactionResult);
        Bukkit.getPluginManager().callEvent((Event)shopPostTransactionEvent);
        return shopPostTransactionEvent;
    }
}

