/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.gui.gui;

import net.brcdev.shopgui.config.Lang;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.gui.element.button.GuiButton;
import net.brcdev.shopgui.gui.gui.OpenGui;
import net.brcdev.shopgui.inventory.AmountSelectionBulkGuiInventoryHolder;
import net.brcdev.shopgui.player.PlayerData;
import net.brcdev.shopgui.settings.MenuSettings;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.ShopManager;
import net.brcdev.shopgui.shop.item.ShopItem;
import net.brcdev.shopgui.util.ChatUtils;
import net.brcdev.shopgui.util.ItemUtils;
import net.brcdev.shopgui.util.NmsUtils;
import net.brcdev.shopgui.util.NmsVersion;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class AmountSelectionBulkGui
extends OpenGui {
    private ShopManager.ShopAction shopAction;
    private ShopItem shopItem;
    private ItemStack itemStack;
    private MenuSettings menuSettings;

    public AmountSelectionBulkGui(Player player, PlayerData playerData, OpenGui.MenuType menuType, Shop shop, ShopManager.ShopAction shopAction, ShopItem shopItem, ItemStack itemStack, MenuSettings menuSettings) {
        super(player, playerData, menuType, shop);
        this.shopAction = shopAction;
        this.shopItem = shopItem;
        this.itemStack = itemStack;
        this.menuSettings = menuSettings;
        this.createInventory();
    }

    public ShopManager.ShopAction getShopAction() {
        return this.shopAction;
    }

    public void setShopAction(ShopManager.ShopAction shopAction) {
        this.shopAction = shopAction;
    }

    public ShopItem getShopItem() {
        return this.shopItem;
    }

    public void setShopItem(ShopItem shopItem) {
        this.shopItem = shopItem;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public MenuSettings getMenuSettings() {
        return this.menuSettings;
    }

    public void setMenuSettings(MenuSettings menuSettings) {
        this.menuSettings = menuSettings;
    }

    private void createInventory() {
        String string = "";
        if (this.shopAction == ShopManager.ShopAction.BUY) {
            string = Lang.DIALOG_AMOUNTSELECTION_BULKBUY_NAME.toString().replace("%item%", ItemUtils.formatItemName(this.itemStack, this.player));
        } else if (this.shopAction == ShopManager.ShopAction.SELL) {
            string = Lang.DIALOG_AMOUNTSELECTION_BULKSELL_NAME.toString().replace("%item%", ItemUtils.formatItemName(this.itemStack, this.player));
        }
        if (!NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_9) && string.length() > 26) {
            string = string.substring(0, 26);
        }
        Inventory inventory = new AmountSelectionBulkGuiInventoryHolder(this.menuSettings.getRows() * 9, string).getInventory();
        this.menuSettings.getButton("cancel").setInInventory(inventory);
        if (this.shopAction == ShopManager.ShopAction.BUY) {
            for (GuiButton guiButton : this.menuSettings.getButtons("buy")) {
                if (this.menuSettings.isReplaceButtonsType()) {
                    guiButton.replaceFromItem(this.itemStack);
                }
                guiButton.replacePlaceholder("%buy%", ChatUtils.formatCurrencyString(this.shopItem.getShop(), this.shopItem.getBuyPriceForAmount(this.player, guiButton.getValue() * Settings.getMaxStackSize(this.itemStack))));
                guiButton.setInInventory(inventory);
            }
        } else if (this.shopAction == ShopManager.ShopAction.SELL) {
            for (GuiButton guiButton : this.menuSettings.getButtons("sell")) {
                if (this.menuSettings.isReplaceButtonsType()) {
                    guiButton.replaceFromItem(this.itemStack);
                }
                guiButton.replacePlaceholder("%sell%", ChatUtils.formatCurrencyString(this.shop, this.shopItem.getSellPriceForAmount(this.player, guiButton.getValue() * Settings.getMaxStackSize(this.itemStack))));
                guiButton.setInInventory(inventory);
            }
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null && inventory.getItem(i).getType() != Material.AIR) continue;
            inventory.setItem(i, this.menuSettings.getFillItem().clone());
        }
        this.setInventory(inventory);
    }
}

