/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.gui.click;

import java.util.HashMap;
import java.util.Map;
import net.brcdev.shopgui.gui.click.GuiClickAction;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.ClickType;

public class GuiClickActions {
    private Map<ClickType, GuiClickAction> clickActions = new HashMap<ClickType, GuiClickAction>();

    public void clear() {
        this.clickActions.clear();
    }

    public boolean hasClickType(ClickType clickType) {
        return this.clickActions.containsKey(clickType);
    }

    public void load(ConfigurationSection configurationSection, boolean bl) {
        if (configurationSection != null) {
            for (String string : configurationSection.getKeys(false)) {
                GuiClickAction guiClickAction;
                ClickType clickType;
                try {
                    clickType = ClickType.valueOf((String)string);
                    guiClickAction = GuiClickAction.valueOf(configurationSection.getString(string));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                this.clickActions.put(clickType, guiClickAction);
            }
        } else if (bl) {
            this.clickActions.put(ClickType.LEFT, GuiClickAction.BUY);
            this.clickActions.put(ClickType.RIGHT, GuiClickAction.SELL);
            this.clickActions.put(ClickType.MIDDLE, GuiClickAction.SELL_ALL);
        }
    }

    public GuiClickAction getGuiClickAction(ClickType clickType) {
        return this.clickActions.get(clickType);
    }
}

