/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.database;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.database.DataManager;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class MySqlDataManager
extends DataManager {
    public MySqlDataManager(ShopGuiPlugin shopGuiPlugin) {
        super(shopGuiPlugin);
    }

    @Override
    public void setup() {
        Statement statement = null;
        try {
            statement = this.getConnection().prepareStatement("CREATE TABLE IF NOT EXISTS " + this.playersTableName + " (`id` int(11) NOT NULL AUTO_INCREMENT, `uuid` char(36) CHARACTER SET utf8 NOT NULL, `name` varchar(16) CHARACTER SET utf8 NOT NULL, `priceModifiers` TEXT NOT NULL, PRIMARY KEY (`id`));");
            statement.executeUpdate();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public void open() {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            String string = "jdbc:mysql://" + Settings.databaseMySQLHost + ":" + Settings.databaseMySQLPort + "/" + Settings.databaseMySQLDatabase + "?characterEncoding=utf8&autoReconnect=true&useSSL=false";
            for (Map.Entry<String, String> entry : Settings.databaseMySQLParameters.entrySet()) {
                string = string + "&" + entry.getKey() + "=" + entry.getValue();
            }
            this.connection = DriverManager.getConnection(string, Settings.databaseMySQLUser, Settings.databaseMySQLPassword);
        }
        catch (SQLException sQLException) {
            this.main.severe("Plugin disabled due to MySQL error!");
            Bukkit.getServer().getPluginManager().disablePlugin((Plugin)this.main);
            sQLException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.main.severe("Plugin disabled due to no MySQL driver found!");
            Bukkit.getServer().getPluginManager().disablePlugin((Plugin)this.main);
            classNotFoundException.printStackTrace();
        }
    }
}

