/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.config.Lang;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class BSubCommand {
    public ShopGuiPlugin main = ShopGuiPlugin.getInstance();
    public List<String> aliases = new ArrayList<String>();
    public CommandSender sender;
    public String[] args;
    public Player player;
    public String correctUsage = "";
    public String permission = "";
    public boolean senderMustBePlayer;

    public void execute(CommandSender commandSender, String[] stringArray) {
        this.execute(commandSender, stringArray, true);
    }

    public void execute(CommandSender commandSender, String[] stringArray, boolean bl) {
        this.player = commandSender instanceof Player ? (Player)commandSender : null;
        this.sender = commandSender;
        if (bl) {
            LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(stringArray));
            linkedList.remove(0);
            this.args = linkedList.toArray(new String[linkedList.size()]);
        } else {
            this.args = stringArray;
        }
        if (!commandSender.hasPermission(this.permission)) {
            this.msg(Lang.MSG_NOACCESS.toMsg());
            return;
        }
        if (this.senderMustBePlayer && !this.isPlayer()) {
            this.msg(Lang.MSG_INGAMEONLY.toMsg());
            return;
        }
        this.execute();
    }

    public abstract void execute();

    public void msg(String string) {
        this.sender.sendMessage(string);
    }

    public void sendCorrectUsage() {
        this.msg(Lang.MSG_USAGE_SUBCOMMAND.toMsg().replace("%usage%", this.correctUsage));
    }

    public boolean isPlayer() {
        return this.player != null;
    }

    public String buildStringFromArgs(int n, int n2) {
        String string;
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.args.length > n + 1) {
            StringBuilder stringBuilder = new StringBuilder(this.args[n]);
            for (int i = n + 1; i < n2 + 1; ++i) {
                stringBuilder.append(" " + this.args[i]);
            }
            string = stringBuilder.toString();
        } else {
            string = this.args[n];
        }
        return string;
    }

    public String str(Object object) {
        return String.valueOf(object);
    }

    public String getSenderName() {
        if (this.isPlayer()) {
            return this.player.getName();
        }
        return Lang.LANG_CONSOLE.toString();
    }
}

