/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.config.entry.ItemStackSizeLimitEntry;
import net.brcdev.shopgui.core.BConfig;
import net.brcdev.shopgui.database.DataManager;
import net.brcdev.shopgui.economy.EconomyType;
import net.brcdev.shopgui.exception.item.InvalidMaterialException;
import net.brcdev.shopgui.exception.item.ItemLoadException;
import net.brcdev.shopgui.gui.click.GuiClickActions;
import net.brcdev.shopgui.gui.element.button.GuiButton;
import net.brcdev.shopgui.gui.element.special.GuiSpecialElement;
import net.brcdev.shopgui.gui.element.special.GuiSpecialElementType;
import net.brcdev.shopgui.modifier.PriceModifierType;
import net.brcdev.shopgui.settings.MenuSettings;
import net.brcdev.shopgui.settings.MenuWithItemSettings;
import net.brcdev.shopgui.util.ChatUtils;
import net.brcdev.shopgui.util.ItemUtils;
import net.brcdev.shopgui.util.NmsUtils;
import net.brcdev.shopgui.util.NmsVersion;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public class Settings {
    public static String databaseMySQLHost;
    public static String databaseMySQLDatabase;
    public static String databaseMySQLUser;
    public static String databaseMySQLPassword;
    public static String databaseTableNamePlayers;
    public static String shopMenuName;
    public static String buyPriceForUnsellablePlaceholder;
    public static String sellPriceForUnsellablePlaceholder;
    public static String logFormatDate;
    public static String logFormatBuyCommand;
    public static String logFormatBuyEnchantment;
    public static String logFormatBuyPermission;
    public static String logFormatBuy;
    public static String logFormatSell;
    public static String logFormatSellAll;
    public static String numberFormatDecimalSeparator;
    public static String numberFormatGroupingSeparator;
    public static String spawnerProvider;
    public static boolean enableSellAll;
    public static boolean enableBuyGUI;
    public static boolean enableSellGUI;
    public static boolean returnToShop;
    public static boolean quickBuySell;
    public static boolean enableSellGUISellAll;
    public static boolean hideBuyPriceForUnbuyable;
    public static boolean hideSellPriceForUnsellable;
    public static boolean logToConsole;
    public static boolean logToFile;
    public static boolean enableAmountSelectionFix;
    public static boolean allowAllSellAllStackSizes;
    public static boolean disableMainMenu;
    public static boolean useDifferentMessagesForFreeItems;
    public static boolean limitEnchantmentLevelDiff;
    public static boolean numberFormatHideFraction;
    public static boolean displayPriceModifiersInPercents;
    public static boolean disableSudoWorldPermissionCheck;
    public static boolean disableSudoShopPermissionCheck;
    public static boolean disableUnsafeEnchantmentCheck;
    public static boolean capitalizeItemNames;
    public static boolean closeGuiAfterSellAll;
    public static boolean openBulkGuiImmediately;
    public static boolean sudoAllowAllShopsAccess;
    public static boolean sellHandAllowAllQuantities;
    public static boolean sellHandSellsAllItems;
    public static boolean sellHandExcludeFreeItems;
    public static boolean sellHandExcludeArmorSlots;
    public static boolean sellHandExcludeOffHand;
    public static boolean sellAllDetailedSummary;
    public static boolean sellAllFindMaxSellPrice;
    public static boolean sellAllExcludeFreeItems;
    public static boolean sellAllExcludeArmorSlots;
    public static boolean sellAllExcludeOffHand;
    public static boolean defaultItemSettingsCompareMeta;
    public static boolean defaultItemSettingsStripItemMeta;
    public static boolean defaultItemSettingsCompareModel;
    public static boolean defaultItemSettingsCompareDamage;
    public static boolean defaultItemSettingsCompareNbt;
    public static boolean enforceDefaultStackSize;
    public static boolean disablePermissionCache;
    public static boolean numberFormatEnableShortScale;
    public static int databaseMySQLPort;
    public static int shopMenuSize;
    public static int maxEnchantments;
    public static int numberFormatMinimumIntegerDigits;
    public static int numberFormatMaximumIntegerDigits;
    public static int numberFormatMinimumFractionDigits;
    public static int numberFormatMaximumFractionDigits;
    public static int numberFormatShortScaleLimit;
    public static int numberFormatShortHandDecimalLimit;
    public static int numberFormatShortHandNumberLimit;
    public static long guiClickCooldown;
    public static GuiButton buttonGoBack;
    public static GuiButton buttonPreviousPage;
    public static GuiButton buttonNextPage;
    public static Set<EconomyType> economyTypes;
    public static List<String> shopItemLoreFormatItem;
    public static List<String> shopItemLoreFormatItemBuyGUI;
    public static List<String> shopItemLoreFormatItemSellGUI;
    public static List<String> shopItemLoreFormatItemSellGUISellAll;
    public static List<String> shopItemLoreFormatPermission;
    public static List<String> shopItemLoreFormatEnchantment;
    public static List<String> shopItemLoreFormatCommand;
    public static List<String> disableShopsInWorlds;
    public static List<GameMode> disableShopsInGamemodes;
    public static Set<ItemStackSizeLimitEntry> itemStackSizeCappedAt;
    public static List<GuiSpecialElement> specialElements;
    public static Map<String, String> databaseMySQLParameters;
    public static Map<String, String> currencyPrefixes;
    public static Map<String, String> currencySuffixes;
    public static GuiClickActions clickActions;
    public static MenuWithItemSettings amountSelectionGUISettings;
    public static MenuSettings amountSelectionGUISettingsBulkBuy;
    public static MenuSettings amountSelectionGUISettingsBulkSell;
    public static DataManager.DatabaseType databaseType;
    public static RoundType priceRoundType;
    public static PriceModifierType priceModifiersType;
    public static ItemStack shopMenuFillItem;
    private static FileConfiguration config;

    public static void setConfig(BConfig bConfig) {
        config = bConfig.getConfig();
    }

    public static void loadItemStacks() {
        ConfigurationSection configurationSection;
        ItemStack itemStack;
        ItemStack itemStack2;
        ItemStack itemStack3;
        itemStackSizeCappedAt.clear();
        try {
            itemStack3 = ItemUtils.loadItemStackFromConfig((ConfigurationSection)config, "buttons.goBack.item");
        }
        catch (ItemLoadException itemLoadException) {
            ShopGuiPlugin.getInstance().warning("Error occurred when loading buttons > goBack (config.yml), item not loaded: " + itemLoadException.getMessage());
            itemStack3 = new ItemStack(Material.NETHER_STAR, 1);
        }
        try {
            itemStack2 = ItemUtils.loadItemStackFromConfig((ConfigurationSection)config, "buttons.previousPage.item");
        }
        catch (ItemLoadException itemLoadException) {
            ShopGuiPlugin.getInstance().warning("Error occurred when loading buttons > previousPage (config.yml), item not loaded: " + itemLoadException.getMessage());
            itemStack2 = new ItemStack(Material.PAPER, 1);
        }
        try {
            itemStack = ItemUtils.loadItemStackFromConfig((ConfigurationSection)config, "buttons.nextPage.item");
        }
        catch (ItemLoadException itemLoadException) {
            ShopGuiPlugin.getInstance().warning("Error occurred when loading buttons > nextPage (config.yml), item not loaded: " + itemLoadException.getMessage());
            itemStack = new ItemStack(Material.PAPER, 1);
        }
        if (config.get("buttons.goBack.slots") != null) {
            List list = config.getIntegerList("buttons.goBack.slots");
            buttonGoBack = new GuiButton("goBack", itemStack3, list);
        } else if (config.get("buttons.goBack.slot") != null) {
            int n = config.getInt("buttons.goBack.slot");
            buttonGoBack = new GuiButton("goBack", itemStack3, n);
        }
        if (config.get("buttons.previousPage.slots") != null) {
            List list = config.getIntegerList("buttons.previousPage.slots");
            buttonPreviousPage = new GuiButton("previousPage", itemStack2, list);
        } else if (config.get("buttons.previousPage.slot") != null) {
            int n = config.getInt("buttons.previousPage.slot");
            buttonPreviousPage = new GuiButton("previousPage", itemStack2, n);
        }
        if (config.get("buttons.nextPage.slots") != null) {
            List list = config.getIntegerList("buttons.nextPage.slots");
            buttonNextPage = new GuiButton("nextPage", itemStack, list);
        } else if (config.get("buttons.nextPage.slot") != null) {
            int n = config.getInt("buttons.nextPage.slot");
            buttonNextPage = new GuiButton("nextPage", itemStack, n);
        }
        if (config.getStringList("itemsStackSizeCappedAt16") != null) {
            for (Object object : config.getStringList("itemsStackSizeCappedAt16")) {
                Object object2;
                boolean bl = false;
                try {
                    object2 = ItemUtils.loadSimpleItemStack((String)object);
                }
                catch (InvalidMaterialException invalidMaterialException) {
                    ShopGuiPlugin.getInstance().warning("Error occurred when loading itemsStackSizeCappedAt16 > " + (String)object + " (config.yml), item not loaded: " + invalidMaterialException.getMessage());
                    continue;
                }
                if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_9) && (object2.getType() == Material.POTION || object2.getType() == Material.LINGERING_POTION || object2.getType() == Material.SPLASH_POTION) && object2.hasItemMeta()) {
                    bl = true;
                }
                itemStackSizeCappedAt.add(new ItemStackSizeLimitEntry((ItemStack)object2, 16, bl));
            }
        }
        if ((configurationSection = config.getConfigurationSection("itemStackSizeCappedAt")) != null) {
            for (Object object2 : configurationSection.getKeys(false)) {
                int n;
                ItemStack itemStack4;
                boolean bl = false;
                try {
                    itemStack4 = ItemUtils.loadItemStackFromConfig(configurationSection, (String)object2);
                }
                catch (ItemLoadException itemLoadException) {
                    ShopGuiPlugin.getInstance().warning("Error occurred when loading itemStackSizeCappedAt > " + (String)object2 + " (config.yml), item not loaded: " + itemLoadException.getMessage());
                    continue;
                }
                if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_9) && (itemStack4.getType() == Material.POTION || itemStack4.getType() == Material.LINGERING_POTION || itemStack4.getType() == Material.SPLASH_POTION) && itemStack4.hasItemMeta()) {
                    bl = true;
                }
                if ((n = configurationSection.getInt((String)object2 + ".size")) <= 0) continue;
                itemStackSizeCappedAt.add(new ItemStackSizeLimitEntry(itemStack4, n, bl));
            }
        }
        amountSelectionGUISettings = new MenuWithItemSettings(config, "amountSelectionGUI");
        amountSelectionGUISettingsBulkBuy = new MenuSettings(config, "amountSelectionGUIBulkBuy");
        amountSelectionGUISettingsBulkSell = new MenuSettings(config, "amountSelectionGUIBulkSell");
        shopMenuFillItem = new ItemStack(Material.AIR, 1);
        if (config.get("shopMenuFillItem") != null) {
            try {
                shopMenuFillItem = ItemUtils.loadItemStackFromConfig((ConfigurationSection)config, "shopMenuFillItem");
            }
            catch (ItemLoadException itemLoadException) {
                ShopGuiPlugin.getInstance().warning("Error occurred when loading shopMenuFillItem (config.yml), item not loaded: " + itemLoadException.getMessage());
            }
        }
    }

    public static void load() {
        Object object;
        Object object2;
        Iterator iterator2;
        ConfigurationSection configurationSection;
        databaseMySQLHost = config.getString("database.mySQLHost", "localhost");
        databaseMySQLDatabase = config.getString("database.mySQLDatabase", "db");
        databaseMySQLUser = config.getString("database.mySQLUser", "root");
        databaseMySQLPassword = config.getString("database.mySQLPassword", "");
        databaseTableNamePlayers = config.getString("database.tableNames.players", "players");
        shopMenuName = config.getString("shopMenuName", "");
        buyPriceForUnsellablePlaceholder = config.getString("buyPriceForUnsellablePlaceholder", "-");
        sellPriceForUnsellablePlaceholder = config.getString("sellPriceForUnsellablePlaceholder", "-");
        logFormatDate = config.getString("log.formatDate", "yyyy/MM/dd HH:mm:ss");
        logFormatBuyCommand = config.getString("log.formatBuyCommand", "%player% bought following command for %price% from %shop% shop: %command%");
        logFormatBuyEnchantment = config.getString("log.formatBuyEnchantment", "%player% bought %enchantment% enchantment for %price% from %shop% shop");
        logFormatBuyPermission = config.getString("log.formatBuyPermission", "%player% bought %permission% permission for %price% from %shop% shop");
        logFormatBuy = config.getString("log.formatBuy", "%player% bought %amount% x %item% for %price% from %shop% shop");
        logFormatSell = config.getString("log.formatSell", "%player% sold %amount% x %item% for %price% to %shop% shop");
        logFormatSellAll = config.getString("log.formatSellAll", "%player% sold all %amount% x %item% for %price% to %shop% shop");
        numberFormatDecimalSeparator = config.getString("numberFormat.decimalSeparator", ".");
        numberFormatGroupingSeparator = config.getString("numberFormat.groupingSeparator", ",");
        spawnerProvider = config.getString("spawnerProvider", "");
        enableSellAll = config.getBoolean("enableSellAll", true);
        enableBuyGUI = config.getBoolean("enableBuyGUI", true);
        enableSellGUI = config.getBoolean("enableSellGUI", true);
        returnToShop = config.getBoolean("returnToShop", true);
        quickBuySell = config.getBoolean("quickBuySell", false);
        enableSellGUISellAll = config.getBoolean("enableSellGUISellAll", true);
        hideBuyPriceForUnbuyable = config.getBoolean("hideBuyPriceForUnbuyable", true);
        hideSellPriceForUnsellable = config.getBoolean("hideSellPriceForUnsellable", true);
        logToConsole = config.getBoolean("log.toConsole", false);
        logToFile = config.getBoolean("log.toFile", false);
        enableAmountSelectionFix = config.getBoolean("enableAmountSelectionFix", false);
        allowAllSellAllStackSizes = config.getBoolean("allowAllSellAllStackSizes", false);
        disableMainMenu = config.getBoolean("disableMainMenu", false);
        useDifferentMessagesForFreeItems = config.getBoolean("useDifferentMessagesForFreeItems", false);
        limitEnchantmentLevelDiff = config.getBoolean("limitEnchantmentLevelDiff", false);
        numberFormatHideFraction = config.getBoolean("numberFormat.hideFraction", true);
        displayPriceModifiersInPercents = config.getBoolean("displayPriceModifiersInPercents", true);
        disableSudoWorldPermissionCheck = config.getBoolean("disableSudoWorldPermissionCheck", false);
        disableSudoShopPermissionCheck = config.getBoolean("disableSudoShopPermissionCheck", false);
        disableUnsafeEnchantmentCheck = config.getBoolean("disableUnsafeEnchantmentCheck", false);
        capitalizeItemNames = config.getBoolean("capitalizeItemNames", true);
        closeGuiAfterSellAll = config.getBoolean("closeGuiAfterSellAll", false);
        openBulkGuiImmediately = config.getBoolean("openBulkGuiImmediately", false);
        sudoAllowAllShopsAccess = config.getBoolean("sudoAllowAllShopsAccess", false);
        sellHandAllowAllQuantities = config.getBoolean("sellHand.allowAllQuantities", true);
        sellHandSellsAllItems = config.getBoolean("sellHand.sellsAllItems", false);
        sellHandExcludeFreeItems = config.getBoolean("sellHand.excludeFreeItems", true);
        sellHandExcludeArmorSlots = config.getBoolean("sellHand.excludeArmorSlots", true);
        sellHandExcludeOffHand = config.getBoolean("sellHand.excludeOffHand", false);
        sellAllDetailedSummary = config.getBoolean("sellAll.detailedSummary", false);
        sellAllFindMaxSellPrice = config.getBoolean("sellAll.findMaxSellPrice", true);
        sellAllExcludeFreeItems = config.getBoolean("sellAll.excludeFreeItems", true);
        sellAllExcludeArmorSlots = config.getBoolean("sellAll.excludeArmorSlots", true);
        sellAllExcludeOffHand = config.getBoolean("sellAll.excludeOffHand", false);
        defaultItemSettingsCompareMeta = config.getBoolean("defaultItemSettings.compareMeta", false);
        defaultItemSettingsStripItemMeta = config.getBoolean("defaultItemSettings.stripItemMeta", false);
        defaultItemSettingsCompareModel = config.getBoolean("defaultItemSettings.compareModel", true);
        defaultItemSettingsCompareDamage = config.getBoolean("defaultItemSettings.compareDamage", false);
        defaultItemSettingsCompareNbt = config.getBoolean("defaultItemSettings.compareNbt", false);
        enforceDefaultStackSize = config.getBoolean("enforceDefaultStackSize", true);
        disablePermissionCache = config.getBoolean("disablePermissionCache", false);
        numberFormatEnableShortScale = config.getBoolean("numberFormat.shortScale.enableShortScaleNumbering", false);
        databaseMySQLPort = config.getInt("database.mySQLPort", 3306);
        shopMenuSize = config.getInt("shopMenuSize", 9);
        maxEnchantments = config.getInt("maxEnchantments", -1);
        numberFormatMinimumIntegerDigits = config.getInt("numberFormat.minimumIntegerDigits", 1);
        numberFormatMaximumIntegerDigits = config.getInt("numberFormat.maximumIntegerDigits", 32);
        numberFormatMinimumFractionDigits = config.getInt("numberFormat.minimumFractionDigits", 0);
        numberFormatMaximumFractionDigits = config.getInt("numberFormat.maximumFractionDigits", 8);
        numberFormatShortHandDecimalLimit = config.getInt("numberFormat.shortScale.shortHandDecimalLimit", 2);
        numberFormatShortHandNumberLimit = config.getInt("numberFormat.shortScale.shortHandNumberLimit", 32);
        numberFormatShortScaleLimit = config.getInt("numberFormat.shortScale.shortScaleLimit", 1000000);
        guiClickCooldown = config.getLong("gui.clickCooldown", 250L);
        economyTypes.clear();
        shopItemLoreFormatItem.clear();
        shopItemLoreFormatItemBuyGUI.clear();
        shopItemLoreFormatItemSellGUI.clear();
        shopItemLoreFormatItemSellGUISellAll.clear();
        shopItemLoreFormatPermission.clear();
        shopItemLoreFormatEnchantment.clear();
        shopItemLoreFormatCommand.clear();
        disableShopsInWorlds.clear();
        disableShopsInGamemodes.clear();
        specialElements.clear();
        databaseMySQLParameters.clear();
        currencyPrefixes.clear();
        currencySuffixes.clear();
        clickActions.clear();
        if (config.isString("economyType")) {
            economyTypes.add(EconomyType.valueOf(config.getString("economyType")));
        } else {
            configurationSection = config.getStringList("economyTypes");
            if (configurationSection != null) {
                iterator2 = configurationSection.iterator();
                while (iterator2.hasNext()) {
                    object2 = (String)iterator2.next();
                    try {
                        object = EconomyType.valueOf((String)object2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        continue;
                    }
                    economyTypes.add((EconomyType)((Object)object));
                }
            }
        }
        clickActions.load(config.getConfigurationSection("clickActions"), true);
        if (config.getStringList("shopItemLoreFormat.item") != null) {
            shopItemLoreFormatItem = config.getStringList("shopItemLoreFormat.item");
        }
        if (config.getStringList("shopItemLoreFormat.itemBuyGUI") != null) {
            shopItemLoreFormatItemBuyGUI = config.getStringList("shopItemLoreFormat.itemBuyGUI");
        }
        if (config.getStringList("shopItemLoreFormat.itemSellGUI") != null) {
            shopItemLoreFormatItemSellGUI = config.getStringList("shopItemLoreFormat.itemSellGUI");
        }
        if (config.getStringList("shopItemLoreFormat.itemSellGUISellAll") != null) {
            shopItemLoreFormatItemSellGUISellAll = config.getStringList("shopItemLoreFormat.itemSellGUISellAll");
        }
        if (config.getStringList("shopItemLoreFormat.permission") != null) {
            shopItemLoreFormatPermission = config.getStringList("shopItemLoreFormat.permission");
        }
        if (config.getStringList("shopItemLoreFormat.enchantment") != null) {
            shopItemLoreFormatEnchantment = config.getStringList("shopItemLoreFormat.enchantment");
        }
        if (config.getStringList("shopItemLoreFormat.command") != null) {
            shopItemLoreFormatCommand = config.getStringList("shopItemLoreFormat.command");
        }
        if (config.getStringList("disableShopsInWorlds") != null) {
            disableShopsInWorlds = config.getStringList("disableShopsInWorlds");
        }
        Settings.loadGuiSpecialElement(GuiSpecialElementType.BALANCE);
        if (config.getStringList("disableShopsInGamemodes") != null) {
            configurationSection = new ArrayList();
            for (Iterator iterator2 : config.getStringList("disableShopsInGamemodes")) {
                try {
                    object2 = GameMode.valueOf((String)((String)((Object)iterator2)).toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                configurationSection.add(object2);
            }
            disableShopsInGamemodes = configurationSection;
        }
        if ((configurationSection = config.getConfigurationSection("database.mySQLParameters")) != null) {
            for (Iterator iterator2 : configurationSection.getKeys(false)) {
                databaseMySQLParameters.put((String)((Object)iterator2), configurationSection.getString((String)((Object)iterator2)));
            }
        }
        currencyPrefixes.put(EconomyType.VAULT.name(), "$");
        currencySuffixes.put(EconomyType.EXP.name(), " exp");
        currencySuffixes.put(EconomyType.EXP_LEVELS.name(), " exp levels");
        currencySuffixes.put(EconomyType.MYSQL_TOKENS.name(), " tokens");
        currencySuffixes.put(EconomyType.PLAYER_POINTS.name(), " points");
        currencySuffixes.put(EconomyType.TOKEN_ENCHANT.name(), " tokens");
        currencySuffixes.put(EconomyType.TOKEN_MANAGER.name(), " tokens");
        currencySuffixes.put(EconomyType.VOTING_PLUGIN.name(), " points");
        object = config.getConfigurationSection("currencies.prefixes");
        if (object != null) {
            iterator2 = object.getKeys(false).iterator();
            while (iterator2.hasNext()) {
                object2 = (String)iterator2.next();
                currencyPrefixes.put((String)object2, object.getString((String)object2));
            }
        }
        if ((iterator2 = config.getConfigurationSection("currencies.suffixes")) != null) {
            for (String string : iterator2.getKeys(false)) {
                currencySuffixes.put(string, iterator2.getString(string));
            }
        }
        try {
            databaseType = DataManager.DatabaseType.valueOf(config.getString("database.type").toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            databaseType = DataManager.DatabaseType.SQLITE;
        }
        try {
            priceRoundType = RoundType.valueOf(config.getString("roundPrices").toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            priceRoundType = RoundType.NONE;
        }
        try {
            priceModifiersType = PriceModifierType.valueOf(config.getString("priceModifiersType").toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            priceModifiersType = PriceModifierType.BOTH;
        }
    }

    public static double parsePrice(double d) {
        switch (priceRoundType) {
            case DOWN: {
                return Math.floor(d);
            }
            case NEAREST: {
                return Math.round(d);
            }
            default: {
                return d;
            }
            case UP: 
        }
        return Math.ceil(d);
    }

    public static int getMaxStackSize(ItemStack itemStack) {
        ItemStackSizeLimitEntry itemStackSizeLimitEntry = null;
        if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_9) && (itemStack.getType() == Material.POTION || itemStack.getType() == Material.LINGERING_POTION || itemStack.getType() == Material.SPLASH_POTION) && itemStack.hasItemMeta()) {
            for (ItemStackSizeLimitEntry itemStackSizeLimitEntry2 : itemStackSizeCappedAt) {
                if (!ItemUtils.compareItemStacks(itemStack, itemStackSizeLimitEntry2.getItemStack(), false, false, false, false, true)) continue;
                itemStackSizeLimitEntry = itemStackSizeLimitEntry2;
            }
        }
        if (itemStackSizeLimitEntry == null) {
            for (ItemStackSizeLimitEntry itemStackSizeLimitEntry2 : itemStackSizeCappedAt) {
                if (!ItemUtils.compareItemStacks(itemStack, itemStackSizeLimitEntry2.getItemStack(), false, false, false, false, itemStackSizeLimitEntry2.isComparePotion())) continue;
                itemStackSizeLimitEntry = itemStackSizeLimitEntry2;
            }
        }
        if (itemStackSizeLimitEntry != null) {
            return itemStackSizeLimitEntry.getLimit();
        }
        return enforceDefaultStackSize ? itemStack.getMaxStackSize() : 64;
    }

    public static String formatModifierString(double d) {
        return displayPriceModifiersInPercents ? ChatUtils.formatDoubleString(d * 100.0) + "%" : ChatUtils.formatDoubleString(d);
    }

    private static void loadGuiSpecialElement(GuiSpecialElementType guiSpecialElementType) {
        ItemStack itemStack = null;
        try {
            itemStack = ItemUtils.loadItemStackFromConfig((ConfigurationSection)config, "specialElements." + guiSpecialElementType.toString().toLowerCase() + ".item");
        }
        catch (ItemLoadException itemLoadException) {
            ShopGuiPlugin.getInstance().warning("Error occurred when loading specialElements > " + guiSpecialElementType.toString().toLowerCase() + "  (config.yml), item not loaded: " + itemLoadException.getMessage());
            return;
        }
        specialElements.add(new GuiSpecialElement(guiSpecialElementType, itemStack));
    }

    public static GuiSpecialElement getGuiSpecialElement(GuiSpecialElementType guiSpecialElementType) {
        for (GuiSpecialElement guiSpecialElement : specialElements) {
            if (guiSpecialElement.getType() != guiSpecialElementType) continue;
            return guiSpecialElement;
        }
        return null;
    }

    public static String getCurrencyPrefix(EconomyType economyType) {
        return ChatUtils.fixColors(currencyPrefixes.get(economyType.name()));
    }

    public static String getCurrencySuffix(EconomyType economyType) {
        return ChatUtils.fixColors(currencySuffixes.get(economyType.name()));
    }

    static {
        economyTypes = new LinkedHashSet<EconomyType>();
        shopItemLoreFormatItem = new ArrayList<String>();
        shopItemLoreFormatItemBuyGUI = new ArrayList<String>();
        shopItemLoreFormatItemSellGUI = new ArrayList<String>();
        shopItemLoreFormatItemSellGUISellAll = new ArrayList<String>();
        shopItemLoreFormatPermission = new ArrayList<String>();
        shopItemLoreFormatEnchantment = new ArrayList<String>();
        shopItemLoreFormatCommand = new ArrayList<String>();
        disableShopsInWorlds = new ArrayList<String>();
        disableShopsInGamemodes = new ArrayList<GameMode>();
        itemStackSizeCappedAt = new LinkedHashSet<ItemStackSizeLimitEntry>();
        specialElements = new ArrayList<GuiSpecialElement>();
        databaseMySQLParameters = new HashMap<String, String>();
        currencyPrefixes = new HashMap<String, String>();
        currencySuffixes = new HashMap<String, String>();
        clickActions = new GuiClickActions();
    }

    public static enum RoundType {
        DOWN,
        NEAREST,
        NONE,
        UP;

    }
}

