/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.command.shop;

import java.util.List;
import java.util.Map;
import net.brcdev.shopgui.config.Lang;
import net.brcdev.shopgui.core.BSubCommand;
import net.brcdev.shopgui.database.Callback;
import net.brcdev.shopgui.exception.player.PlayerDataNotLoadedException;
import net.brcdev.shopgui.modifier.PriceModifierEntry;
import net.brcdev.shopgui.modifier.PriceModifierScope;
import net.brcdev.shopgui.modifier.command.CommandPriceModifiers;
import net.brcdev.shopgui.modifier.permission.PermissionPriceModifier;
import net.brcdev.shopgui.player.PlayerData;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class CmdShopCheckModifiers
extends BSubCommand {
    public CmdShopCheckModifiers() {
        this.aliases.add("viewmodifiers");
        this.aliases.add("viewmodifier");
        this.aliases.add("checkmodifiers");
        this.aliases.add("checkmodifier");
        this.aliases.add("vm");
        this.aliases.add("cm");
        this.correctUsage = "/shop checkmodifiers <player>";
        this.permission = "shopguiplus.shop.checkmodifiers";
        this.senderMustBePlayer = false;
    }

    @Override
    public void execute() {
        if (this.args.length < 1) {
            this.sendCorrectUsage();
            return;
        }
        final OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)this.args[0]);
        if (offlinePlayer == null) {
            this.msg(Lang.MSG_INVALIDPLAYER.toMsg());
            return;
        }
        if (this.main.getPlayerManager().isPlayerLoaded(offlinePlayer)) {
            try {
                this.handle(offlinePlayer, this.main.getPlayerManager().getPlayerData(offlinePlayer));
            }
            catch (PlayerDataNotLoadedException playerDataNotLoadedException) {
                playerDataNotLoadedException.printStackTrace();
                this.msg(Lang.MSG_ERROR.toMsg());
            }
        } else {
            this.main.getDataManager().retrievePlayerData(offlinePlayer.getName(), new Callback<PlayerData>(){

                @Override
                public void onSuccess(PlayerData playerData) {
                    if (playerData != null) {
                        CmdShopCheckModifiers.this.handle(offlinePlayer, playerData);
                    } else {
                        CmdShopCheckModifiers.this.msg(Lang.MSG_INVALIDPLAYER.toMsg());
                    }
                }

                @Override
                public void onFailure(PlayerData playerData) {
                    CmdShopCheckModifiers.this.msg(Lang.MSG_ERROR.toMsg());
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handle(OfflinePlayer offlinePlayer, PlayerData playerData) {
        CommandPriceModifiers commandPriceModifiers = playerData.getPriceModifiers();
        String string = commandPriceModifiers.getGlobalModifier().formatPlaceholders(Lang.MSG_CMD_SHOP_CHECKMODIFIERS_VIEW_ENTRY_GLOBAL.toString());
        String string2 = "";
        for (Map.Entry<String, PriceModifierEntry> object4 : commandPriceModifiers.getShopModifiers().entrySet()) {
            string2 = string2 + object4.getValue().formatPlaceholders(Lang.MSG_CMD_SHOP_CHECKMODIFIERS_VIEW_ENTRY_SHOP.toString()).replace("%shop%", object4.getKey()) + "\n";
        }
        Object object = "";
        for (Map.Entry<String, Map<String, PriceModifierEntry>> entry : commandPriceModifiers.getItemModifiers().entrySet()) {
            for (Map.Entry<String, PriceModifierEntry> entry2 : entry.getValue().entrySet()) {
                object = (String)object + entry2.getValue().formatPlaceholders(Lang.MSG_CMD_SHOP_CHECKMODIFIERS_VIEW_ENTRY_ITEM.toString()).replace("%shop%", entry.getKey()).replace("%item%", entry2.getKey()) + "\n";
            }
        }
        this.msg(Lang.MSG_CMD_SHOP_CHECKMODIFIERS_VIEW_VIEW.toMsg().replace("%player%", offlinePlayer.getName()).replace("%global%", string).replace("%shop%", string2).replace("%item%", (CharSequence)object));
        if (offlinePlayer.isOnline()) {
            void var10_15;
            Player player = offlinePlayer.getPlayer();
            List<PermissionPriceModifier> list = this.main.getPriceModifierManager().getPermissionPriceModifierManager().getPlayerPermissionPriceModifiers(player);
            Object object2 = "";
            String string3 = "";
            String string4 = "";
            for (PermissionPriceModifier permissionPriceModifier : list) {
                if (permissionPriceModifier.getScope() == PriceModifierScope.GLOBAL) {
                    object2 = (String)object2 + permissionPriceModifier.formatPlaceholders(Lang.MSG_CMD_SHOP_CHECKMODIFIERS_VIEW_ENTRY_GLOBAL.toString()) + "\n";
                    continue;
                }
                if (permissionPriceModifier.getScope() == PriceModifierScope.SHOP) {
                    String string5 = (String)var10_15 + permissionPriceModifier.formatPlaceholders(Lang.MSG_CMD_SHOP_CHECKMODIFIERS_VIEW_ENTRY_SHOP.toString()).replace("%shop%", permissionPriceModifier.getShopId()) + "\n";
                    continue;
                }
                if (permissionPriceModifier.getScope() != PriceModifierScope.ITEM) continue;
                string4 = string4 + permissionPriceModifier.formatPlaceholders(Lang.MSG_CMD_SHOP_CHECKMODIFIERS_VIEW_ENTRY_SHOP.toString()).replace("%shop%", permissionPriceModifier.getShopId()).replace("%item%", permissionPriceModifier.getShopItemId()) + "\n";
            }
            this.msg(Lang.MSG_CMD_SHOP_CHECKMODIFIERS_VIEW_VIEWPERMISSIONMODIFIERS.toMsg().replace("%player%", offlinePlayer.getName()).replace("%global%", (CharSequence)object2).replace("%shop%", (CharSequence)var10_15).replace("%item%", string4));
        }
    }
}

