/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.command.sell;

import net.brcdev.shopgui.command.sell.CmdSellSubcommand;
import net.brcdev.shopgui.config.Lang;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.database.Callback;
import net.brcdev.shopgui.player.PlayerData;
import net.brcdev.shopgui.shop.SellAllResults;
import net.brcdev.shopgui.shop.ShopTransactionResult;
import net.brcdev.shopgui.shop.item.ShopItem;
import net.brcdev.shopgui.util.InventoryUtils;
import net.brcdev.shopgui.util.ItemUtils;
import net.brcdev.shopgui.util.NmsUtils;
import net.brcdev.shopgui.util.NmsVersion;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class CmdSellHandAll
extends CmdSellSubcommand {
    public CmdSellHandAll() {
        this.aliases.add("handall");
        this.aliases.add("ha");
        this.correctUsage = "/sell handall";
        this.permission = "shopguiplus.sell.hand.all";
        this.senderMustBePlayer = true;
    }

    @Override
    public void execute() {
        if (this.assertPlayerInAllowedGamemode()) {
            return;
        }
        if (this.assertPlayerInAllowedWorld()) {
            return;
        }
        if (this.assertPlayerHasItemInHand()) {
            return;
        }
        this.main.getPlayerManager().handlePlayerData(this.player, new Callback<PlayerData>(){

            @Override
            public void onSuccess(PlayerData playerData) {
                int n = 0;
                SellAllResults sellAllResults = new SellAllResults();
                ItemStack itemStack = InventoryUtils.getItemInPlayersMainHand(CmdSellHandAll.this.player);
                ShopItem shopItem = CmdSellHandAll.this.main.getShopManager().findShopItemByItemStack(CmdSellHandAll.this.player, playerData, itemStack, Settings.sellHandExcludeFreeItems);
                if (shopItem == null) {
                    CmdSellHandAll.this.msg(Lang.MSG_SELLHAND_CANNOTSELL.toMsg());
                    return;
                }
                ItemStack[] itemStackArray = CmdSellHandAll.this.player.getInventory().getContents();
                boolean bl = Settings.sellHandExcludeArmorSlots;
                boolean bl2 = Settings.sellHandExcludeOffHand && NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_9);
                for (int i = 0; i < itemStackArray.length; ++i) {
                    ShopTransactionResult shopTransactionResult;
                    ItemStack itemStack2;
                    if (bl && i >= 36 && i <= 39 || bl2 && i == 40 || !ItemUtils.compareItemStacks(itemStack, itemStack2 = itemStackArray[i], shopItem.isCompareMeta(), shopItem.isCompareModel(), shopItem.isCompareDamage(), shopItem.isCompareNbt()) || (shopTransactionResult = CmdSellHandAll.this.main.getShopManager().handleItemSellAll(CmdSellHandAll.this.player, shopItem, false)).getResult() != ShopTransactionResult.ShopTransactionResultType.SUCCESS) continue;
                    n += shopTransactionResult.getAmount();
                    sellAllResults.addSellResult(shopItem, shopTransactionResult.getAmount(), shopTransactionResult.getPrice());
                    CmdSellHandAll.this.player.getInventory().setItem(i, new ItemStack(Material.AIR, 1));
                }
                if (n > 0) {
                    CmdSellHandAll.this.player.updateInventory();
                    if (Settings.sellAllDetailedSummary) {
                        CmdSellHandAll.this.msg(Lang.MSG_SELLHANDALL_SOLD.toMsg().replace("%quantity%", String.valueOf(n)).replace("%item%", ItemUtils.formatItemName(itemStack, CmdSellHandAll.this.player)).replace("%price%", sellAllResults.getTotalEarningsList()));
                    } else {
                        CmdSellHandAll.this.msg(Lang.MSG_SELLHANDALL_SOLD.toMsg().replace("%quantity%", String.valueOf(n)).replace("%item%", ItemUtils.formatItemName(itemStack, CmdSellHandAll.this.player)).replace("%price%", sellAllResults.getTotalEarningsList()));
                    }
                }
            }

            @Override
            public void onFailure(PlayerData playerData) {
                CmdSellHandAll.this.msg(Lang.MSG_ERROR.toMsg());
            }
        });
    }
}

