/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.command;

import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.command.shop.CmdShopAddModifier;
import net.brcdev.shopgui.command.shop.CmdShopCheck;
import net.brcdev.shopgui.command.shop.CmdShopCheckModifiers;
import net.brcdev.shopgui.command.shop.CmdShopReload;
import net.brcdev.shopgui.command.shop.CmdShopResetModifier;
import net.brcdev.shopgui.config.Lang;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.core.BCommand;
import net.brcdev.shopgui.core.BSubCommand;
import net.brcdev.shopgui.permission.PermissionManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CmdShop
extends BCommand
implements CommandExecutor {
    public CmdShop(ShopGuiPlugin shopGuiPlugin) {
        super(shopGuiPlugin);
        this.subcommands.add(new CmdShopAddModifier());
        this.subcommands.add(new CmdShopCheck());
        this.subcommands.add(new CmdShopCheckModifiers());
        this.subcommands.add(new CmdShopReload());
        this.subcommands.add(new CmdShopResetModifier());
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        Player player;
        if (!this.main.getShopManager().areShopsLoaded()) {
            commandSender.sendMessage(Lang.MSG_NOTLOADED.toMsg());
            return true;
        }
        if (stringArray.length < 1) {
            if (!(commandSender instanceof Player)) {
                commandSender.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_INGAMEONLY.toString());
                return true;
            }
            if (Settings.disableMainMenu) {
                commandSender.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_MAINMENUDISABLED.toString());
                return true;
            }
            Player player2 = (Player)commandSender;
            if (!PermissionManager.hasPermission(player2, "shopguiplus.bypassgamemode") && Settings.disableShopsInGamemodes.contains(player2.getGameMode())) {
                commandSender.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_GAMEMODEBANNED.toString().replace("%gamemode%", player2.getGameMode().toString().toLowerCase()));
                return true;
            }
            if (!PermissionManager.hasPermission(player2, "shopguiplus.bypassworld") && Settings.disableShopsInWorlds.contains(player2.getLocation().getWorld().getName())) {
                commandSender.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_WORLDBANNED.toString().replace("%world%", player2.getLocation().getWorld().getName()));
                return true;
            }
            if (PermissionManager.hasPermission(player2, "shopguiplus.shop")) {
                this.main.getShopManager().openMainMenu(player2);
            } else {
                player2.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_NOACCESS.toString());
            }
            return true;
        }
        for (BSubCommand bSubCommand : this.subcommands) {
            if (!bSubCommand.aliases.contains(stringArray[0])) continue;
            bSubCommand.execute(commandSender, stringArray);
            return true;
        }
        if (Bukkit.getPlayer((String)stringArray[0]) != null) {
            player = Bukkit.getPlayer((String)stringArray[0]);
            if (commandSender.hasPermission("shopguiplus.others")) {
                if (Settings.disableShopsInGamemodes.contains(player.getGameMode())) {
                    commandSender.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_GAMEMODEBANNEDTARGET.toString().replace("%player%", player.getName()).replace("%gamemode%", player.getGameMode().toString().toLowerCase()));
                    return true;
                }
                if (!Settings.disableSudoWorldPermissionCheck && Settings.disableShopsInWorlds.contains(player.getLocation().getWorld().getName())) {
                    commandSender.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_WORLDBANNEDTARGET.toString().replace("%player%", player.getName()).replace("%world%", player.getLocation().getWorld().getName()));
                    return true;
                }
                if (stringArray.length >= 2) {
                    this.main.getShopManager().openShopMenu(Bukkit.getPlayer((String)stringArray[0]), stringArray[1], false);
                } else {
                    if (Settings.disableMainMenu) {
                        commandSender.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_MAINMENUDISABLED.toString());
                        return true;
                    }
                    this.main.getShopManager().openMainMenu(player, Settings.sudoAllowAllShopsAccess);
                }
            } else {
                commandSender.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_NOACCESS.toString());
            }
            return true;
        }
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_INGAMEONLY.toString());
            return true;
        }
        player = (Player)commandSender;
        if (!PermissionManager.hasPermission(player, "shopguiplus.bypassgamemode") && Settings.disableShopsInGamemodes.contains(player.getGameMode())) {
            commandSender.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_GAMEMODEBANNED.toString().replace("%gamemode%", player.getGameMode().toString().toLowerCase()));
            return true;
        }
        if (!PermissionManager.hasPermission(player, "shopguiplus.bypassworld") && Settings.disableShopsInWorlds.contains(player.getLocation().getWorld().getName())) {
            commandSender.sendMessage((Object)((Object)Lang.PREFIX) + Lang.MSG_WORLDBANNED.toString().replace("%world%", player.getLocation().getWorld().getName()));
            return true;
        }
        this.main.getShopManager().openShopMenu(player, stringArray[0], true);
        return true;
    }
}

