/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.cache.permission;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.brcdev.shopgui.cache.permission.PermissionCacheKey;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PermissionCache {
    private static LoadingCache<PermissionCacheKey, Boolean> permissionCache = CacheBuilder.newBuilder().maximumSize(500L).expireAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<PermissionCacheKey, Boolean>(){

        public Boolean load(PermissionCacheKey permissionCacheKey) {
            Player player = Bukkit.getPlayer((UUID)permissionCacheKey.getUuid());
            return player != null && player.hasPermission(permissionCacheKey.getPermission());
        }
    });

    public static boolean hasPermission(Player player, String string) {
        try {
            PermissionCacheKey permissionCacheKey = new PermissionCacheKey(player.getUniqueId(), string);
            return (Boolean)permissionCache.get((Object)permissionCacheKey);
        }
        catch (ExecutionException executionException) {
            return false;
        }
    }
}

