/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.svenar.powerranks.common.utils.Color;

public class PowerColor {
    public static final char UNFORMATTED_COLOR_CHAR = '&';
    public static final char COLOR_CHAR = '\u00a7';
    private final String ALL_COLOR_CODES = "0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx";
    private Map<String, String> hexToMCColors = new HashMap<String, String>();
    private final String[] rainbowHEXColors = new String[]{"#E81416", "#FFA500", "#FAEB36", "#79C314", "#487DE7", "#4B369D", "#70369D"};

    public PowerColor() {
        this.hexToMCColors.put("#000000", "0");
        this.hexToMCColors.put("#00002A", "1");
        this.hexToMCColors.put("#002A00", "2");
        this.hexToMCColors.put("#002A2A", "3");
        this.hexToMCColors.put("#2A0000", "4");
        this.hexToMCColors.put("#2A002A", "5");
        this.hexToMCColors.put("#2A2A00", "6");
        this.hexToMCColors.put("#2A2A2A", "7");
        this.hexToMCColors.put("#151515", "8");
        this.hexToMCColors.put("#15153F", "9");
        this.hexToMCColors.put("#153F15", "a");
        this.hexToMCColors.put("#153F3F", "b");
        this.hexToMCColors.put("#3F1515", "c");
        this.hexToMCColors.put("#3F153F", "d");
        this.hexToMCColors.put("#3F3F15", "e");
        this.hexToMCColors.put("#3F3F3F", "f");
    }

    public String formatHEX(char altColorChar, String text) {
        Pattern HEXPattern = Pattern.compile(altColorChar + "?#[a-fA-F0-9]{6}");
        Matcher HEXMatcher = HEXPattern.matcher(text);
        StringBuilder result = new StringBuilder(text.length());
        int lastAppendPosition = 0;
        while (HEXMatcher.find()) {
            String rawHEX = text.substring(HEXMatcher.start(), HEXMatcher.end());
            String formattedHEX = rawHEX.startsWith(altColorChar + "") ? rawHEX.substring(1) : rawHEX;
            StringBuilder magic = new StringBuilder(altColorChar + "x");
            for (int i = 1; i < formattedHEX.length(); ++i) {
                magic.append(altColorChar).append(formattedHEX.charAt(i));
            }
            formattedHEX = magic.toString();
            result.append(text, lastAppendPosition, HEXMatcher.start()).append(formattedHEX);
            lastAppendPosition = HEXMatcher.end();
        }
        result.append(text.substring(lastAppendPosition));
        return result.toString();
    }

    public String formatSpecial(char altColorChar, String text) {
        text = this.parseGradient(altColorChar, text);
        text = text + altColorChar + "r";
        text = this.parseRainbow(altColorChar, text);
        text = text + altColorChar + "r";
        text = text.replaceAll(altColorChar + "r" + altColorChar + "r", altColorChar + "r");
        return text;
    }

    public String parseGradient(char altColorChar, String input) {
        int patternStart = input.indexOf("[gradient=");
        if (patternStart == -1) {
            return input;
        }
        int inputLength = input.length();
        char[] inputChars = input.toCharArray();
        int lastAppendPosition = 0;
        Pattern pattern = Pattern.compile("\\[gradient=([^,]+),([^\\]]+)\\]([^\\[]+)\\[/gradient\\]");
        Matcher matcher = pattern.matcher(input);
        StringBuilder result = new StringBuilder();
        while (matcher.find(patternStart)) {
            String startColor = matcher.group(1);
            String endColor = matcher.group(2);
            String content = matcher.group(3);
            String gradient = this.generateGradient(startColor, endColor, content);
            result.append(inputChars, lastAppendPosition, matcher.start() - lastAppendPosition);
            result.append(gradient);
            patternStart = lastAppendPosition = matcher.end();
            matcher.region(patternStart, inputLength);
        }
        result.append(inputChars, lastAppendPosition, inputLength - lastAppendPosition);
        return result.toString();
    }

    public String parseRainbow(char altColorChar, String input) {
        Matcher matcher;
        int patternStart = input.indexOf("[rainbow]");
        if (patternStart == -1) {
            return input;
        }
        int inputLength = input.length();
        StringBuilder result = new StringBuilder();
        int lastAppendPosition = 0;
        Pattern pattern = Pattern.compile("\\[rainbow\\]([^\\[]+)\\[/rainbow\\]");
        while ((matcher = pattern.matcher(input)).find(patternStart)) {
            String content = matcher.group(1);
            String rainbow = this.generateRainbow(content);
            result.append(input, lastAppendPosition, matcher.start()).append(rainbow);
            lastAppendPosition = matcher.end();
            patternStart = lastAppendPosition;
            if (patternStart < inputLength) continue;
        }
        result.append(input, lastAppendPosition, inputLength);
        return result.toString();
    }

    private List<String> generateGradientColors(String startColor, String endColor, int length) {
        ArrayList<String> result = new ArrayList<String>(length);
        Color numColor1 = this.hexToRGB(startColor);
        Color numColor2 = this.hexToRGB(endColor);
        for (int i = 0; i < length; ++i) {
            double ratio = (double)i / (double)(length - 1);
            int r = (int)((double)numColor1.getRed() * (1.0 - ratio) + (double)numColor2.getRed() * ratio);
            int g = (int)((double)numColor1.getGreen() * (1.0 - ratio) + (double)numColor2.getGreen() * ratio);
            int b = (int)((double)numColor1.getBlue() * (1.0 - ratio) + (double)numColor2.getBlue() * ratio);
            result.add('#' + this.toHexString(r) + this.toHexString(g) + this.toHexString(b));
        }
        return result;
    }

    private String generateGradient(String startColor, String endColor, String content) {
        StringBuilder result = new StringBuilder();
        Color numColor1 = this.hexToRGB(startColor);
        Color numColor2 = this.hexToRGB(endColor);
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            double ratio = (double)i / (double)(content.length() - 1);
            int r = (int)((double)numColor1.getRed() * (1.0 - ratio) + (double)numColor2.getRed() * ratio);
            int g = (int)((double)numColor1.getGreen() * (1.0 - ratio) + (double)numColor2.getGreen() * ratio);
            int b = (int)((double)numColor1.getBlue() * (1.0 - ratio) + (double)numColor2.getBlue() * ratio);
            result.append('#');
            result.append(this.toHexString(r));
            result.append(this.toHexString(g));
            result.append(this.toHexString(b));
            result.append(c);
        }
        return result.toString();
    }

    private List<String> generateRainbowColors(int length) {
        int numColors = this.rainbowHEXColors.length;
        ArrayList<String> result = new ArrayList<String>(length);
        if (length <= 9) {
            int step = Math.round((float)numColors / (float)length);
            int index = 0;
            for (int i = 0; i < length; ++i) {
                String color = this.rainbowHEXColors[index % numColors];
                index += step;
                result.add(color);
            }
        } else {
            int rainbowStep = Math.round((float)length / (float)(numColors - 1));
            for (int i = 0; i < numColors - 1; ++i) {
                int start = i * rainbowStep;
                int end = i != numColors - 2 ? (i + 1) * rainbowStep : length;
                String fromhex = this.rainbowHEXColors[i];
                String tohex = this.rainbowHEXColors[i + 1];
                if (start >= end) continue;
                List<String> rainbowGradientPart = this.interpolateColors(fromhex, tohex, end - start);
                for (int j = start; j < end; ++j) {
                    result.add(rainbowGradientPart.get(j - start));
                }
            }
        }
        return result;
    }

    private String generateRainbow(String text) {
        int numColors = this.rainbowHEXColors.length;
        StringBuilder result = new StringBuilder();
        if (text.length() <= 9) {
            int step = Math.round((float)numColors / (float)text.length());
            int index = 0;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                String color = this.rainbowHEXColors[index % numColors];
                index += step;
                result.append(color);
                result.append(c);
            }
        } else {
            int rainbowStep = Math.round((float)text.length() / (float)(numColors - 1));
            for (int i = 0; i < numColors - 1; ++i) {
                int start = i * rainbowStep;
                int end = i != numColors - 2 ? (i + 1) * rainbowStep : text.length();
                String fromhex = this.rainbowHEXColors[i];
                String tohex = this.rainbowHEXColors[i + 1];
                if (start >= end) continue;
                List<String> rainbowGradientPart = this.interpolateColors(fromhex, tohex, end - start);
                for (int j = start; j < end; ++j) {
                    result.append(rainbowGradientPart.get(j - start)).append(text.charAt(j));
                }
            }
        }
        return result.toString();
    }

    private String toHexString(int value) {
        char[] hexChars = new char[]{Character.forDigit(value >> 4 & 0xF, 16), Character.forDigit(value & 0xF, 16)};
        return new String(hexChars);
    }

    public String formatColor(char altColorChar, String text) {
        char[] b = text.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != altColorChar || "0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx".indexOf(b[i + 1]) <= -1) continue;
            b[i] = 167;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }

    public String hexCompatibilityConverter(char altColorChar, String inputHEX) {
        String output = "";
        int last_distance = Integer.MAX_VALUE;
        Color input_color = this.hexToRGB(inputHEX);
        for (Map.Entry<String, String> entry : this.hexToMCColors.entrySet()) {
            int distance = this.calculateColorDistance(input_color, this.hexToRGB(entry.getKey()));
            if (distance >= last_distance) continue;
            last_distance = distance;
            output = altColorChar + entry.getValue();
        }
        return output;
    }

    public int calculateColorDistance(Color color1, Color color2) {
        int distance = Integer.MAX_VALUE;
        distance = (int)Math.round(Math.sqrt(Math.pow(color1.getRed() - color2.getRed(), 2.0) + Math.pow(color1.getGreen() - color2.getGreen(), 2.0) + Math.pow(color1.getBlue() - color2.getBlue(), 2.0)));
        return distance;
    }

    private Color hexToRGB(String colorStr) {
        return Color.fromRGB(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
    }

    public String interpolateColor(String color1, String color2, double factor) {
        if (factor < 0.0) {
            throw new IllegalArgumentException("Invalid factor");
        }
        if (!color1.startsWith("#") && color1.length() != 7) {
            throw new IllegalArgumentException("Invalid color1");
        }
        if (!color2.startsWith("#") && color2.length() != 7) {
            throw new IllegalArgumentException("Invalid color2");
        }
        int red1 = Integer.parseInt(color1.substring(1, 3), 16);
        int green1 = Integer.parseInt(color1.substring(3, 5), 16);
        int blue1 = Integer.parseInt(color1.substring(5, 7), 16);
        int red2 = Integer.parseInt(color2.substring(1, 3), 16);
        int green2 = Integer.parseInt(color2.substring(3, 5), 16);
        int blue2 = Integer.parseInt(color2.substring(5, 7), 16);
        int red = (int)((double)red1 * (1.0 - factor) + (double)red2 * factor);
        int green = (int)((double)green1 * (1.0 - factor) + (double)green2 * factor);
        int blue = (int)((double)blue1 * (1.0 - factor) + (double)blue2 * factor);
        StringBuilder result = new StringBuilder("#");
        result.append(this.toHexString(red));
        result.append(this.toHexString(green));
        result.append(this.toHexString(blue));
        return result.toString();
    }

    public List<String> interpolateColors(String color1, String color2, int steps) {
        if (steps <= 0) {
            throw new IllegalArgumentException("Invalid steps");
        }
        if (!color1.startsWith("#") && color1.length() != 7) {
            throw new IllegalArgumentException("Invalid color1");
        }
        if (!color2.startsWith("#") && color2.length() != 7) {
            throw new IllegalArgumentException("Invalid color2");
        }
        double stepFactor = 1.0 / ((double)steps - 1.0);
        ArrayList<String> interpolatedColorArray = new ArrayList<String>(steps);
        for (int i = 0; i < steps; ++i) {
            interpolatedColorArray.add(this.interpolateColor(color1, color2, stepFactor * (double)i));
        }
        return interpolatedColorArray;
    }

    public String removeFormatSpecial(char altColorChar, String text) {
        text = text.replaceAll("\\[gradient=([^,]+),([^\\]]+)\\]", "");
        text = text.replaceAll("\\[/gradient\\]", "");
        text = text.replaceAll("\\[rainbow\\]", "");
        text = text.replaceAll("\\[/rainbow\\]", "");
        return text;
    }

    public String removeFormatHEX(char altColorChar, String text) {
        text = text.replaceAll("\\&?#[a-fA-F0-9]{6}", "");
        return text;
    }

    public String removeFormatColor(char altColorChar, String text) {
        StringBuilder result = new StringBuilder();
        char[] b = text.toCharArray();
        boolean skipNext = false;
        for (char c : b) {
            if (c == altColorChar) {
                skipNext = true;
                continue;
            }
            if (!skipNext) {
                result.append(c);
                continue;
            }
            skipNext = false;
        }
        return result.toString();
    }

    private String applyMultiColorFlow(String text, String rawColors) {
        String regexColors = "(&[a-fA-F0-9])|(&?#[a-fA-F0-9]{6})";
        String output = "";
        Pattern p = Pattern.compile(regexColors);
        Matcher m = p.matcher(rawColors);
        ArrayList<String> colors = new ArrayList<String>();
        while (m.find()) {
            String color = m.group(0);
            colors.add(color);
        }
        String[] textSplit = text.split("");
        if (colors.size() > 1) {
            int index = 0;
            for (String character : textSplit) {
                output = output + (String)colors.get(index % colors.size()) + character;
                ++index;
            }
        } else {
            output = rawColors + text;
        }
        return output;
    }

    private String[] splitColors(String input) {
        Pattern pattern = Pattern.compile("(&[a-fA-F0-9])|(&?#[a-fA-F0-9]{6})|\\[gradient=[^\\]]+\\]|&#[a-fA-F0-9]{6}|\\[rainbow\\]");
        Matcher matcher = pattern.matcher(input);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        String[] result = new String[count];
        matcher.reset();
        int index = 0;
        while (matcher.find()) {
            result[index++] = matcher.group();
        }
        return result;
    }

    public String formatAroundMessage(String message, String colors) {
        StringBuilder result = new StringBuilder();
        if (colors.length() == 0) {
            result.append('&');
            result.append("r");
            result.append(message);
            return result.toString();
        }
        if (colors.indexOf("[gradient=") == -1 && colors.indexOf("[rainbow]") == -1) {
            result.append(this.applyMultiColorFlow(message, colors));
            return result.toString();
        }
        colors = colors.replaceAll("\\[/gradient\\]", "");
        colors = colors.replaceAll("\\[/rainbow\\]", "");
        int numRegularColors = 0;
        int numSpecialColors = 0;
        Matcher matcher = Pattern.compile("(&[a-fA-F0-9])|(&?#[a-fA-F0-9]{6})").matcher(this.removeFormatSpecial('&', colors));
        while (matcher.find()) {
            ++numRegularColors;
        }
        matcher = Pattern.compile("(\\[gradient=([^,]+),([^\\]]+)\\])|(\\[rainbow\\])").matcher(colors);
        while (matcher.find()) {
            ++numSpecialColors;
        }
        int textLengthEachSpecialColor = (message.length() - numRegularColors) / numSpecialColors;
        String[] colorList = this.splitColors(colors);
        ArrayList<String> colorCache = new ArrayList<String>();
        for (String rawColor : colorList) {
            if (rawColor.startsWith("&")) {
                colorCache.add(rawColor);
                continue;
            }
            if (rawColor.startsWith("#") || rawColor.startsWith("&#")) {
                String mcColor = this.hexCompatibilityConverter('&', rawColor);
                colorCache.add(mcColor);
                continue;
            }
            if (rawColor.startsWith("[gradient=")) {
                String[] gradientColors = rawColor.substring(10, rawColor.length() - 1).split(",");
                String startColor = gradientColors[0];
                String endColor = gradientColors[1];
                List<String> generatedColors = this.generateGradientColors(startColor, endColor, textLengthEachSpecialColor);
                colorCache.addAll(generatedColors);
                continue;
            }
            if (!rawColor.startsWith("[rainbow]")) continue;
            List<String> generatedColors = this.generateRainbowColors(textLengthEachSpecialColor);
            colorCache.addAll(generatedColors);
        }
        for (int i = 0; i < message.length(); ++i) {
            char charToColor = message.charAt(i);
            String color = "";
            if (colorCache.size() > 0) {
                color = (String)colorCache.get(0);
                colorCache.remove(0);
            } else {
                color = "&r";
            }
            result.append(color);
            result.append(charToColor);
        }
        return result.toString();
    }
}

