/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.common.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nl.svenar.powerranks.common.structure.PRPlayerRank;
import nl.svenar.powerranks.common.structure.PRRank;
import nl.svenar.powerranks.common.utils.PRCache;

public class PRUtil {
    private static Map<UUID, Long> playerPlayTimeCache = new HashMap<UUID, Long>();

    public static void sortRanksByWeight(List<PRRank> ranks) {
        ranks.removeIf(Objects::isNull);
        ranks.sort(Comparator.comparingInt(PRRank::getWeight));
    }

    public static void reverseRanks(List<PRRank> ranks) {
        Collections.reverse(ranks);
    }

    public static List<PRRank> playerRanksToRanks(List<PRPlayerRank> playerRanks) {
        return playerRanks.stream().map(PRPlayerRank::getName).map(name -> PRCache.getRank(name)).collect(Collectors.toList());
    }

    public static boolean containsIgnoreCase(List<String> objects, String object) {
        for (String obj : objects) {
            if (!obj.equalsIgnoreCase(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean stringContainsItemFromList(String inputStr, String[] items) {
        return Arrays.stream(items).anyMatch(inputStr::contains);
    }

    public static int timeStringToSecondsConverter(String time_input) {
        Matcher regex_int = Pattern.compile("^\\d+[^a-zA-Z]{0,1}$").matcher(time_input);
        Matcher regex_seconds = Pattern.compile("\\d+[sS]").matcher(time_input);
        Matcher regex_minutes = Pattern.compile("\\d+[mM]").matcher(time_input);
        Matcher regex_hours = Pattern.compile("\\d+[hH]").matcher(time_input);
        Matcher regex_days = Pattern.compile("\\d+[dD]").matcher(time_input);
        Matcher regex_weeks = Pattern.compile("\\d+[wW]").matcher(time_input);
        Matcher regex_years = Pattern.compile("\\d+[yY]").matcher(time_input);
        int seconds = 0;
        if (regex_int.find()) {
            seconds = Integer.parseInt(time_input);
        } else {
            if (regex_seconds.find()) {
                seconds += Integer.parseInt(time_input.substring(regex_seconds.start(), regex_seconds.end() - 1));
            }
            if (regex_minutes.find()) {
                seconds += Integer.parseInt(time_input.substring(regex_minutes.start(), regex_minutes.end() - 1)) * 60;
            }
            if (regex_hours.find()) {
                seconds += Integer.parseInt(time_input.substring(regex_hours.start(), regex_hours.end() - 1)) * 3600;
            }
            if (regex_days.find()) {
                seconds += Integer.parseInt(time_input.substring(regex_days.start(), regex_days.end() - 1)) * 86400;
            }
            if (regex_weeks.find()) {
                seconds += Integer.parseInt(time_input.substring(regex_weeks.start(), regex_weeks.end() - 1)) * 604800;
            }
            if (regex_years.find()) {
                seconds += Integer.parseInt(time_input.substring(regex_years.start(), regex_years.end() - 1)) * 31536000;
            }
        }
        return seconds;
    }

    public static <T> T[] array_push(T[] arr, T item) {
        T[] tmp = Arrays.copyOf(arr, arr.length + 1);
        tmp[tmp.length - 1] = item;
        return tmp;
    }

    public static <T> T[] array_pop(T[] arr) {
        T[] tmp = Arrays.copyOf(arr, arr.length - 1);
        return tmp;
    }

    public static ArrayList<String> generateWildcardList(String permission) {
        ArrayList<String> output = new ArrayList<String>();
        CharSequence[] permission_split = permission.split("\\.");
        output.add("*");
        permission_split = PRUtil.array_pop(permission_split);
        for (int i = 0; i < permission_split.length + 1 && permission_split.length != 0; ++i) {
            output.add(String.join((CharSequence)".", permission_split) + ".*");
            permission_split = (String[])PRUtil.array_pop(permission_split);
        }
        return output;
    }

    public static void createDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static boolean deleteDir(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                PRUtil.deleteDir(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    public static void addPlayerPlaytimeCache(UUID playerUUID, long time) {
        playerPlayTimeCache.put(playerUUID, time);
    }

    public static long getPlayerPlaytimeCache(UUID playerUUID) {
        return playerPlayTimeCache.get(playerUUID);
    }

    public static String powerFormatter(String text, Map<String, String> values, char openChar, char closeChar) {
        int endIdx;
        int startIdx;
        StringBuilder result = new StringBuilder();
        int textIdx = 0;
        while ((startIdx = text.indexOf(openChar, textIdx)) != -1 && (endIdx = text.indexOf(closeChar, startIdx + 1)) != -1) {
            if (startIdx < 2 || text.charAt(startIdx - 1) != '\\') {
                result.append(text.substring(textIdx, startIdx));
                textIdx = endIdx + 1;
                String value = values.get(text.substring(startIdx + 1, endIdx));
                if (value != null && !value.isEmpty()) {
                    result.append(value);
                    continue;
                }
                if (result.length() != 0 && result.charAt(result.length() - 1) == ' ') {
                    result.setLength(result.length() - 1);
                    continue;
                }
                if (textIdx < text.length() && text.charAt(textIdx) == ' ') {
                    ++textIdx;
                    continue;
                }
                result.append(openChar + text.substring(startIdx + 1, endIdx) + closeChar);
                continue;
            }
            String unformatted = text.substring(textIdx, endIdx + 1).replaceFirst("\\\\", "");
            if (unformatted.length() > 1) {
                String replaceText = text.substring(startIdx, endIdx + 1);
                String baseText = text.substring(startIdx, startIdx + 1);
                String endText = text.substring(endIdx + 1, endIdx + 1);
                String formattedReplacement = baseText + PRUtil.powerFormatter(text.substring(startIdx + 1, endIdx + 1), values, openChar, closeChar) + endText;
                unformatted = unformatted.replace(replaceText, formattedReplacement);
            }
            result.append(unformatted);
            textIdx = endIdx + 1;
        }
        result.append(text.substring(textIdx));
        return result.toString();
    }
}

