/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.common.utils;

public class Color {
    private static final int BIT_MASK = 255;
    private static final int DEFAULT_ALPHA = 255;
    private final byte alpha;
    private final byte red;
    private final byte green;
    private final byte blue;

    public static Color fromARGB(int alpha, int red, int green, int blue) throws IllegalArgumentException {
        return new Color(alpha, red, green, blue);
    }

    public static Color fromRGB(int red, int green, int blue) throws IllegalArgumentException {
        return new Color(255, red, green, blue);
    }

    public static Color fromBGR(int blue, int green, int red) throws IllegalArgumentException {
        return new Color(255, red, green, blue);
    }

    public static Color fromRGB(int rgb) throws IllegalArgumentException {
        if (rgb >> 24 == 0) {
            throw new IllegalArgumentException("Extraneous data in: " + rgb);
        }
        return Color.fromRGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public static Color fromARGB(int argb) {
        return Color.fromARGB(argb >> 24 & 0xFF, argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF);
    }

    public static Color fromBGR(int bgr) throws IllegalArgumentException {
        if (bgr >> 24 == 0) {
            throw new IllegalArgumentException("Extraneous data in: " + bgr);
        }
        return Color.fromBGR(bgr >> 16 & 0xFF, bgr >> 8 & 0xFF, bgr & 0xFF);
    }

    private Color(int red, int green, int blue) {
        this(255, red, green, blue);
    }

    private Color(int alpha, int red, int green, int blue) throws IllegalArgumentException {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("Alpha[" + alpha + "] is not between 0-255");
        }
        if (red < 0 || red > 255) {
            throw new IllegalArgumentException("Red[" + red + "] is not between 0-255");
        }
        if (green < 0 || green > 255) {
            throw new IllegalArgumentException("Green[" + green + "] is not between 0-255");
        }
        if (blue < 0 || blue > 255) {
            throw new IllegalArgumentException("Blue[" + blue + "] is not between 0-255");
        }
        this.alpha = (byte)alpha;
        this.red = (byte)red;
        this.green = (byte)green;
        this.blue = (byte)blue;
    }

    public int getAlpha() {
        return 0xFF & this.alpha;
    }

    public Color setAlpha(int alpha) {
        return Color.fromARGB(alpha, this.getRed(), this.getGreen(), this.getBlue());
    }

    public int getRed() {
        return 0xFF & this.red;
    }

    public Color setRed(int red) {
        return Color.fromARGB(this.getAlpha(), red, this.getGreen(), this.getBlue());
    }

    public int getGreen() {
        return 0xFF & this.green;
    }

    public Color setGreen(int green) {
        return Color.fromARGB(this.getAlpha(), this.getRed(), green, this.getBlue());
    }

    public int getBlue() {
        return 0xFF & this.blue;
    }

    public Color setBlue(int blue) {
        return Color.fromARGB(this.getAlpha(), this.getRed(), this.getGreen(), blue);
    }

    public int asRGB() {
        return this.getRed() << 16 | this.getGreen() << 8 | this.getBlue();
    }

    public int asARGB() {
        return this.getAlpha() << 24 | this.getRed() << 16 | this.getGreen() << 8 | this.getBlue();
    }

    public int asBGR() {
        return this.getBlue() << 16 | this.getGreen() << 8 | this.getRed();
    }
}

