/*
 * Decompiled with CFR 0.152.
 */
package nl.svenar.powerranks.common.structure;

import java.util.ArrayList;
import java.util.Objects;
import nl.svenar.lib.fasterxml.jackson.annotation.JsonIgnoreProperties;
import nl.svenar.powerranks.common.structure.PRPermission;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PRRank {
    private String name = "";
    private boolean isDefault = false;
    private ArrayList<PRPermission> permissions = new ArrayList();
    private ArrayList<String> inheritances = new ArrayList();
    private String chatPrefix = "";
    private String chatSuffix = "";
    private String chatNamecolor = "";
    private String chatChatcolor = "";
    private ArrayList<String> economyBuyable = new ArrayList();
    private float economyCost = 0.0f;
    private String economyDescription = "";
    private String economyBuyCommand = "";
    private int weight = 0;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public ArrayList<PRPermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(ArrayList<PRPermission> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(PRPermission permission) {
        if (Objects.isNull(this.permissions)) {
            this.permissions = new ArrayList();
        }
        this.permissions.add(permission);
    }

    public void removePermission(PRPermission permission) {
        if (!this.permissions.contains(permission)) {
            return;
        }
        this.permissions.remove(permission);
    }

    public PRPermission getPermission(String name) {
        if (Objects.isNull(this.permissions)) {
            this.permissions = new ArrayList();
        }
        for (PRPermission permission : this.permissions) {
            if (!permission.getName().equals(name)) continue;
            return permission;
        }
        return null;
    }

    public ArrayList<String> getInheritances() {
        return this.inheritances;
    }

    public void setInheritances(ArrayList<String> inheritanceNames) {
        this.inheritances = inheritanceNames;
    }

    public void addInheritance(String inheritanceName) {
        if (Objects.isNull(this.inheritances)) {
            this.inheritances = new ArrayList();
        }
        this.inheritances.add(inheritanceName);
    }

    public void removeInheritance(String inheritanceName) {
        if (Objects.isNull(this.inheritances)) {
            this.inheritances = new ArrayList();
        }
        if (this.inheritances.contains(inheritanceName)) {
            this.inheritances.remove(inheritanceName);
        }
    }

    public void setPrefix(String prefix) {
        this.chatPrefix = prefix;
    }

    public String getPrefix() {
        return this.chatPrefix;
    }

    public void setSuffix(String suffix) {
        this.chatSuffix = suffix;
    }

    public String getSuffix() {
        return this.chatSuffix;
    }

    public void setNamecolor(String namecolor) {
        this.chatNamecolor = namecolor;
    }

    public String getNamecolor() {
        return this.chatNamecolor;
    }

    public void setChatcolor(String chatcolor) {
        this.chatChatcolor = chatcolor;
    }

    public String getChatcolor() {
        return this.chatChatcolor;
    }

    public ArrayList<String> getBuyableRanks() {
        return this.economyBuyable;
    }

    public void setBuyableRanks(ArrayList<String> buyableRankNames) {
        this.economyBuyable = buyableRankNames;
    }

    public void addBuyableRank(String buyableRankName) {
        if (Objects.isNull(this.economyBuyable)) {
            this.economyBuyable = new ArrayList();
        }
        this.economyBuyable.add(buyableRankName);
    }

    public void removeBuyableRank(String buyableRankName) {
        if (Objects.isNull(this.economyBuyable)) {
            this.economyBuyable = new ArrayList();
        }
        if (this.economyBuyable.contains(buyableRankName)) {
            this.economyBuyable.remove(buyableRankName);
        }
    }

    public float getBuyCost() {
        return this.economyCost;
    }

    public void setBuyCost(float economyCost) {
        this.economyCost = economyCost;
    }

    public String getBuyDescription() {
        return this.economyDescription;
    }

    public void setBuyDescription(String description) {
        this.economyDescription = description;
    }

    public String getBuyCommand() {
        return this.economyBuyCommand;
    }

    public void setBuyCommand(String buyCommand) {
        this.economyBuyCommand = buyCommand;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var4_7;
        String output = "name:" + this.name + ", isDefault:" + this.isDefault + ", permissions:[<<PERMISSIONS>>], inheritances:[<<INHERITANCES>>], chatPrefix:" + this.chatPrefix + ", chatSuffix:" + this.chatSuffix + ", chatNamecolor:" + this.chatNamecolor + ", chatChatcolor:" + this.chatChatcolor + ", economyBuyable:" + this.economyBuyable + ", economyCost:" + this.economyCost + ", economyDescription:" + this.economyDescription + ", economyBuyCommand:" + this.economyBuyCommand + ", buyableRanks:[<<BUYABLERANKS>>], weight:" + this.weight + ", economyBuyable:" + this.economyBuyable;
        String permissions = "";
        for (PRPermission pRPermission : this.getPermissions()) {
            permissions = permissions + pRPermission.toString() + ";";
        }
        permissions = permissions.length() > 0 ? permissions.substring(0, permissions.length() - 1) : "";
        String inheritances = "";
        for (String inheritance : this.getInheritances()) {
            inheritances = inheritances + inheritance + ";";
        }
        inheritances = inheritances.length() > 0 ? inheritances.substring(0, inheritances.length() - 1) : "";
        String string = "";
        for (String buyable : this.getBuyableRanks()) {
            String string2 = (String)var4_7 + buyable + ";";
        }
        String string3 = var4_7.length() > 0 ? var4_7.substring(0, var4_7.length() - 1) : "";
        output = output.replaceAll("<<PERMISSIONS>>", permissions);
        output = output.replaceAll("<<INHERITANCES>>", inheritances);
        output = output.replaceAll("<<BUYABLERANKS>>", string3);
        return output;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.toString().hashCode();
        return result;
    }
}

